/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public final class WorkHourEstimateBillHelper {
    public static void writeBackWokrHourData(boolean isAdd, DynamicObject[] estimatedBillArray) {
        if (ArrayUtils.isEmpty((Object[])estimatedBillArray)) {
            return;
        }
        Map<String, DynamicObject> resourcePlanNo2EstimatedBill = Arrays.stream(estimatedBillArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("resourceplan"), dynamicObject -> dynamicObject, (k1, k2) -> k1));
        Object[] resourcePlanArray = WorkHourEstimateBillHelper.loadResourcePlan(resourcePlanNo2EstimatedBill.keySet().toArray());
        if (isAdd) {
            WorkHourEstimateBillHelper.addWorkHourData2ResourcePlan(resourcePlanNo2EstimatedBill, (DynamicObject[])resourcePlanArray);
        } else {
            WorkHourEstimateBillHelper.removeWorkHourData4ResourcePlan((DynamicObject[])resourcePlanArray);
        }
        if (ArrayUtils.isNotEmpty((Object[])resourcePlanArray)) {
            SaveServiceHelper.save((DynamicObject[])resourcePlanArray);
        }
    }

    private static void removeWorkHourData4ResourcePlan(DynamicObject[] resourcePlanArray) {
        for (DynamicObject resourcePlan : resourcePlanArray) {
            DynamicObjectCollection collection = resourcePlan.getDynamicObjectCollection("entry_workhour");
            collection.clear();
            collection = resourcePlan.getDynamicObjectCollection("entry_standard_workhour");
            collection.clear();
            collection = resourcePlan.getDynamicObjectCollection("entry_report_workhour");
            collection.clear();
            resourcePlan.set("sale_routineworkhour", (Object)BigDecimal.ZERO);
            resourcePlan.set("sale_nonroutineworkhour", (Object)BigDecimal.ZERO);
            resourcePlan.set("routineworkhours", (Object)BigDecimal.ZERO);
            resourcePlan.set("nonroutineworkhours", (Object)BigDecimal.ZERO);
            resourcePlan.set("salehours", (Object)BigDecimal.ZERO);
            resourcePlan.set("workhourtype", null);
            resourcePlan.set("estimatebill_id", (Object)0L);
            resourcePlan.set("forecasthours", (Object)BigDecimal.ZERO);
            resourcePlan.set("dayavghours", (Object)BigDecimal.ZERO);
        }
    }

    private static void addWorkHourData2ResourcePlan(Map<String, DynamicObject> resourcePlanNo2EstimatedBill, DynamicObject[] resourcePlanArray) {
        Map<String, List<DynamicObject>> resourcePlanMap = Arrays.stream(resourcePlanArray).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("billno")));
        for (Map.Entry<String, DynamicObject> entry : resourcePlanNo2EstimatedBill.entrySet()) {
            String resourcePlanNo = entry.getKey();
            List<DynamicObject> resourcePlans = resourcePlanMap.get(resourcePlanNo);
            if (CollectionUtils.isEmpty(resourcePlans)) continue;
            DynamicObject workHourEstimateBill = entry.getValue();
            BigDecimal saleRoutineWorkHour = workHourEstimateBill.getBigDecimal("salesrouthours");
            BigDecimal saleNonRoutineWorkHour = workHourEstimateBill.getBigDecimal("salesnorouthours");
            BigDecimal totalSaleWorkHour = workHourEstimateBill.getBigDecimal("tsaleshours");
            BigDecimal totalRoutineWorkHour = workHourEstimateBill.getBigDecimal("totalroutworkhour");
            BigDecimal totalNonRoutineWorkHour = workHourEstimateBill.getBigDecimal("totalnoroutworkhour");
            BigDecimal totoalEstimateWorkHour = workHourEstimateBill.getBigDecimal("totalestimateworkhour");
            BigDecimal dayAvgHours = workHourEstimateBill.getBigDecimal("dayavghours");
            String workHourType = workHourEstimateBill.getString("workhourtype");
            Object estimateBillPkValue = workHourEstimateBill.getPkValue();
            for (DynamicObject resourcePlan : resourcePlans) {
                DynamicObjectCollection estimateWorkHourCollection = resourcePlan.getDynamicObjectCollection("entry_workhour");
                estimateWorkHourCollection.clear();
                DynamicObjectCollection standardWorkHourCollection = resourcePlan.getDynamicObjectCollection("entry_standard_workhour");
                standardWorkHourCollection.clear();
                DynamicObjectCollection reportWorkHourCollection = resourcePlan.getDynamicObjectCollection("entry_report_workhour");
                reportWorkHourCollection.clear();
                WorkHourEstimateBillHelper.wirteBackEstimateWorkHourData(estimateWorkHourCollection, workHourEstimateBill);
                WorkHourEstimateBillHelper.wirteBackStandardWorkHourData(standardWorkHourCollection, workHourEstimateBill);
                WorkHourEstimateBillHelper.wirteBackReportWorkHourData(reportWorkHourCollection, workHourEstimateBill);
                resourcePlan.set("sale_routineworkhour", (Object)saleRoutineWorkHour);
                resourcePlan.set("sale_nonroutineworkhour", (Object)saleNonRoutineWorkHour);
                resourcePlan.set("routineworkhours", (Object)totalRoutineWorkHour);
                resourcePlan.set("nonroutineworkhours", (Object)totalNonRoutineWorkHour);
                resourcePlan.set("salehours", (Object)totalSaleWorkHour);
                resourcePlan.set("workhourtype", (Object)workHourType);
                resourcePlan.set("estimatebill_id", estimateBillPkValue);
                resourcePlan.set("forecasthours", (Object)totoalEstimateWorkHour);
                resourcePlan.set("dayavghours", (Object)dayAvgHours);
            }
        }
    }

    private static void wirteBackReportWorkHourData(DynamicObjectCollection reportWorkHourCollection, DynamicObject estimatedBill) {
        for (DynamicObject workHourEntry : estimatedBill.getDynamicObjectCollection("r_entryentity_summary")) {
            DynamicObject dynamicObject = reportWorkHourCollection.addNew();
            dynamicObject.set("seq", (Object)reportWorkHourCollection.size());
            dynamicObject.set("report_date", (Object)workHourEntry.getDate("r_summary_date"));
            dynamicObject.set("report_workhour", (Object)workHourEntry.getBigDecimal("r_summary_workhour"));
        }
    }

    private static void wirteBackEstimateWorkHourData(DynamicObjectCollection estimateWorkHourCollection, DynamicObject estimatedBill) {
        for (DynamicObject estimateWorkHourEntry : estimatedBill.getDynamicObjectCollection("entryentity_summary")) {
            DynamicObject dynamicObject = estimateWorkHourCollection.addNew();
            dynamicObject.set("seq", (Object)estimateWorkHourCollection.size());
            dynamicObject.set("summary_date", (Object)estimateWorkHourEntry.getDate("summary_date"));
            dynamicObject.set("summary_workhour", (Object)estimateWorkHourEntry.getBigDecimal("summary_workhour"));
            dynamicObject.set("summary_earlyworkhour", (Object)estimateWorkHourEntry.getBigDecimal("summary_earlyworkhour"));
            dynamicObject.set("summary_midworkhour", (Object)estimateWorkHourEntry.getBigDecimal("summary_midworkhour"));
            dynamicObject.set("summary_lateworkhour", (Object)estimateWorkHourEntry.getBigDecimal("summary_lateworkhour"));
        }
    }

    private static void wirteBackStandardWorkHourData(DynamicObjectCollection standardWorkHourCollection, DynamicObject estimatedBill) {
        for (DynamicObject standardWorkHourEntry : estimatedBill.getDynamicObjectCollection("s_entryentity_summary")) {
            DynamicObject dynamicObject = standardWorkHourCollection.addNew();
            dynamicObject.set("seq", (Object)standardWorkHourCollection.size());
            dynamicObject.set("standard_date", (Object)standardWorkHourEntry.getDate("s_summary_date"));
            dynamicObject.set("standard_workhour", (Object)standardWorkHourEntry.getBigDecimal("s_summary_workhour"));
            dynamicObject.set("standard_earlyworkhour", (Object)standardWorkHourEntry.getBigDecimal("s_summary_earlyworkhour"));
            dynamicObject.set("standard_midworkhour", (Object)standardWorkHourEntry.getBigDecimal("s_summary_midworkhour"));
            dynamicObject.set("standard_lateworkhour", (Object)standardWorkHourEntry.getBigDecimal("s_summary_lateworkhour"));
        }
    }

    private static DynamicObject[] loadResourcePlan(Object[] resourcePlanNoArray) {
        String selectFields = "billno, estimatebill_id, forecasthours, sale_routineworkhour, sale_nonroutineworkhour, routineworkhours, nonroutineworkhours, salehours, workhourtype, routineworkhours, dayavghours, entry_workhour.seq, entry_workhour.summary_date, entry_workhour.summary_workhour, entry_workhour.summary_earlyworkhour, entry_workhour.summary_midworkhour, entry_workhour.summary_lateworkhour, entry_standard_workhour.seq, entry_standard_workhour.standard_date, entry_standard_workhour.standard_workhour, entry_standard_workhour.standard_earlyworkhour, entry_standard_workhour.standard_midworkhour, entry_standard_workhour.standard_lateworkhour, entry_report_workhour.seq, entry_report_workhour.report_date, entry_report_workhour.report_workhour";
        QFilter[] filters = new QFilter[]{new QFilter("billno", "in", (Object)resourcePlanNoArray)};
        return BusinessDataServiceHelper.load((String)"pmpd_resourceplan", (String)selectFields, (QFilter[])filters);
    }

    public static List<String> getSelectFields() {
        ArrayList fieldKeys = Lists.newArrayListWithExpectedSize((int)21);
        fieldKeys.add("resourceplan");
        fieldKeys.add("salesrouthours");
        fieldKeys.add("salesnorouthours");
        fieldKeys.add("totalroutworkhour");
        fieldKeys.add("totalnoroutworkhour");
        fieldKeys.add("totalestimateworkhour");
        fieldKeys.add("tsaleshours");
        fieldKeys.add("workhourtype");
        fieldKeys.add("dayavghours");
        fieldKeys.add("summary_date");
        fieldKeys.add("summary_workhour");
        fieldKeys.add("summary_earlyworkhour");
        fieldKeys.add("summary_midworkhour");
        fieldKeys.add("summary_lateworkhour");
        fieldKeys.add("s_summary_date");
        fieldKeys.add("s_summary_workhour");
        fieldKeys.add("s_summary_earlyworkhour");
        fieldKeys.add("s_summary_midworkhour");
        fieldKeys.add("s_summary_lateworkhour");
        fieldKeys.add("r_summary_date");
        fieldKeys.add("r_summary_workhour");
        return fieldKeys;
    }
}

