/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ApproachApplicationRowStatusSwitchOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        RefObject refObject;
        OperateOption option = this.getOption();
        boolean contains = option.tryGetVariableValue("selectedEntryIds", refObject = new RefObject());
        if (!contains) {
            return;
        }
        String value = (String)refObject.getValue();
        Set selectedEntryIds = (Set)SerializationUtils.fromJsonString((String)value, Set.class);
        DynamicObject dataEntity = e.getDataEntities()[0];
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicProperty property = collection.getDynamicObjectType().getProperty("rowstatus");
        if (property instanceof BillStatusProp) {
            String targetRowStatus;
            String enableRowStatus;
            BillStatusProp rowStatusProp = (BillStatusProp)property;
            boolean isRowCloseOp = "rowclose".equals(e.getOperationKey());
            if (isRowCloseOp) {
                enableRowStatus = "normal";
                targetRowStatus = "close";
            } else {
                enableRowStatus = "close";
                targetRowStatus = "normal";
            }
            BillStatusProp.StatusItemPro statusItem = rowStatusProp.getStatusItem(enableRowStatus);
            if (statusItem == null) {
                return;
            }
            String opName = this.getOpName();
            this.operationResult.setBillCount(selectedEntryIds.size());
            List successPkIds = this.operationResult.getSuccessPkIds();
            successPkIds.clear();
            int collectionSize = collection.size();
            for (int i = 0; i < collectionSize; ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                Object entryId = dynamicObject.getPkValue();
                if (!selectedEntryIds.contains(entryId)) continue;
                String rowStatus = (String)rowStatusProp.getValueFast((Object)dynamicObject);
                if (StringUtils.equals((CharSequence)rowStatus, (CharSequence)enableRowStatus)) {
                    successPkIds.add(entryId);
                    dynamicObject.set("rowstatus", (Object)targetRowStatus);
                    continue;
                }
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrorInfo(entryId, i, statusItem, opName));
            }
            SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        }
    }

    private String getOpName() {
        Object name = this.operateMeta.get("name");
        String opName = null;
        if (name instanceof Map) {
            Map nameMap = (Map)name;
            opName = (String)nameMap.get(RequestContext.get().getLang().toString());
        }
        return opName;
    }

    private ValidationErrorInfo buildErrorInfo(Object pkValue, int rowIndx, BillStatusProp.StatusItemPro statusItem, String opName) {
        ValidationErrorInfo errorInfo = new ValidationErrorInfo();
        errorInfo.setPkValue(pkValue);
        errorInfo.setRowIndex(rowIndx);
        errorInfo.setDataEntityIndex(0);
        errorInfo.setErrorCode("ApproachApplicationRowStatusSwitchOp");
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u201c\u8fdb\u573a\u4fe1\u606f\u201d\u7b2c%1$d\u884c\uff0c\u53ea\u6709\u884c\u72b6\u6001\u4e3a%2$s\u7684\u6570\u636e\u624d\u5141\u8bb8%3$s\u3002", (String)"ApproachApplicationRowStatusSwitchOp_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), rowIndx + 1, statusItem.getStatusName().getLocaleValue(), opName));
        return errorInfo;
    }
}

