/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.pmc.pmpd.common.enums.ConstructionUnitEnum;
import kd.pmc.pmpd.opplugin.standplan.validator.ApproachApplicationValidator;

public class ApproachApplicationSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("customer");
        fieldKeys.add("equipment");
        fieldKeys.add("starttime");
        fieldKeys.add("endtime");
        fieldKeys.add("durationunit");
        fieldKeys.add("unitlength");
        fieldKeys.add("duration");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        RefObject result = new RefObject();
        if (this.operateOption.tryGetVariableValue("importtag_of_datasource", result) || this.operateOption.tryGetVariableValue("importtype", result)) {
            e.addValidator((AbstractValidator)new ApproachApplicationValidator());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.caclTrt(e);
    }

    private void caclTrt(BeginOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = e.getDataEntities()) {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                BigDecimal duration = entry.getBigDecimal("duration");
                if (duration != null && duration.compareTo(BigDecimal.ZERO) != 0) continue;
                Date startTime = entry.getDate("starttime");
                Date endTime = entry.getDate("endtime");
                DynamicObject unit = entry.getDynamicObject("durationunit");
                long dValue = endTime.getTime() - startTime.getTime();
                ConstructionUnitEnum durationUnit = this.getUnitEnum(unit);
                int unitlength = entry.getInt("unitlength");
                duration = BigDecimal.valueOf(dValue).divide(durationUnit.getValue(), unitlength == 0 ? 10 : unitlength, RoundingMode.HALF_UP);
                entry.set("duration", (Object)duration);
            }
        }
    }

    private ConstructionUnitEnum getUnitEnum(DynamicObject unit) {
        return unit == null ? ConstructionUnitEnum.DAY : ConstructionUnitEnum.forValue((String)unit.getString("number"));
    }
}

