/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.common.util.NoseToTailUtil;

public class NoseToTailSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Long pkValue = (Long)dataEntity.getPkValue();
            boolean exists = QueryServiceHelper.exists((String)"pmpd_nosetotail", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkValue)});
            if (exists) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmpd_nosetotail");
                DynamicObjectCollection orginEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                ArrayList<Long> approchEntryIds = new ArrayList<Long>(orginEntity.size());
                ArrayList<Long> planIds = new ArrayList<Long>(orginEntity.size());
                for (DynamicObject object : orginEntity) {
                    approchEntryIds.add(object.getLong("approach_id"));
                    planIds.add(object.getLong("resourceplan_id"));
                }
                NoseToTailUtil.clearApprochNoseId(approchEntryIds);
                NoseToTailUtil.clearPlanNoseId(planIds);
            }
            DynamicObjectCollection entity = dataEntity.getDynamicObjectCollection("entryentity");
            Map<Integer, Integer> rowDiffDayMap = this.getRowDiffDayMap(entity);
            for (int i = 0; i < entity.size(); ++i) {
                DynamicObject object = (DynamicObject)entity.get(i);
                Long approachId = object.getLong("approach_id");
                Long resourcePlanId = object.getLong("resourceplan_id");
                Integer diffDay = 0;
                if (i != 0) {
                    diffDay = rowDiffDayMap.get(i - 1);
                }
                NoseToTailUtil.updateApprochNoseId((Long)approachId, (Long)pkValue);
                NoseToTailUtil.updatePlanNoseId((Long)resourcePlanId, (Long)pkValue, (int)diffDay);
            }
        }
    }

    private Map<Integer, Integer> getRowDiffDayMap(DynamicObjectCollection entity) {
        int size = entity.size();
        int diffDays = 0;
        HashMap<Integer, Integer> lineDiffMap = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            if (i != size - 1) {
                int nextDays = ((DynamicObject)entity.get(i)).getInt("nextintervalday");
                DynamicObject beforePlan = ((DynamicObject)entity.get(i)).getDynamicObject("resourceplan");
                DynamicObject afterPlan = ((DynamicObject)entity.get(i + 1)).getDynamicObject("resourceplan");
                if (Objects.isNull(beforePlan) || Objects.isNull(afterPlan)) {
                    diffDays += 0;
                } else {
                    int nextDays1 = NoseToTailUtil.getDiffDay((Date)beforePlan.getDate("estideparttime"), (Date)afterPlan.getDate("estiapproachtime"));
                    diffDays = nextDays - nextDays1 + diffDays;
                }
            }
            lineDiffMap.put(i, diffDays);
        }
        return lineDiffMap;
    }
}

