/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.enums.ExecuteStatusEnum;

public class ResourcePlanCancelOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("operator");
        e.getFieldKeys().add("operationtime");
        e.getFieldKeys().add("executestatus");
        e.getFieldKeys().add("cancelreason");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String cancelReason = this.operateOption.getVariableValue("cancelReason");
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        ArrayList billNos = Lists.newArrayListWithExpectedSize((int)e.getValidExtDataEntities().size());
        for (ExtendedDataEntity validExtDataEntity : e.getValidExtDataEntities()) {
            billNos.add(validExtDataEntity.getBillNo());
            DynamicObject dataEntity = validExtDataEntity.getDataEntity();
            dataEntity.set("operator", (Object)userObj);
            dataEntity.set("operationtime", (Object)new Date());
            dataEntity.set("executestatus", (Object)ExecuteStatusEnum.CANCEL.getValue());
            dataEntity.set("cancelreason", (Object)cancelReason);
        }
        TXServiceHelper.executeWithTX(() -> {
            Object[] workHourEstimateBillArray = this.getNeedHandleWorkHourEstimateBill(billNos);
            if (ArrayUtils.isNotEmpty((Object[])workHourEstimateBillArray)) {
                SaveServiceHelper.update((DynamicObject[])workHourEstimateBillArray);
            }
            SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        });
    }

    private DynamicObject[] getNeedHandleWorkHourEstimateBill(List<String> billNos) {
        QFilter[] filters = new QFilter[]{new QFilter("resourceplan", "in", billNos)};
        List workHourEstimateBillIds = QueryServiceHelper.queryPrimaryKeys((String)"pmpd_hour_estimate", (QFilter[])filters, null, (int)-1);
        if (workHourEstimateBillIds.isEmpty()) {
            return new DynamicObject[0];
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_hour_estimate");
        int size = workHourEstimateBillIds.size();
        DynamicObject[] workHourEstimateBillArray = new DynamicObject[workHourEstimateBillIds.size()];
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType, workHourEstimateBillIds.get(i));
            dynamicObject.set("effectivestatus", (Object)"2");
            workHourEstimateBillArray[i] = dynamicObject;
        }
        return workHourEstimateBillArray;
    }
}

