/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class ResourcePlanDateValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            this.verifyDateSeq(extendedDataEntity, dataEntity, "estiapproachtime", "estideparttime", ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
            this.verifyDateSeq(extendedDataEntity, dataEntity, "realapproachtime", "realdeparttime", ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u79bb\u573a\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5b9e\u9645\u8fdb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_1", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
            this.verifyDateSeq(extendedDataEntity, dataEntity, "preapproachtime", "predeparttime", ResManager.loadKDString((String)"\u9884\u8ba1\u5b8c\u5de5\u65f6\u95f4\u5e94\u665a\u4e8e\u9884\u8ba1\u5f00\u5de5\u65f6\u95f4\u3002", (String)"ResourcePlanDateValidator_2", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
            Date estiApproachDateTime = dataEntity.getDate("estiapproachtime");
            Date estiDepartDateTime = dataEntity.getDate("estideparttime");
            if (estiApproachDateTime == null || estiDepartDateTime == null) continue;
            this.verifyMilestoneTime(extendedDataEntity, estiApproachDateTime, estiDepartDateTime, dataEntity.getDynamicObjectCollection("milestoneentry"));
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entry_repair");
            StringBuilder sb = new StringBuilder();
            BigDecimal timeLong = BigDecimal.ZERO;
            boolean hasWorkCenter = false;
            boolean hasMainWcFlag = false;
            DynamicObject workCenterr = dataEntity.getDynamicObject("workcenter");
            Date preEndTime = null;
            int collectionSize = collection.size();
            for (int i = 0; i < collectionSize; ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                int seq = i + 1;
                Date startTime = dynamicObject.getDate("sectionstarttime");
                Date endTime = dynamicObject.getDate("sectionendtime");
                boolean isMainWorkCenter = dynamicObject.getBoolean("mianworkcenter");
                DynamicObject workCenter = dynamicObject.getDynamicObject("sectionresource");
                if (workCenter != null) {
                    hasWorkCenter = true;
                }
                if (isMainWorkCenter) {
                    if (workCenter == null) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u7b2c%d\u884c, \u4e3b\u8981\u5de5\u4f5c\u4e2d\u5fc3\u7684\u201c\u5206\u6bb5\u5360\u7528\u5de5\u4f5c\u4e2d\u5fc3\u201d\u4e3a\u7a7a\u3002", (String)"ResourcePlanDateValidator_15", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq));
                    }
                    hasMainWcFlag = true;
                }
                timeLong = timeLong.add(dynamicObject.getBigDecimal("timelength"));
                if (startTime == null || endTime == null) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u5206\u6bb5\u5360\u7528\u5f00\u59cb\u65f6\u95f4\u201d\u6216\u201c\u5206\u6bb5\u5360\u7528\u7ed3\u675f\u65f6\u95f4\u201d\u4e3a\u7a7a\u3002", (String)"ResourcePlanDateValidator_8", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq));
                    continue;
                }
                if (startTime.compareTo(endTime) >= 0) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u5206\u6bb5\u5360\u7528\u7ed3\u675f\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5206\u6bb5\u5360\u7528\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_3", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq));
                }
                if (startTime != null && preEndTime != null && (startTime.compareTo(preEndTime) <= 0 || startTime.getTime() - preEndTime.getTime() > 60000L)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u7b2c%1$d\u3001%2$d\u884c\u7684\u5206\u6bb5\u5360\u7528\u65f6\u95f4\u4e0d\u8fde\u7eed\u3002", (String)"ResourcePlanDateValidator_25", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq - 1, seq));
                }
                if (i == 0 && startTime != null && !this.validateDateEqual(startTime, estiApproachDateTime)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201c\u5206\u6bb5\u5360\u7528\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u7b49\u4e8e\u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_23", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq));
                }
                if (i == collectionSize - 1 && endTime != null && !this.validateDateEqual(endTime, estiDepartDateTime)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201c\u5206\u6bb5\u5360\u7528\u7ed3\u675f\u65f6\u95f4\u201d\u4e0d\u7b49\u4e8e\u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_24", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq));
                }
                preEndTime = endTime;
                this.verifyDateSeq(extendedDataEntity, dynamicObject, "realstarttime", "realendtime", String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u5b9e\u9645\u5360\u7528\u7ed3\u675f\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5b9e\u9645\u5360\u7528\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_6", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq));
            }
            if (hasWorkCenter && !hasMainWcFlag) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u8bf7\u7ef4\u62a4\u4e3b\u8981\u5de5\u4f5c\u4e2d\u5fc3\u3002", (String)"ResourcePlanDateValidator_19", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
            }
            if (hasWorkCenter || workCenterr == null) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u5de5\u4f5c\u4e2d\u5fc3\u201d\u4e0e\u4e3b\u8981\u5de5\u4f5c\u4e2d\u5fc3\u4e0d\u4e00\u81f4\u3002", (String)"ResourcePlanDateValidator_20", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateDateEqual(Date time1, Date time2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(time1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time2);
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2) && calendar1.get(5) == calendar2.get(5) && calendar1.get(11) == calendar2.get(11) && calendar1.get(12) == calendar2.get(12);
    }

    private void verifyDateSeq(ExtendedDataEntity extendedDataEntity, DynamicObject dynamicObject, String startTimeKey, String endTimeKey, String errorMsg) {
        Date endTime;
        Date startTime = dynamicObject.getDate(startTimeKey);
        if (startTime != null && (endTime = dynamicObject.getDate(endTimeKey)) != null && startTime.compareTo(endTime) >= 0) {
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    public void verifyMilestoneTime(ExtendedDataEntity extendedDataEntity, Date startTime, Date endTime, DynamicObjectCollection milestoneEntry) {
        int i = 0;
        for (DynamicObject object : milestoneEntry) {
            ++i;
            if (this.validateTime(startTime, endTime, object.getDate("mitstarttime"))) continue;
            this.addErrorMessage(extendedDataEntity, String.format(this.getMilestoneTimeErrorMsg(), i));
        }
    }

    public boolean validateTime(Date startTime, Date endTime, Date mitstarttime) {
        boolean flag = true;
        if (startTime != null && mitstarttime != null && mitstarttime.compareTo(startTime) < 0) {
            flag = false;
        }
        if (endTime != null && mitstarttime != null && mitstarttime.compareTo(endTime) > 0) {
            flag = false;
        }
        return flag;
    }

    public String getMilestoneTimeErrorMsg() {
        return ResManager.loadKDString((String)"\u201c\u91cc\u7a0b\u7891\u4fe1\u606f\u201d\u7b2c%s\u884c\u201c\u8ba1\u5212\u65f6\u95f4\u201d\u5e94>=\u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u4e14<=\u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_21", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]);
    }
}

