/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.login.utils.DateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.enums.ConstructionUnitEnum;
import kd.pmc.pmpd.common.enums.ExecuteStatusEnum;

public class ResourcePlanDepartureOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("operator");
        e.getFieldKeys().add("operationtime");
        e.getFieldKeys().add("executestatus");
        e.getFieldKeys().add("realapproachtime");
        e.getFieldKeys().add("realdeparttime");
        e.getFieldKeys().add("realrepaircycle");
        e.getFieldKeys().add("constructionunit");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String startDateStr = this.getOption().getVariableValue("startDate");
        Date startDate = DateUtils.parseDateTime((String)startDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        String endDateStr = this.getOption().getVariableValue("endDate");
        Date endDate = DateUtils.parseDateTime((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        for (DynamicObject dataEntity : e.getDataEntities()) {
            dataEntity.set("operator", (Object)userObj);
            dataEntity.set("operationtime", (Object)new Date());
            dataEntity.set("executestatus", (Object)ExecuteStatusEnum.DEPARTURE.getValue());
            dataEntity.set("realapproachtime", (Object)startDate);
            dataEntity.set("realdeparttime", (Object)endDate);
            DynamicObject unit = dataEntity.getDynamicObject("constructionunit");
            BigDecimal value = ConstructionUnitEnum.forValue((String)unit.getString("number")).getValue();
            long dValue = endDate.getTime() - startDate.getTime();
            BigDecimal divide = BigDecimal.valueOf(dValue).divide(value, 10, RoundingMode.HALF_UP);
            dataEntity.set("realrepaircycle", (Object)divide);
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }
}

