/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.pmc.pmpd.common.consts.ResourcePlanConst;
import kd.pmc.pmpd.common.util.NoseToTailUtil;
import kd.pmc.pmpd.opplugin.standplan.ResourcePlanDateValidator;
import kd.pmc.pmpd.opplugin.standplan.ResourcePlanRestrainValidator;
import kd.pmc.pmpd.opplugin.standplan.validator.ResourcePlanValidator;

public class ResourcePlanSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("isnosetotail");
        fieldKeys.add("billno");
        fieldKeys.add("pulishstatus");
        fieldKeys.add("nosetotail");
        fieldKeys.add("preapproachtime");
        fieldKeys.add("workrepaircycle");
        fieldKeys.add("overdevice");
        fieldKeys.add("mitstarttime");
        fieldKeys.add("fixmodel");
        fieldKeys.add("optype");
        fieldKeys.add("entry_repair");
        fieldKeys.add("sectionresource");
        fieldKeys.addAll(ResourcePlanConst.HEAD_STARTDATETIME_KEYS);
        fieldKeys.addAll(ResourcePlanConst.HEAD_ENDDATETIME_KEYS);
        fieldKeys.addAll(ResourcePlanConst.ENTRY_STARTDATETIME_KEYS);
        fieldKeys.addAll(ResourcePlanConst.ENTRY_ENDDATETIME_KEYS);
        fieldKeys.add("mianworkcenter");
        fieldKeys.add("timelength");
        fieldKeys.add("workcenter");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ResourcePlanDateValidator());
        e.addValidator((AbstractValidator)new ResourcePlanRestrainValidator());
        RefObject result = new RefObject();
        if (this.operateOption.tryGetVariableValue("importtag_of_datasource", result) || this.operateOption.tryGetVariableValue("importtype", result)) {
            e.addValidator((AbstractValidator)new ResourcePlanValidator());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        HashMap timeMap = new HashMap(2);
        LinkedList<Date> startTimes = new LinkedList<Date>();
        LinkedList<Date> endTimes = new LinkedList<Date>();
        ArrayList<String> billNos = new ArrayList<String>();
        for (DynamicObject dataEntity : e.getDataEntities()) {
            long pkValue = (Long)dataEntity.getPkValue();
            boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
            if (fromDatabase) {
                DynamicObject old = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmpd_resourceplan", (String)"estiapproachtime, estideparttime, preapproachtime, workrepaircycle");
                startTimes.add(old.getDate("estiapproachtime"));
                endTimes.add(old.getDate("estideparttime"));
                Date oldDate = old.getDate("preapproachtime");
                BigDecimal oldCycle = old.getBigDecimal("workrepaircycle");
                Date newDate = dataEntity.getDate("preapproachtime");
                BigDecimal newCycle = dataEntity.getBigDecimal("workrepaircycle");
                if ((Objects.isNull(oldDate) ? 0L : oldDate.getTime()) != (Objects.isNull(newDate) ? 0L : newDate.getTime()) || oldCycle.compareTo(newCycle) != 0) {
                    billNos.add(dataEntity.getString("billno"));
                }
            } else {
                startTimes.add(dataEntity.getDate("estiapproachtime"));
                endTimes.add(dataEntity.getDate("estideparttime"));
            }
            this.setEntryWorkScopeDetails(dataEntity);
        }
        timeMap.put("estiapproachtime", startTimes);
        timeMap.put("estideparttime", endTimes);
        this.operateOption.setVariableValue("timeMap", SerializationUtils.toJsonString(timeMap));
        this.operateOption.setVariableValue("billNos", SerializationUtils.toJsonString(billNos));
    }

    private void setEntryWorkScopeDetails(DynamicObject dataEntity) {
        RefObject result = new RefObject();
        if (this.operateOption.tryGetVariableValue("importtag_of_datasource", result) || this.operateOption.tryGetVariableValue("importtype", result)) {
            DynamicObject workScope = dataEntity.getDynamicObject("workscope");
            String j = "+";
            if (workScope != null) {
                j = workScope.getString("combosymbol");
            }
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entry_repair");
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection workscopedetail = entry.getDynamicObjectCollection("workscopedetail");
                StringJoiner details = new StringJoiner(j);
                for (DynamicObject detail : workscopedetail) {
                    DynamicObject dtl = detail.getDynamicObject("fbasedataid");
                    details.add(dtl.getString("name"));
                }
                entry.set("workspdetails", (Object)details.toString());
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String timeMapStr = this.operateOption.getVariableValue("timeMap");
        String billNoStr = this.operateOption.getVariableValue("billNos");
        Map timeMap = (Map)SerializationUtils.fromJsonString((String)timeMapStr, Map.class);
        List billNos = (List)SerializationUtils.fromJsonString((String)billNoStr, List.class);
        List startTimes = (List)timeMap.get("estiapproachtime");
        List endTimes = (List)timeMap.get("estideparttime");
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            Date startTime = (Date)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(startTimes.get(i)), Date.class);
            Date endTime = (Date)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(endTimes.get(i)), Date.class);
            DynamicObject noseToTail = NoseToTailUtil.updateNoseBySavePlanNo((DynamicObject)dataEntity);
            if (!Objects.nonNull(noseToTail)) continue;
            long pkValue = (Long)dataEntity.getPkValue();
            int startDays = NoseToTailUtil.getDiffDay((Date)startTime, (Date)dataEntity.getDate("estiapproachtime"));
            int endDay = NoseToTailUtil.getDiffDay((Date)endTime, (Date)dataEntity.getDate("estideparttime"));
            int diffDays = startDays;
            DynamicObjectCollection noseEntitys = noseToTail.getDynamicObjectCollection("entryentity");
            for (DynamicObject noseEntity : noseEntitys) {
                long resourceId = noseEntity.getLong("resourceplan.id");
                if (pkValue == resourceId) {
                    diffDays = endDay;
                    continue;
                }
                if (resourceId == 0L) continue;
                billNos.add(noseEntity.getDynamicObject("resourceplan").getString("billno"));
                NoseToTailUtil.updatePlanNoseId((Long)resourceId, (Long)((Long)noseToTail.getPkValue()), (int)diffDays);
            }
        }
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(16);
        customParams.put("calculateEstimateWorkHour", Boolean.TRUE);
        customParams.put("calculateStandardWorkHour", Boolean.TRUE);
        customParams.put("writebackToResourcePlan", Boolean.TRUE);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"WorkingHourService", (String)"reestimate", (Object[])new Object[]{billNos, customParams});
    }
}

