/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ApproachApplicationValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        ArrayList<Object> materialPks = new ArrayList<Object>(entities.length * 3);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject object = entity.getDataEntity();
            DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                long equipment = dynamicObject.getLong("equipment_id");
                if (equipment == 0L) continue;
                materialPks.add(equipment);
            }
        }
        if (materialPks.isEmpty()) {
            return;
        }
        Map<Long, Long> materialOwnerInfo = this.queryMaterialOwnerInfo(materialPks);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject object = entity.getDataEntity();
            long customer = object.getLong("customer_id");
            DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("entryentity");
            int seq = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                Long customerId;
                ++seq;
                long equipment = dynamicObject.getLong("equipment_id");
                if (equipment == 0L || (customerId = materialOwnerInfo.get(equipment)) != null && customer == customerId) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8fdb\u573a\u4fe1\u606f \u7b2c%1$s\u884c\u201c\u68c0\u4fee\u8bbe\u5907\u6ce8\u518c\u53f7\u201d\u7684\u201c\u8425\u8fd0\u65b9\u201d\u4e0d\u7b49\u4e8e\u201c\u5ba2\u6237\u201d\u3002", (String)"ApproachApplicationValidator_1", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), seq));
            }
        }
    }

    public Map<Long, Long> queryMaterialOwnerInfo(List<Object> materialPks) {
        QFilter qFilter = new QFilter("id", "in", materialPks);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"mpdm_materialmtcinfo", (String)"id,operator", (QFilter[])qFilter.toArray());
        return dynamicObjects.stream().collect(Collectors.toMap(i -> i.getLong(0), i -> i.getLong(1)));
    }
}

