/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan.validator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PlanRoomSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        HashSet<Long> projectPks = new HashSet<Long>(entities.length);
        HashSet<Long> resPlanPks = new HashSet<Long>(entities.length);
        for (ExtendedDataEntity entity : entities) {
            boolean isNew;
            DynamicObject obj = entity.getDataEntity();
            long resplan = obj.getLong("resplan");
            DynamicObjectCollection projects = obj.getDynamicObjectCollection("projects");
            if (resplan == 0L && projects.isEmpty()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u7f16\u7801\u201d\u6216\u201c\u9879\u76ee\u201d\u3002", (String)"ResourcePlanSaveValidator_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
            }
            if (isNew = obj.getDataEntityState().getFromDatabase()) continue;
            if (resplan == 0L && !projects.isEmpty()) {
                DynamicObject pro = ((DynamicObject)projects.get(0)).getDynamicObject("fbasedataid");
                Long projectPK = pro.getLong("id");
                projectPks.add(projectPK);
            }
            if (resplan == 0L) continue;
            resPlanPks.add(resplan);
        }
        Set<Long> hasProjects = this.queryProjectPlanRoom(projectPks);
        Set<Long> resPlanProjects = this.queryProjectResourcePlanRoom(projectPks);
        Set<Long> hasResPlanPlanRoomProjects = this.queryResPlanProjectPlanRoom(resPlanPks);
        for (ExtendedDataEntity entity : entities) {
            boolean isNew;
            DynamicObject obj = entity.getDataEntity();
            long resplan = obj.getLong("resplan");
            DynamicObjectCollection projects = obj.getDynamicObjectCollection("projects");
            if (resplan == 0L && projects.isEmpty()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u7f16\u7801\u201d\u6216\u201c\u9879\u76ee\u201d\u3002", (String)"ResourcePlanSaveValidator_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
            }
            if (isNew = obj.getDataEntityState().getFromDatabase()) continue;
            if (resplan == 0L && !projects.isEmpty()) {
                DynamicObject pro = ((DynamicObject)projects.get(0)).getDynamicObject("fbasedataid");
                Long projectPK = pro.getLong("id");
                if (hasProjects != null && hasProjects.contains(projectPK)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s \u5b58\u5728\u8ba1\u5212\u5ba4\u5360\u7528\u5355\u3002", (String)"ResourcePlanSaveValidator_1", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), pro.getString("number")));
                }
                if (resPlanProjects != null && resPlanProjects.contains(projectPK)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s \u5173\u8054\u7684\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u5b58\u5728\u8ba1\u5212\u5ba4\u5360\u7528\u5355\u3002", (String)"ResourcePlanSaveValidator_2", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), pro.getString("number")));
                }
            }
            if (resplan == 0L || hasResPlanPlanRoomProjects == null || !hasResPlanPlanRoomProjects.contains(resplan)) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\uff1a%s \u4e0b\u7684\u9879\u76ee\u5b58\u5728\u8ba1\u5212\u5ba4\u5360\u7528\u5355\u3002", (String)"ResourcePlanSaveValidator_3", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), obj.getString("resplannum")));
        }
    }

    private Set<Long> queryResPlanProjectPlanRoom(Set<Long> resPlanPks) {
        if (resPlanPks.isEmpty()) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "in", resPlanPks);
        DynamicObjectCollection resourcePlans = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id,entry_project.projcet", (QFilter[])qFilter.toArray());
        if (resourcePlans.isEmpty()) {
            return null;
        }
        Map<Object, Long> resourcePlanPks = resourcePlans.stream().filter(i -> i.getLong(1) != 0L).collect(Collectors.toMap(i -> i.get(1), i -> i.getLong(0)));
        if (resourcePlanPks.isEmpty()) {
            return null;
        }
        qFilter = new QFilter("projects.fbasedataid", "in", resourcePlanPks.keySet());
        DynamicObjectCollection planRooms = QueryServiceHelper.query((String)this.getEntityKey(), (String)"projects.fbasedataid", (QFilter[])qFilter.toArray());
        HashSet<Long> hasResPlanPks = new HashSet<Long>(planRooms.size());
        for (DynamicObject planRoom : planRooms) {
            Long resPlanPk = resourcePlanPks.get(planRoom.get(0));
            if (resPlanPks == null) continue;
            hasResPlanPks.add(resPlanPk);
        }
        return hasResPlanPks;
    }

    public Set<Long> queryProjectPlanRoom(Set<Long> projectPKs) {
        if (projectPKs.isEmpty()) {
            return null;
        }
        QFilter qFilter = new QFilter("projects.fbasedataid", "in", projectPKs);
        DynamicObjectCollection planRooms = QueryServiceHelper.query((String)this.getEntityKey(), (String)"projects.fbasedataid", (QFilter[])qFilter.toArray());
        return planRooms.stream().map(i -> i.getLong(0)).collect(Collectors.toSet());
    }

    public Set<Long> queryProjectResourcePlanRoom(Set<Long> projectPKs) {
        if (projectPKs.isEmpty()) {
            return null;
        }
        QFilter qFilter = new QFilter("entry_project.projcet", "in", projectPKs);
        qFilter.and("version", "=", (Object)0L);
        qFilter.and("pulishstatus", "=", (Object)"1");
        DynamicObjectCollection resourcePlans = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id,entry_project.projcet", (QFilter[])qFilter.toArray());
        if (resourcePlans.isEmpty()) {
            return null;
        }
        Map<Object, Long> resourcePlanPks = resourcePlans.stream().collect(Collectors.toMap(i -> i.get(0), i -> i.getLong(1)));
        qFilter = new QFilter("resplan", "in", resourcePlanPks.keySet());
        DynamicObjectCollection planRooms = QueryServiceHelper.query((String)this.getEntityKey(), (String)"resplan", (QFilter[])qFilter.toArray());
        HashSet<Long> hasProjectPks = new HashSet<Long>(planRooms.size());
        for (DynamicObject planRoom : planRooms) {
            Long project = resourcePlanPks.get(planRoom.get(0));
            if (project == null) continue;
            hasProjectPks.add(project);
        }
        return hasProjectPks;
    }
}

