/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.standplan.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.pmc.pmpd.opplugin.standplan.validator.ApproachApplicationValidator;

public class ResourcePlanValidator
extends ApproachApplicationValidator {
    @Override
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        List<Object> materialPks = Arrays.stream(entities).filter(i -> i.getDataEntity().getLong("overdevice_id") != 0L).map(i -> i.getDataEntity().get("overdevice_id")).collect(Collectors.toList());
        Map<Long, Long> materialOwnerInfo = this.queryMaterialOwnerInfo(materialPks);
        for (ExtendedDataEntity entity : entities) {
            Long customerId;
            DynamicObject object = entity.getDataEntity();
            long customer = object.getLong("customer_id");
            long equipment = object.getLong("overdevice_id");
            if (equipment == 0L || (customerId = materialOwnerInfo.get(equipment)) != null && customer == customerId) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u8bbe\u5907\u6ce8\u518c\u53f7\u201d\u7684\u201c\u8425\u8fd0\u65b9\u201d\u4e0d\u7b49\u4e8e\u201c\u5ba2\u6237\u201d\u3002", (String)"ResourcePlanValidator_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
        }
    }
}

