/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workinghours;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.OperationHelper;
import kd.pmc.pmpd.business.workhour.WorkHourEstimateHelper;
import kd.pmc.pmpd.common.helper.IndustryMappingHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class WorkHourEstimateBillGetStandWorkHourOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("resourceplan");
        fieldKeys.add("stage_workhour");
        fieldKeys.add("s_subentryentity_stage");
        fieldKeys.add("s_stage_industry");
        fieldKeys.add("s_stage_stage");
        fieldKeys.add("s_stage_percentage");
        fieldKeys.add("entryentity");
        fieldKeys.add("industry_id");
        fieldKeys.add("nonroutineworkhour");
        fieldKeys.add("s_entryentity");
        fieldKeys.add("workhourtype");
        fieldKeys.add("s_industryone_id");
        fieldKeys.add("s_industry");
        fieldKeys.add("s_routineworkhour");
        fieldKeys.add("s_nonroutineworkhour");
        fieldKeys.add("s_totalhours");
        fieldKeys.add("totalroutworkhour");
        fieldKeys.add("totalnoroutworkhour");
        fieldKeys.add("totalestimateworkhour");
        fieldKeys.add("s_entryentity.seq");
        fieldKeys.add("s_entryentity.s_subentryentity_stage.seq");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List validExtDataEntities = e.getValidExtDataEntities();
        HashMap<String, List<ExtendedDataEntity>> resourPlanNoMap = new HashMap<String, List<ExtendedDataEntity>>(16);
        for (ExtendedDataEntity extendedDataEntity2 : validExtDataEntities) {
            String resourPlanNo;
            if (!this.verifyResourcePlanNo(extendedDataEntity2, resourPlanNo = ObjectConverterWrapper.getString((Object)extendedDataEntity2.getValue("resourceplan")))) {
                List extendedDataEntities = resourPlanNoMap.computeIfAbsent(resourPlanNo, k -> new ArrayList(2));
                extendedDataEntities.add(extendedDataEntity2);
            }
            this.verifyStageWorkHourTemplate(extendedDataEntity2);
        }
        Map<String, Set<Long>> projectMap = this.getProjectMap(resourPlanNoMap.keySet());
        Set<Long> passedProjectIds = this.verifyProject(resourPlanNoMap, projectMap);
        Map<Long, List<Long>> workOrderMap = this.getWorkOrderMap(passedProjectIds);
        HashMap<String, List<Long>> resourcePlan2WorkOrder = new HashMap<String, List<Long>>(16);
        Set<Long> workOrderIds = this.verifyWorkOrder(resourPlanNoMap, projectMap, workOrderMap, resourcePlan2WorkOrder);
        validExtDataEntities.clear();
        if (resourPlanNoMap.isEmpty()) {
            e.setCancel(true);
            return;
        }
        Table<Long, Long, IndustryWorkHourBo> standardWorkHourMap = this.getStandardWorkHourMap(workOrderIds);
        Map industryCache = WorkHourEstimateHelper.getIndustryFromCache((Set)standardWorkHourMap.columnKeySet());
        Set errorIds = this.operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).collect(Collectors.toSet());
        for (Map.Entry entry : resourPlanNoMap.entrySet()) {
            List extendedDataEntities;
            String resourcePlanNo = (String)entry.getKey();
            List currentWorkOrderIds = (List)resourcePlan2WorkOrder.get(resourcePlanNo);
            Map<Long, IndustryWorkHourBo> summaryIndustryWorkHourBoMap = this.summaryIndustryWorkHour(standardWorkHourMap, currentWorkOrderIds);
            if (this.verifyProcessPlan(summaryIndustryWorkHourBoMap, extendedDataEntities = (List)entry.getValue())) continue;
            extendedDataEntities.removeIf(extendedDataEntity -> errorIds.contains(extendedDataEntity.getBillPkId()));
            if (extendedDataEntities.isEmpty()) continue;
            for (ExtendedDataEntity extendedDataEntity3 : extendedDataEntities) {
                DynamicObject dataEntity = extendedDataEntity3.getDataEntity();
                DynamicObjectCollection standardEntryCollection = this.newStandardIndustryWorkHourEntry(summaryIndustryWorkHourBoMap, industryCache, dataEntity);
                if (standardEntryCollection.isEmpty()) continue;
                this.newStandardStageEntryCollection(extendedDataEntity3, standardEntryCollection);
            }
            validExtDataEntities.addAll(extendedDataEntities);
        }
        if (validExtDataEntities.isEmpty()) {
            e.setCancel(true);
            return;
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])validExtDataEntities.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new)));
    }

    private Map<Long, IndustryWorkHourBo> summaryIndustryWorkHour(Table<Long, Long, IndustryWorkHourBo> standardWorkHourMap, List<Long> currentWorkOrderIds) {
        HashMap<Long, IndustryWorkHourBo> summaryIndustryWorkHourBoMap = new HashMap<Long, IndustryWorkHourBo>(16);
        for (Long currentWorkOrderId : currentWorkOrderIds) {
            Map industryWorkHourBoMap = standardWorkHourMap.row((Object)currentWorkOrderId);
            if (MapUtils.isEmpty((Map)industryWorkHourBoMap)) continue;
            for (Map.Entry workHourEntry : industryWorkHourBoMap.entrySet()) {
                IndustryWorkHourBo industryWorkHourBo = (IndustryWorkHourBo)workHourEntry.getValue();
                IndustryWorkHourBo summaryIndustryWorkHourBo = summaryIndustryWorkHourBoMap.computeIfAbsent((Long)workHourEntry.getKey(), k -> new IndustryWorkHourBo(industryWorkHourBo.getL1()));
                summaryIndustryWorkHourBo.addWorkHour(industryWorkHourBo.getTotoalHours());
            }
        }
        return summaryIndustryWorkHourBoMap;
    }

    private void newStandardStageEntryCollection(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection standardEntryCollection) {
        DynamicObject stageWorkHour = (DynamicObject)extendedDataEntity.getValue("stage_workhour");
        DynamicObjectCollection industryWorkHourEntryCollection = stageWorkHour.getDynamicObjectCollection("entryentity");
        if (industryWorkHourEntryCollection.isEmpty()) {
            return;
        }
        HashMap industryId2StageCollection = Maps.newHashMapWithExpectedSize((int)industryWorkHourEntryCollection.size());
        for (DynamicObject industryWorkHourEntry : industryWorkHourEntryCollection) {
            DynamicObjectCollection collection = industryWorkHourEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject dynamicObject : collection) {
                List values = industryId2StageCollection.computeIfAbsent(dynamicObject.getLong("stage_industry_id"), k -> new ArrayList(10));
                values.add(Lists.newArrayList((Object[])new Object[]{dynamicObject.getInt("stage_stage"), dynamicObject.getBigDecimal("stage_percentage")}));
            }
        }
        for (DynamicObject standardEntry : standardEntryCollection) {
            List values = (List)industryId2StageCollection.get(standardEntry.getLong("s_industry_id"));
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            DynamicObjectCollection standardStageEntryCollection = standardEntry.getDynamicObjectCollection("s_subentryentity_stage");
            for (List value : values) {
                DynamicObject standardStageEntry = standardStageEntryCollection.addNew();
                standardStageEntry.set("seq", (Object)standardStageEntryCollection.size());
                standardStageEntry.set("s_stage_stage", value.get(0));
                standardStageEntry.set("s_stage_percentage", value.get(1));
            }
        }
    }

    private DynamicObjectCollection newStandardIndustryWorkHourEntry(Map<Long, IndustryWorkHourBo> summaryIndustryWorkHourBoMap, Map<Object, DynamicObject> industryCache, DynamicObject dataEntity) {
        HashMap<Long, BigDecimal> industry2EstimatedWorkHours = new HashMap<Long, BigDecimal>(16);
        DynamicObjectCollection entryCollection = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject industryEntry : entryCollection) {
            industry2EstimatedWorkHours.put(industryEntry.getLong("industry_id"), industryEntry.getBigDecimal("nonroutineworkhour"));
        }
        DynamicObjectCollection standardEntryCollection = dataEntity.getDynamicObjectCollection("s_entryentity");
        standardEntryCollection.clear();
        boolean summaryHeaderWorkHour = "standard".equals(dataEntity.getString("workhourtype"));
        BigDecimal totalRoutineWorkHour = BigDecimal.ZERO;
        BigDecimal totalNonRoutineWorkHour = BigDecimal.ZERO;
        for (Map.Entry<Long, IndustryWorkHourBo> workHourEntry : summaryIndustryWorkHourBoMap.entrySet()) {
            DynamicObject standardEntry = standardEntryCollection.addNew();
            Long industryId = workHourEntry.getKey();
            BigDecimal nonRoutineWorkHour = industry2EstimatedWorkHours.getOrDefault(industryId, BigDecimal.ZERO);
            IndustryWorkHourBo industryWorkHourBo = workHourEntry.getValue();
            BigDecimal routineWorkHour = industryWorkHourBo.getTotoalHours();
            standardEntry.set("s_industryone_id", (Object)industryWorkHourBo.getL1());
            standardEntry.set("s_industry", (Object)industryCache.get(industryId));
            standardEntry.set("s_industry_id", (Object)industryId);
            standardEntry.set("s_routineworkhour", (Object)routineWorkHour);
            standardEntry.set("s_nonroutineworkhour", (Object)nonRoutineWorkHour);
            standardEntry.set("s_totalhours", (Object)routineWorkHour.add(nonRoutineWorkHour));
            if (!summaryHeaderWorkHour) continue;
            totalRoutineWorkHour = totalRoutineWorkHour.add(routineWorkHour);
            totalNonRoutineWorkHour = totalNonRoutineWorkHour.add(nonRoutineWorkHour);
        }
        if (summaryHeaderWorkHour) {
            dataEntity.set("totalroutworkhour", (Object)totalRoutineWorkHour);
            dataEntity.set("totalnoroutworkhour", (Object)totalNonRoutineWorkHour);
            dataEntity.set("totalestimateworkhour", (Object)totalRoutineWorkHour.add(totalNonRoutineWorkHour));
        }
        this.sortByIndustry(standardEntryCollection);
        return standardEntryCollection;
    }

    private void sortByIndustry(DynamicObjectCollection standardEntryCollection) {
        WorkHourEstimateHelper.sortByIndustry((DynamicObjectCollection)standardEntryCollection, dynamicObject -> dynamicObject.getDynamicObject("s_industry"));
        int i = 0;
        while (i < standardEntryCollection.size()) {
            ((DynamicObject)standardEntryCollection.get(i++)).set("seq", (Object)i);
        }
    }

    private Table<Long, Long, IndustryWorkHourBo> getStandardWorkHourMap(Set<Long> workOrderIds) {
        QFilter[] filters = new QFilter[]{new QFilter("manufactureorderid", "in", (Object)workOrderIds.stream().map(String::valueOf).toArray()), new QFilter("billstatus", "=", (Object)"C")};
        String selectFields = "manufactureorderid, oprentryentity.oprprofessiona, oprentryentity.oprworkhours, mftentryseq.area";
        Table industryMappingCache = IndustryMappingHelper.getMappingFromCache();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"sfc_mromanuftech", (String)selectFields, (QFilter[])filters, null);){
            HashBasedTable table = HashBasedTable.create();
            for (Row row : dataSet) {
                Long workOrderId;
                IndustryWorkHourBo industryWorkHourBo;
                Long industryOneId = ObjectConverterWrapper.getLong((Object)row.get(1));
                if (industryOneId == 0L) continue;
                Long areaId = ObjectConverterWrapper.getLong((Object)row.get(3));
                Long industryTwoId = (Long)industryMappingCache.get((Object)industryOneId, (Object)areaId);
                if (industryTwoId == null || industryTwoId == 0L) {
                    industryTwoId = industryOneId;
                }
                if ((industryWorkHourBo = (IndustryWorkHourBo)table.get((Object)(workOrderId = row.getLong(0)), (Object)industryTwoId)) == null) {
                    industryWorkHourBo = new IndustryWorkHourBo(industryOneId);
                }
                industryWorkHourBo.addWorkHour(ObjectConverterWrapper.getBigDecimal((Object)row.get(2)));
                table.put((Object)workOrderId, (Object)industryTwoId, (Object)industryWorkHourBo);
            }
            Iterator iterator = table;
            return iterator;
        }
    }

    private boolean verifyProcessPlan(Map<Long, IndustryWorkHourBo> summaryIndustryWorkHourBoMap, List<ExtendedDataEntity> extendedDataEntities) {
        boolean checkResult = summaryIndustryWorkHourBoMap.isEmpty();
        if (checkResult) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"sfc_mromanuftech");
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.operationResult.addErrorInfo(OperationHelper.buildMultiErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)OperationHelper.getOperationName((Map)this.operateMeta), (String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"WorkHourEstimateBillGetStandWorkHourOp_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)dataEntityType), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"oprprofessiona"))));
            }
        }
        return checkResult;
    }

    private Set<Long> verifyWorkOrder(Map<String, List<ExtendedDataEntity>> resourPlanNoMap, Map<String, Set<Long>> projectMap, Map<Long, List<Long>> workOrderMap, Map<String, List<Long>> resourcePlan2WorkOrder) {
        HashSet<Long> allWorkOrderId = new HashSet<Long>(16);
        Iterator<Map.Entry<String, List<ExtendedDataEntity>>> iterator = resourPlanNoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<ExtendedDataEntity>> entry = iterator.next();
            String key = entry.getKey();
            Set<Long> projectIds = projectMap.get(key);
            ArrayList<Long> workOrderIds = new ArrayList<Long>(10);
            for (Long projectId : projectIds) {
                workOrderIds.addAll(workOrderMap.getOrDefault(projectId, Collections.emptyList()));
            }
            List<ExtendedDataEntity> extendedDataEntities = entry.getValue();
            if (this.verifyWorkOrder(workOrderIds, extendedDataEntities)) {
                iterator.remove();
                continue;
            }
            allWorkOrderId.addAll(workOrderIds);
            resourcePlan2WorkOrder.put(key, workOrderIds);
        }
        return allWorkOrderId;
    }

    private boolean verifyWorkOrder(List<Long> workOrderIds, List<ExtendedDataEntity> extendedDataEntities) {
        boolean checkResult = workOrderIds.isEmpty();
        if (checkResult) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pmpd_exec_workpack_manage");
                MainEntityType executeWorkPackDataEntityType = EntityMetadataCache.getDataEntityType((String)"pmpd_exec_workpack");
                this.operationResult.addErrorInfo(OperationHelper.buildMultiErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)OperationHelper.getOperationName((Map)this.operateMeta), (String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6570\u636e\u4e0e\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"WorkHourEstimateBillGetStandWorkHourOp_1", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)dataEntityType), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"panel_jobno"), LocaleStringHelper.getEntityDisplayName((IDataEntityType)executeWorkPackDataEntityType), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)executeWorkPackDataEntityType, (String)"jobno"))));
            }
        }
        return checkResult;
    }

    private Set<Long> verifyProject(Map<String, List<ExtendedDataEntity>> resourPlanNoMap, Map<String, Set<Long>> projectMap) {
        HashSet<Long> passedProjectIds = new HashSet<Long>(16);
        Iterator<Map.Entry<String, List<ExtendedDataEntity>>> iterator = resourPlanNoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<ExtendedDataEntity>> entry = iterator.next();
            String key = entry.getKey();
            List<ExtendedDataEntity> extendedDataEntities = entry.getValue();
            Set<Long> projectIds = projectMap.get(key);
            if (this.verifyProject(projectIds, extendedDataEntities)) {
                iterator.remove();
                continue;
            }
            passedProjectIds.addAll(projectIds);
        }
        return passedProjectIds;
    }

    private boolean verifyProject(Set<Long> projectIds, List<ExtendedDataEntity> extendedDataEntities) {
        boolean checkResult = CollectionUtils.isEmpty(projectIds);
        if (checkResult) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.operationResult.addErrorInfo(OperationHelper.buildMultiErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)OperationHelper.getOperationName((Map)this.operateMeta), (String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u65e0\u5173\u8054\u7684\u9879\u76ee\u3002", (String)"WorkHourEstimateBillGetStandWorkHourOp_2", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((String)"pmpd_resourceplan"))));
            }
        }
        return checkResult;
    }

    private void verifyStageWorkHourTemplate(ExtendedDataEntity extendedDataEntity) {
        DynamicObject stageWorkHour = (DynamicObject)extendedDataEntity.getValue("stage_workhour");
        if (stageWorkHour == null) {
            this.operationResult.addErrorInfo(OperationHelper.buildMultiErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)OperationHelper.getOperationName((Map)this.operateMeta), (String)LocaleStringHelper.buildEmptyFieldValueMsg((IDataEntityType)this.billEntityType, (String)"stage_workhour")));
        }
    }

    private boolean verifyResourcePlanNo(ExtendedDataEntity extendedDataEntity, String resourPlanNo) {
        boolean checkResult = StringUtils.isEmpty((CharSequence)resourPlanNo);
        if (checkResult) {
            this.operationResult.addErrorInfo(OperationHelper.buildMultiErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)OperationHelper.getOperationName((Map)this.operateMeta), (String)LocaleStringHelper.buildEmptyFieldValueMsg((IDataEntityType)this.billEntityType, (String)"resourceplan")));
        }
        return checkResult;
    }

    private Map<String, Set<Long>> getProjectMap(Set<String> resourPlanNos) {
        QFilter[] filters = new QFilter[]{new QFilter("billno", "in", resourPlanNos), new QFilter("pulishstatus", "=", (Object)"1")};
        String selectFields = "billno, entry_project.projcet";
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_resourceplan", selectFields, filters);){
            if (dataSet.isEmpty()) {
                Map<String, Set<Long>> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, Set> resultMap = new HashMap<String, Set>(16);
            for (Row row : dataSet) {
                Long projectId = ObjectConverterWrapper.getLong((Object)row.get(1));
                if (projectId == 0L) continue;
                Set projectIds = resultMap.computeIfAbsent(row.getString(0), k -> new HashSet(16));
                projectIds.add(projectId);
            }
            HashMap<String, Set> hashMap = resultMap;
            return hashMap;
        }
    }

    private Map<Long, List<Long>> getWorkOrderMap(Set<Long> projectIds) {
        List mroOrderIds;
        Long mroOrderId;
        if (projectIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        QFilter[] filters = new QFilter[]{new QFilter("project", "in", projectIds)};
        String selectFields = "project, entryentity.jobid";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_exec_workpack", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dataSet) {
                mroOrderId = ObjectConverterWrapper.getLong((Object)row.get(1));
                if (mroOrderId == 0L) continue;
                mroOrderIds = resultMap.computeIfAbsent(row.getLong(0), k -> new ArrayList(10));
                mroOrderIds.add(mroOrderId);
            }
        }
        filters = new QFilter[]{new QFilter("entry_panel_jobcard.panel_project", "in", projectIds)};
        selectFields = "entry_panel_jobcard.panel_project, entry_panel_jobcard.panel_jobid";
        dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_exec_workpack_manage", (String)selectFields, (QFilter[])filters, null);
        var6_6 = null;
        try {
            for (Row row : dataSet) {
                mroOrderId = ObjectConverterWrapper.getLong((Object)row.get(1));
                if (mroOrderId == 0L) continue;
                mroOrderIds = resultMap.computeIfAbsent(row.getLong(0), k -> new ArrayList(10));
                mroOrderIds.add(mroOrderId);
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var6_6 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return resultMap;
    }

    private static class IndustryWorkHourBo {
        private final long l1;
        private BigDecimal totoalHours = BigDecimal.ZERO;

        public IndustryWorkHourBo(long l1) {
            this.l1 = l1;
        }

        public long getL1() {
            return this.l1;
        }

        void addWorkHour(BigDecimal workHour) {
            this.totoalHours = this.totoalHours.add(workHour);
        }

        public BigDecimal getTotoalHours() {
            return this.totoalHours;
        }
    }
}

