/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workinghours;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class WorkHourTemplateReportAudtiOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("issync");
        fieldKeys.add("pre_estimatedbillid");
        fieldKeys.add("cur_estimatedbillid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        HashSet<Long> estimatedBillIds = new HashSet<Long>(16);
        HashSet<Long> preEstimatedBillIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("resourceplan_entryentity");
            for (DynamicObject dynamicObject : collection) {
                if (!dynamicObject.getBoolean("issync")) continue;
                preEstimatedBillIds.add(dynamicObject.getLong("pre_estimatedbillid"));
                estimatedBillIds.add(dynamicObject.getLong("cur_estimatedbillid"));
            }
        }
        if (estimatedBillIds.isEmpty()) {
            return;
        }
        this.updateEffectinveStatus(preEstimatedBillIds);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("fromReport", "true");
        Object[] estimatedBillIdArray = estimatedBillIds.toArray();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pmpd_hour_estimate", (Object[])estimatedBillIdArray, (OperateOption)operateOption);
        if (operationResult.isSuccess()) {
            OperationServiceHelper.executeOperate((String)"audit", (String)"pmpd_hour_estimate", (Object[])estimatedBillIdArray, (OperateOption)operateOption);
        }
    }

    private void updateEffectinveStatus(Set<Long> preEstimatedBillIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmpd_hour_estimate");
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)preEstimatedBillIds.size());
        for (Long preEstimatedBillId : preEstimatedBillIds) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt, (Object)preEstimatedBillId);
            dynamicObject.set("effectivestatus", (Object)"2");
            dynamicObjectList.add(dynamicObject);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
    }
}

