/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workinghours.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;

public class WorkHourTemplateUnAuditValidator
extends AbstractValidator {
    public void validate() {
        Map<Object, ExtendedDataEntity> id2DataEntity = Arrays.stream(this.dataEntities).collect(Collectors.toMap(ExtendedDataEntity::getBillPkId, extendedDataEntity -> extendedDataEntity));
        this.checkChanged(id2DataEntity);
        this.checkRefrenced(id2DataEntity);
    }

    private void checkChanged(Map<Object, ExtendedDataEntity> id2DataEntity) {
        Map cache = BusinessDataServiceHelper.loadFromCache((String)this.entityKey, (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", id2DataEntity.keySet())});
        HashSet<Object> sourceBillIdSet = new HashSet<Object>(16);
        for (Map.Entry entry : cache.entrySet()) {
            Object sourceBillId = ((DynamicObject)entry.getValue()).get("sourcebillid");
            sourceBillIdSet.add(sourceBillId);
        }
        for (Map.Entry<Object, Object> entry : id2DataEntity.entrySet()) {
            if (!sourceBillIdSet.contains(entry.getKey())) continue;
            this.addErrorMessage((ExtendedDataEntity)entry.getValue(), ResManager.loadKDString((String)"\u5b58\u5728\u53d8\u66f4\u4e0d\u80fd\u88ab\u53cd\u5ba1\u6838\u3002", (String)"WorkHourTemplateUnAuditValidator_1", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkRefrenced(Map<Object, ExtendedDataEntity> id2DataEntity) {
        Map result = BaseDataRefrenceHelper.checkRefrenced((BasedataEntityType)((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)this.entityKey)), (Object[])id2DataEntity.keySet().toArray(new Object[0]), null, null, (OperateOption)OperateOption.create());
        for (Map.Entry entry : result.entrySet()) {
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
            if (!refrenceResult.isRefence()) continue;
            BaseDataRefenceKey refenceKey = refrenceResult.getRefenceKey();
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refenceKey.getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String tableName = refenceKey.getRefTable();
            String fieldName = refenceKey.getRefCol();
            for (Map.Entry fieldEntry : refMainType.getAllFields().entrySet()) {
                IDataEntityProperty property = (IDataEntityProperty)fieldEntry.getValue();
                if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName) || !(property instanceof IFieldHandle) || property.getParent() == null || property.getParent().getAlias() == null) continue;
                String propTableName = property.getParent().getAlias();
                if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
                    propTableName = propTableName + "_" + property.getTableGroup();
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName)) continue;
                fieldName = property.getDisplayName().toString();
            }
            this.addErrorMessage(id2DataEntity.get(entry.getKey()), String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u53cd\u5ba1\u6838\uff1a[%1$s]\u7684\u5b57\u6bb5[%2$s]\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"WorkHourTemplateUnAuditValidator_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), billName, fieldName));
        }
    }
}

