/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workpackage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.business.helper.OperationHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;

public class ExecuteWorkPackManageGenerateMroOrderOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)e.getValidExtDataEntities().get(0);
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long executeOrgId = dataEntity.getLong("executeorg_id");
        if (executeOrgId == 0L) {
            e.setCancel(true);
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)LocaleStringHelper.buildEmptyFieldValueMsg((IDataEntityType)this.billEntityType, (String)"executeorg"));
            this.operationResult.addErrorInfo(operateErrorInfo);
            return;
        }
        boolean isGeneratePanelMroOrder = "generatepanelmroorder".equals(e.getOperationKey());
        String entryKey = isGeneratePanelMroOrder ? "entry_panel_jobcard" : "entry_internal_jobcard";
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection(entryKey);
        if (collection.isEmpty()) {
            e.setCancel(true);
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u201c%s\u201d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ExecuteWorkPackManageGenerateMroOrderOp_4", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), collection.getDynamicObjectType().getDisplayName().toString()));
            this.operationResult.addErrorInfo(operateErrorInfo);
            return;
        }
        HashMap<Long, String> paginationMap = isGeneratePanelMroOrder ? Collections.emptyMap() : new HashMap<Long, String>(16);
        Table<Long, Long, Long> table = this.groupByProject(isGeneratePanelMroOrder, collection, paginationMap);
        if (table.isEmpty()) {
            e.setCancel(true);
            DynamicObjectType entryType = collection.getDynamicObjectType();
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5df2\u5b58\u5728\u3002", (String)"ExecuteWorkPackManageGenerateMroOrderOp_5", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)entryType), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)entryType, (String)(isGeneratePanelMroOrder ? "panel_jobno" : "internal_jobno"))));
            this.operationResult.addErrorInfo(operateErrorInfo);
            return;
        }
        JSONArray resultArray = this.invokeGenerateMroOrderService(executeOrgId, dataEntity.getPkValue(), isGeneratePanelMroOrder, table, paginationMap);
        if (resultArray.size() == table.rowMap().size()) {
            ArrayList<Object[]> values = new ArrayList<Object[]>(10);
            int projectIndex = 0;
            for (Map.Entry projectEntry : table.rowMap().entrySet()) {
                JSONObject result;
                if (!(result = resultArray.getJSONObject(projectIndex++)).getBooleanValue("status")) {
                    e.setCancel(true);
                    String msg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5de5\u5355\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ExecuteWorkPackManageGenerateMroOrderOp_6", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), result.getString("msg"));
                    this.operationResult.addErrorInfo(OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)msg));
                    continue;
                }
                Collection entryIds = ((Map)projectEntry.getValue()).values();
                JSONArray workOrderArray = result.getJSONArray("entryentity");
                if (entryIds.size() != workOrderArray.size()) continue;
                int workOrderIndex = 0;
                for (Long entryId : entryIds) {
                    JSONObject workOrder = workOrderArray.getJSONObject(workOrderIndex++);
                    long jobId = workOrder.getLongValue("orderid");
                    String jobNo = workOrder.getString("orderno");
                    values.add(new Object[]{jobId, jobNo, entryId});
                }
            }
            if (!values.isEmpty()) {
                String updateSql = isGeneratePanelMroOrder ? "UPDATE t_pmpd_panel_jobcard SET fjobid=?, fjobno=? WHERE fentryid=?" : "UPDATE t_pmpd_internal_jobcard SET fjobid=?, fjobno=? WHERE fentryid=?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"pmc"), (String)updateSql, values);
            }
        }
    }

    private JSONArray invokeGenerateMroOrderService(long executeOrgId, Object workPackManageId, boolean isGeneratePanelMroOrder, Table<Long, Long, Long> table, Map<Long, String> paginationMap) {
        JSONArray paramsArray = new JSONArray(table.size());
        Map panelDefMap = isGeneratePanelMroOrder ? this.queryPanelWorkCardList(table.values()) : Collections.emptyMap();
        for (Map.Entry projectEntry : table.rowMap().entrySet()) {
            JSONObject params = new JSONObject(5);
            params.put("packageid", workPackManageId);
            params.put("workpacktype", (Object)(isGeneratePanelMroOrder ? "panelworkpack" : "internalworkpack"));
            params.put("orgid", (Object)executeOrgId);
            params.put("projectid", projectEntry.getKey());
            JSONArray paramCollection = new JSONArray(((Map)projectEntry.getValue()).size());
            for (Map.Entry workCardEntry : ((Map)projectEntry.getValue()).entrySet()) {
                Long workCardId = (Long)workCardEntry.getKey();
                Long entryId = (Long)workCardEntry.getValue();
                JSONObject param = new JSONObject(3);
                param.put("workcardid", (Object)workCardId);
                param.put("pageseq", (Object)paginationMap.getOrDefault(entryId, ""));
                if (isGeneratePanelMroOrder) {
                    param.put("paneldefids", panelDefMap.getOrDefault(entryId, Collections.emptyList()));
                }
                paramCollection.add((Object)param);
            }
            params.put("entryentity", (Object)paramCollection);
            paramsArray.add((Object)params);
        }
        return (JSONArray)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"BatchCreateMROOrder", (String)"batchCreateMroOrderFromExecPack", (Object[])new Object[]{paramsArray});
    }

    private Map<Long, List<Long>> queryPanelWorkCardList(Collection<Long> panelWorkCardIds) {
        String selectFields = "entryentity.panelworkcardid, entryentity.subentryentity.paneldef";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity.panelworkcardid", "in", panelWorkCardIds)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_panelworkcard_list", (String)selectFields, (QFilter[])filters, null);){
            if (dataSet.isEmpty()) {
                Map<Long, List<Long>> map = Collections.emptyMap();
                return map;
            }
            HashMap<Long, List> result = new HashMap<Long, List>(16);
            for (Row row : dataSet) {
                Long panelDefId;
                Long panelWorkCardId = ObjectConverterWrapper.getLong((Object)row.get(0));
                if (panelWorkCardId == 0L || (panelDefId = ObjectConverterWrapper.getLong((Object)row.get(1))) == 0L) continue;
                List panelDefIds = result.computeIfAbsent(panelWorkCardId, k -> new ArrayList(10));
                panelDefIds.add(panelDefId);
            }
            HashMap<Long, List> hashMap = result;
            return hashMap;
        }
    }

    private Table<Long, Long, Long> groupByProject(boolean isGeneratePanelMroOrder, DynamicObjectCollection collection, Map<Long, String> paginationMap) {
        DynamicObjectType entryType = collection.getDynamicObjectType();
        ISimpleProperty primaryKey = entryType.getPrimaryKey();
        HashBasedTable table = HashBasedTable.create();
        if (isGeneratePanelMroOrder) {
            for (DynamicObject entry : collection) {
                if (entry.getLong("panel_jobid") != 0L) continue;
                table.put((Object)entry.getLong("panel_project_id"), (Object)entry.getLong("panel_jobcard_id"), (Object)ObjectConverterWrapper.getLong((Object)primaryKey.getValueFast((Object)entry)));
            }
        } else {
            String selectedEntryIdsStr = this.getOption().getVariableValue("selectedEntryIds", "");
            Set selectedEntryIds = StringUtils.isEmpty((CharSequence)selectedEntryIdsStr) ? Collections.emptySet() : (Set)SerializationUtils.fromJsonString((String)selectedEntryIdsStr, HashSet.class);
            for (DynamicObject entry : collection) {
                Long entryId = ObjectConverterWrapper.getLong((Object)primaryKey.getValueFast((Object)entry));
                if (!selectedEntryIds.contains(entryId) || entry.getLong("internal_jobid") != 0L) continue;
                table.put((Object)entry.getLong("internal_project_id"), (Object)entry.getLong("internal_jobcard_id"), (Object)entryId);
                paginationMap.put(entryId, entry.getString("internal_pagination"));
            }
        }
        return table;
    }
}

