/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workpackage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.model.WorkPackageProjectInfo;
import kd.pmc.pmpd.common.util.WorkPackImportUtils;
import kd.pmc.pmpd.common.util.WorkPackageUtils;
import kd.pmc.pmpd.opplugin.workpackage.validator.ExecuteWorkPackSaveValidator;
import org.apache.commons.collections4.MapUtils;

public class ExecuteWorkPackSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ExecuteWorkPackSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<String, ExecuteWorkPackEntryBo> executeWorkPackEntryBoMap = this.getExecuteWorkPackEntryBoMap();
        if (WorkPackImportUtils.isFromImport((OperateOption)this.getOption())) {
            this.fillDataFromImport(dataEntities, executeWorkPackEntryBoMap);
            return;
        }
        this.fillData(dataEntities, executeWorkPackEntryBoMap);
    }

    private void fillData(DynamicObject[] dataEntities, Map<String, ExecuteWorkPackEntryBo> executeWorkPackEntryBoMap) {
        StringBuilder uniqueKeyBuilder = new StringBuilder();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : collection) {
                ExecuteWorkPackEntryBo executeWorkPackEntryBo;
                long workCardId;
                String customerJobCardStatus = entry.getString("customer_jobcardstatus");
                if (!WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus) || (workCardId = entry.getLong("jobcard_id")) != 0L || (executeWorkPackEntryBo = executeWorkPackEntryBoMap.get(this.buildUniqueKey(uniqueKeyBuilder, entry))) == null) continue;
                entry.set("jobid", (Object)executeWorkPackEntryBo.getJobId());
                entry.set("jobno", (Object)executeWorkPackEntryBo.getJobNo());
                entry.set("jobcard_id", (Object)executeWorkPackEntryBo.getJobCardId());
            }
        }
    }

    private void fillDataFromImport(DynamicObject[] dataEntities, Map<String, ExecuteWorkPackEntryBo> executeWorkPackEntryBoMap) {
        long manageId = dataEntities[0].getLong("manageid");
        Map<String, Integer> name2MaxSupplementNo = this.getName2MaxSupplementNo();
        Map<String, WorkPackageProjectInfo> projectInfoMap = this.getProjectInfoByName(dataEntities);
        WorkPackageProjectInfo workPackageProjectInfo = WorkPackageUtils.updateExecuteWorkPackManageHeader((long)manageId);
        StringBuilder uniqueKeyBuilder = new StringBuilder();
        long[] entryIds = ID.genLongIds((int)this.getEntryCount(dataEntities));
        int index = 0;
        for (DynamicObject dataEntity : dataEntities) {
            Object customerJobCardStatus;
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : collection) {
                ExecuteWorkPackEntryBo executeWorkPackEntryBo;
                entry.set("id", (Object)entryIds[index++]);
                customerJobCardStatus = entry.getString("customer_jobcardstatus");
                if (!WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus) || (executeWorkPackEntryBo = executeWorkPackEntryBoMap.get(this.buildUniqueKey(uniqueKeyBuilder, entry))) == null) continue;
                entry.set("jobid", (Object)executeWorkPackEntryBo.getJobId());
                entry.set("jobno", (Object)executeWorkPackEntryBo.getJobNo());
                entry.set("jobcard_id", (Object)executeWorkPackEntryBo.getJobCardId());
            }
            String name = dataEntity.getString("name");
            Integer maxSupplementNo = name2MaxSupplementNo.get(name);
            if (maxSupplementNo == null) {
                dataEntity.set("supplement", (Object)"0");
                this.fillProjectInfo(workPackageProjectInfo, dataEntity);
                continue;
            }
            customerJobCardStatus = maxSupplementNo;
            Integer n = maxSupplementNo = Integer.valueOf(maxSupplementNo + 1);
            dataEntity.set("supplement", (Object)String.valueOf(maxSupplementNo));
            name2MaxSupplementNo.put(name, maxSupplementNo);
            WorkPackageProjectInfo projectInfo = projectInfoMap.get(name);
            this.fillProjectInfo(projectInfo, dataEntity);
        }
        long projectId = workPackageProjectInfo == null ? 0L : workPackageProjectInfo.getProjectId();
        this.createVersionReport(dataEntities, manageId, projectId);
    }

    private void fillProjectInfo(WorkPackageProjectInfo workPackageProjectInfo, DynamicObject dataEntity) {
        if (workPackageProjectInfo == null) {
            workPackageProjectInfo = new WorkPackageProjectInfo();
        }
        dataEntity.set("project_id", (Object)workPackageProjectInfo.getProjectId());
        dataEntity.set("contractid", (Object)workPackageProjectInfo.getContractId());
        dataEntity.set("contractno", (Object)workPackageProjectInfo.getContractNo());
        dataEntity.set("checktype_id", (Object)workPackageProjectInfo.getCheckTypeId());
        dataEntity.set("workscope_id", (Object)workPackageProjectInfo.getWorkScopeId());
    }

    private Map<String, WorkPackageProjectInfo> getProjectInfoByName(DynamicObject[] dataEntities) {
        Map<String, Long> name2Project = this.getName2Project();
        HashSet<Long> projectIds = new HashSet<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            String name = dataEntity.getString("name");
            Long projectId = name2Project.get(name);
            if (projectId == null) continue;
            projectIds.add(projectId);
        }
        HashMap<String, WorkPackageProjectInfo> resultMap = new HashMap<String, WorkPackageProjectInfo>(16);
        Map projectInfoMap = WorkPackageUtils.getWorkPackageProjectInfo((Object[])projectIds.toArray());
        for (Map.Entry<String, Long> entry : name2Project.entrySet()) {
            resultMap.put(entry.getKey(), (WorkPackageProjectInfo)projectInfoMap.get(entry.getValue()));
        }
        return resultMap;
    }

    private void createVersionReport(DynamicObject[] dataEntities, long executeWorkPackageManageId, long projectId) {
        ArrayList<DynamicObject> versionReports = new ArrayList<DynamicObject>(10);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject versionReport = this.createVersionReport(executeWorkPackageManageId, projectId, (long)((Long)dataEntity.getPkValue()));
            DynamicObjectCollection entryCollection = versionReport.getDynamicObjectCollection("entryentity");
            HashMap<String, DynamicObject> statusEntryMap = new HashMap<String, DynamicObject>(16);
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : collection) {
                String customerJobCardStatus = entry.getString("customer_jobcardstatus");
                if (StringUtils.isBlank((CharSequence)customerJobCardStatus)) continue;
                DynamicObject reportEntry = statusEntryMap.computeIfAbsent(customerJobCardStatus, k -> {
                    DynamicObject dynamicObject = entryCollection.addNew();
                    dynamicObject.set("seq", (Object)entryCollection.size());
                    dynamicObject.set("customer_jobcardstatus", (Object)customerJobCardStatus);
                    return dynamicObject;
                });
                DynamicObjectCollection reportSubEntryCollection = reportEntry.getDynamicObjectCollection("subentryentity");
                DynamicObject reportSubEntry = reportSubEntryCollection.addNew();
                reportSubEntry.set("seq", (Object)reportSubEntryCollection.size());
                reportSubEntry.set("workpackentryid", (Object)entry.getLong("id"));
                reportSubEntry.set("customer_jobcardno", (Object)entry.getString("customer_jobcardno"));
                reportSubEntry.set("customer_jobcardversion", (Object)entry.getString("customer_jobcardversion"));
                if (!WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus)) continue;
                reportSubEntry.set("workorder_id", (Object)entry.getLong("jobid"));
                reportSubEntry.set("jobcard_id", (Object)entry.getLong("jobcard_id"));
            }
            versionReports.add(versionReport);
        }
        SaveServiceHelper.save((DynamicObject[])versionReports.toArray(new DynamicObject[0]));
    }

    private DynamicObject createVersionReport(long executeWorkPackageManageId, long projectId, long workPackId) {
        DynamicObject versionReport = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_workpack_versionrpt"));
        versionReport.set("executeworkpackmanage_id", (Object)executeWorkPackageManageId);
        versionReport.set("project", (Object)projectId);
        versionReport.set("workpack_id", (Object)workPackId);
        return versionReport;
    }

    private String buildUniqueKey(StringBuilder uniqueKeyBuilder, DynamicObject entry) {
        uniqueKeyBuilder.setLength(0);
        uniqueKeyBuilder.append(entry.getString("customer_jobcardno")).append('-').append(entry.getString("auxiliarycode").trim());
        return uniqueKeyBuilder.toString();
    }

    private int getEntryCount(DynamicObject[] dataEntities) {
        int count = 0;
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            count += collection.size();
        }
        return count;
    }

    private Map<String, ExecuteWorkPackEntryBo> getExecuteWorkPackEntryBoMap() {
        Map workPackEntryStrMap;
        String json = this.getOption().getVariableValue("workPackEntry", "");
        Map map = workPackEntryStrMap = StringUtils.isEmpty((CharSequence)json) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)json, HashMap.class);
        if (MapUtils.isEmpty((Map)workPackEntryStrMap)) {
            return Collections.emptyMap();
        }
        Map<Long, String> workPackEntryMap = workPackEntryStrMap.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue, (k1, k2) -> k1));
        HashMap<String, ExecuteWorkPackEntryBo> resultMap = new HashMap<String, ExecuteWorkPackEntryBo>(16);
        String selectFields = "entryentity.id, entryentity.jobid, entryentity.jobno, entryentity.jobcard";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity", "in", workPackEntryMap.keySet())};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_exec_workpack", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dataSet) {
                ExecuteWorkPackEntryBo executeWorkPackEntryBo = new ExecuteWorkPackEntryBo();
                executeWorkPackEntryBo.setJobId(ObjectConverterWrapper.getLong((Object)row.get(1)));
                executeWorkPackEntryBo.setJobNo(ObjectConverterWrapper.getString((Object)row.get(2)));
                executeWorkPackEntryBo.setJobCardId(ObjectConverterWrapper.getLong((Object)row.get(3)));
                String uniqueKey = workPackEntryMap.getOrDefault(ObjectConverterWrapper.getLong((Object)row.get(0)), "");
                resultMap.put(uniqueKey, executeWorkPackEntryBo);
            }
        }
        return resultMap;
    }

    private Map<String, Integer> getName2MaxSupplementNo() {
        String json = this.getOption().getVariableValue("supplementNo", "");
        return StringUtils.isEmpty((CharSequence)json) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)json, HashMap.class);
    }

    private Map<String, Long> getName2Project() {
        String json = this.getOption().getVariableValue("name2Project", "");
        return StringUtils.isEmpty((CharSequence)json) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)json, HashMap.class);
    }

    private static class ExecuteWorkPackEntryBo {
        private long jobId;
        private String jobNo;
        private long jobCardId;

        private ExecuteWorkPackEntryBo() {
        }

        public long getJobId() {
            return this.jobId;
        }

        public void setJobId(long jobId) {
            this.jobId = jobId;
        }

        public String getJobNo() {
            return this.jobNo;
        }

        public void setJobNo(String jobNo) {
            this.jobNo = jobNo;
        }

        public long getJobCardId() {
            return this.jobCardId;
        }

        public void setJobCardId(long jobCardId) {
            this.jobCardId = jobCardId;
        }
    }
}

