/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workpackage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.OperationHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import org.apache.commons.collections4.MapUtils;

public class GenerateExecuteWorkPackageOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add("type");
        fieldKeys.add("version");
        fieldKeys.add("supplement");
        fieldKeys.add("contractid");
        fieldKeys.add("contractno");
        fieldKeys.add("manageid");
        fieldKeys.add("org_id");
        fieldKeys.add("customer_jobcardno");
        fieldKeys.add("customer_jobcardversion");
        fieldKeys.add("customer_jobcardstatus");
        fieldKeys.add("entryentity.seq");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List errorMsgs;
        List extDataEntities = e.getValidExtDataEntities();
        Set<Long> contractIds = extDataEntities.stream().map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("contractid")).collect(Collectors.toSet());
        Map<Long, Long> contractId2ProjectId = this.getProjectIdByContractId(contractIds);
        int size = extDataEntities.size();
        DynamicObject[] executeWorkPacks = new DynamicObject[size];
        MainEntityType executeWorkPackDataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
        for (int i = 0; i < size; ++i) {
            ExtendedDataEntity extendedDataEntity2 = (ExtendedDataEntity)extDataEntities.get(i);
            DynamicObject executeWorkPackage = new DynamicObject((DynamicObjectType)executeWorkPackDataEntityType);
            this.copyWorkPackage(extendedDataEntity2.getDataEntity(), executeWorkPackage, contractId2ProjectId);
            executeWorkPacks[i] = executeWorkPackage;
        }
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"pmpd_exec_workpack", (DynamicObject[])executeWorkPacks, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            return;
        }
        HashMap<Integer, List> dataIndex2ErrorMsg = new HashMap<Integer, List>(16);
        for (OperateErrorInfo operateErrorInfo : operationResult.getAllErrorInfo()) {
            List errorMsgs2 = dataIndex2ErrorMsg.computeIfAbsent(operateErrorInfo.getDataEntityIndex(), k -> new ArrayList(10));
            errorMsgs2.add(operateErrorInfo.getMessage());
        }
        for (ValidateResult validateError : operationResult.getValidateResult().getValidateErrors()) {
            for (OperateErrorInfo operateErrorInfo : validateError.getAllErrorInfo()) {
                errorMsgs = dataIndex2ErrorMsg.computeIfAbsent(operateErrorInfo.getDataEntityIndex(), k -> new ArrayList(10));
                errorMsgs.add(operateErrorInfo.getMessage());
            }
        }
        String errorMsgPrefix = String.format(ResManager.loadKDString((String)"[%1$s]\u4fdd\u5b58\u5931\u8d25%2$s", (String)"GenerateExecuteWorkPackageOp_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), executeWorkPackDataEntityType.getDisplayName().toString(), "\uff0c");
        boolean isSingle = dataIndex2ErrorMsg.size() == 1;
        Iterator iterator = extDataEntities.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity extendedDataEntity3 = (ExtendedDataEntity)iterator.next();
            errorMsgs = (List)dataIndex2ErrorMsg.get(extendedDataEntity3.getDataEntityIndex());
            if (errorMsgs == null) continue;
            for (String errorMsg : errorMsgs) {
                OperateErrorInfo operateErrorInfo = isSingle ? OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity3, (String)(errorMsgPrefix + errorMsg)) : OperationHelper.buildMultiErrorInfo((ExtendedDataEntity)extendedDataEntity3, (String)OperationHelper.getOperationName((Map)this.operateMeta), (String)(errorMsgPrefix + errorMsg));
                this.operationResult.addErrorInfo(operateErrorInfo);
            }
            iterator.remove();
        }
    }

    private void copyWorkPackage(DynamicObject contractWorkPackage, DynamicObject executeWorkPackage, Map<Long, Long> contractId2ProjectId) {
        executeWorkPackage.set("name", contractWorkPackage.get("name"));
        executeWorkPackage.set("type", contractWorkPackage.get("type"));
        executeWorkPackage.set("version", contractWorkPackage.get("version"));
        executeWorkPackage.set("supplement", contractWorkPackage.get("supplement"));
        long contractId = contractWorkPackage.getLong("contractid");
        executeWorkPackage.set("contractid", (Object)contractId);
        executeWorkPackage.set("contractno", contractWorkPackage.get("contractno"));
        executeWorkPackage.set("project_id", (Object)contractId2ProjectId.getOrDefault(contractId, 0L));
        executeWorkPackage.set("manageid", contractWorkPackage.get("manageid"));
        executeWorkPackage.set("org_id", contractWorkPackage.get("org_id"));
        executeWorkPackage.set("billstatus", (Object)"A");
        executeWorkPackage.set("datastatus", (Object)"open");
        executeWorkPackage.set("source", (Object)"contract");
        long currUserId = RequestContext.get().getCurrUserId();
        executeWorkPackage.set("creator_id", (Object)currUserId);
        executeWorkPackage.set("modifier_id", (Object)currUserId);
        DynamicObjectCollection contractWorkPackageCollection = contractWorkPackage.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection executeWorkPackageCollection = executeWorkPackage.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = executeWorkPackageCollection.getDynamicObjectType().getProperties();
        IDataEntityProperty entryCreatorProp = (IDataEntityProperty)properties.get((Object)"entry_creator_id");
        IDataEntityProperty entryModifierProp = (IDataEntityProperty)properties.get((Object)"entry_modifier_id");
        List<IDataEntityProperty> executeWorkPackageEntryProperties = this.getEntryProperties(properties);
        List<IDataEntityProperty> contractWorkPackageEntryProperties = this.getEntryProperties(contractWorkPackageCollection.getDynamicObjectType().getProperties());
        int propertySize = executeWorkPackageEntryProperties.size();
        for (DynamicObject contractWorkPackageEntry : contractWorkPackageCollection) {
            DynamicObject executeWorkPackageEntry = executeWorkPackageCollection.addNew();
            for (int i = 0; i < propertySize; ++i) {
                IDataEntityProperty property = contractWorkPackageEntryProperties.get(i);
                executeWorkPackageEntryProperties.get(i).setValueFast((Object)executeWorkPackageEntry, ObjectConverter.convert((Object)property.getValueFast((Object)contractWorkPackageEntry), (Class)property.getPropertyType(), (boolean)property.isEnableNull()));
            }
            entryCreatorProp.setValueFast((Object)executeWorkPackageEntry, (Object)currUserId);
            entryModifierProp.setValueFast((Object)executeWorkPackageEntry, (Object)currUserId);
        }
    }

    private List<IDataEntityProperty> getEntryProperties(DataEntityPropertyCollection properties) {
        ArrayList entityProperties = Lists.newArrayListWithExpectedSize((int)4);
        entityProperties.add(properties.get((Object)"seq"));
        entityProperties.add(properties.get((Object)"customer_jobcardno"));
        entityProperties.add(properties.get((Object)"customer_jobcardversion"));
        entityProperties.add(properties.get((Object)"customer_jobcardstatus"));
        return entityProperties;
    }

    private Map<Long, Long> getProjectIdByContractId(Set<Long> contractIds) {
        QFilter[] filters = new QFilter[]{new QFilter("entryentity.saleconstract", "in", contractIds), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"pmpd_project", (String)"id, entryentity.saleconstract", (QFilter[])filters);
        if (MapUtils.isEmpty((Map)cache)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> contractId2ProjectId = new HashMap<Long, Long>(16);
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject project = (DynamicObject)entry.getValue();
            Long projectId = ObjectConverterWrapper.getLong((Object)project.getPkValue());
            DynamicObjectCollection contractEntryCollection = project.getDynamicObjectCollection("entryentity");
            for (DynamicObject contractEntry : contractEntryCollection) {
                contractId2ProjectId.put(contractEntry.getLong("saleconstract"), projectId);
            }
        }
        return contractId2ProjectId;
    }
}

