/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workpackage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.MMCCommonThreadPoolUtil;
import kd.bos.algo.DataSet;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.pmc.pmpd.business.helper.OperationHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.util.WorkPackageUtils;
import kd.pmc.pmpd.opplugin.workpackage.validator.GenerateMroOrderValidator;

public class GenerateMroOrderOp
extends AbstractOperationServicePlugIn {
    private static final ThreadExecutorService THREAD_POOL = GenerateMroOrderOp.getThreadPool();
    private static final Log log = LogFactory.getLog(GenerateMroOrderOp.class);
    private IDataEntityProperty projectProp;
    private IDataEntityProperty projectIdProp;
    private IDataEntityProperty billStatusProp;
    private IDataEntityProperty dataStatusProp;
    private IDataEntityProperty entryIdProp;
    private IDataEntityProperty jobIdProp;
    private IDataEntityProperty jobNoProp;
    private IDataEntityProperty jobCardProp;
    private IDataEntityProperty jobCardIdProp;
    private IDataEntityProperty isMultiPageProp;
    private IDataEntityProperty workOrderRangeProp;
    private IDataEntityProperty workOrderSizeProp;
    private IDataEntityProperty paginationProp;
    private IDataEntityProperty isFirstExecuteProp;
    private IDataEntityProperty outSourceProp;
    private IDataEntityProperty riskJobCardProp;
    private IDataEntityProperty priorityProp;
    private IDataEntityProperty majorWorkProp;
    private IDataEntityProperty sequenceNumberProp;
    private IDataEntityProperty customerJobCardStatusProp;
    private IDataEntityProperty errMsgProp;

    private static ThreadExecutorService getThreadPool() {
        return MMCCommonThreadPoolUtil.getThreadExecutorService();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("manageid");
        fieldKeys.add("billstatus");
        fieldKeys.add("datastatus");
        fieldKeys.add("project_id");
        fieldKeys.add("project");
        fieldKeys.add("workorder_range");
        fieldKeys.add("workorder_size");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("entryentity.jobid");
        fieldKeys.add("entryentity.jobno");
        fieldKeys.add("entryentity.jobcard");
        fieldKeys.add("entryentity.ismultipage");
        fieldKeys.add("entryentity.pagination");
        fieldKeys.add("entryentity.sequencenumber");
        fieldKeys.add("entryentity.outsource");
        fieldKeys.add("entryentity.riskjobcard");
        fieldKeys.add("entryentity.priority");
        fieldKeys.add("entryentity.majorwork");
        fieldKeys.add("entryentity.isfirstexecute");
        fieldKeys.add("entryentity.customer_jobcardstatus");
        fieldKeys.add("entryentity.errmsg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new GenerateMroOrderValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (!this.operationResult.isSuccess()) {
            e.setCancel(true);
            return;
        }
        List<ExtendedDataEntity> validExtDataEntities = e.getValidExtDataEntities();
        ExtendedDataEntity firstDataEntity = (ExtendedDataEntity)validExtDataEntities.get(0);
        Object manageId = firstDataEntity.getValue("manageid");
        long executeOrgId = this.getExecuteOrgId(manageId);
        if (executeOrgId == 0L) {
            e.setCancel(true);
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)firstDataEntity, (String)LocaleStringHelper.buildEmptyQueryResultMsg((String)"pmpd_exec_workpack_manage", (String)"executeorg"));
            this.operationResult.addErrorInfo(operateErrorInfo);
            return;
        }
        this.initProp(firstDataEntity);
        Map<Object, ExtendedDataEntity> extendedDataEntityMap = validExtDataEntities.stream().collect(Collectors.toMap(ExtendedDataEntity::getBillPkId, Function.identity(), (k1, k2) -> k1));
        validExtDataEntities = this.sort(extendedDataEntityMap, validExtDataEntities);
        this.initJobNo(validExtDataEntities, manageId);
        int orderSize = this.getToWorkOrderSize(validExtDataEntities);
        if (orderSize == 0) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(orderSize);
        ArrayList<DynamicObject> workPackagePaginationList = new ArrayList<DynamicObject>(10);
        HashSet<String> billNo = new HashSet<String>(orderSize);
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : collection) {
                JSONArray executeWorkPackageDTOArray = new JSONArray(1);
                JSONArray executeWorkPackageEntryDTOArray = new JSONArray(1);
                String customerJobCardStatus = ObjectConverterWrapper.getString((Object)this.customerJobCardStatusProp.getValueFast((Object)dynamicObject));
                if (WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus) || this.isNotErrorWorkOrder(dynamicObject)) {
                    this.errMsgProp.setValue((Object)dynamicObject, (Object)"");
                    continue;
                }
                JSONObject executeWorkPackageEntryDTO = new JSONObject(7);
                executeWorkPackageEntryDTO.put("workcardid", (Object)ObjectConverterWrapper.getLong((Object)this.jobCardIdProp.getValueFast((Object)dynamicObject)));
                String pagination = ObjectConverterWrapper.getBoolean((Object)this.isMultiPageProp.getValueFast((Object)dynamicObject)) != false ? "" : ObjectConverterWrapper.getString((Object)this.paginationProp.getValueFast((Object)dynamicObject));
                executeWorkPackageEntryDTO.put("pageseq", (Object)pagination);
                executeWorkPackageEntryDTO.put("isfirstexe", (Object)ObjectConverterWrapper.getBoolean((Object)this.isFirstExecuteProp.getValueFast((Object)dynamicObject)));
                executeWorkPackageEntryDTO.put("isom", (Object)ObjectConverterWrapper.getBoolean((Object)this.outSourceProp.getValueFast((Object)dynamicObject)));
                executeWorkPackageEntryDTO.put("riskcard", (Object)ObjectConverterWrapper.getBoolean((Object)this.riskJobCardProp.getValueFast((Object)dynamicObject)));
                executeWorkPackageEntryDTO.put("ismajorwork", (Object)ObjectConverterWrapper.getBoolean((Object)this.majorWorkProp.getValueFast((Object)dynamicObject)));
                executeWorkPackageEntryDTO.put("ispriority", (Object)ObjectConverterWrapper.getBoolean((Object)this.priorityProp.getValueFast((Object)dynamicObject)));
                String orderNo = ObjectConverterWrapper.getString((Object)this.jobNoProp.getValueFast((Object)dynamicObject));
                executeWorkPackageEntryDTO.put("billno", (Object)orderNo);
                billNo.add(orderNo);
                Long jobId = ObjectConverterWrapper.getLong((Object)this.jobIdProp.getValueFast((Object)dynamicObject));
                if (jobId != null && jobId != 0L) {
                    executeWorkPackageEntryDTO.put("id", (Object)jobId);
                }
                executeWorkPackageEntryDTOArray.add((Object)executeWorkPackageEntryDTO);
                JSONObject executeWorkPackageDTO = new JSONObject(5);
                executeWorkPackageDTO.put("packageid", extendedDataEntity.getBillPkId());
                executeWorkPackageDTO.put("workpacktype", (Object)"execworkpack");
                executeWorkPackageDTO.put("orgid", (Object)executeOrgId);
                executeWorkPackageDTO.put("projectid", (Object)ObjectConverterWrapper.getLong((Object)this.projectIdProp.getValueFast((Object)dataEntity)));
                executeWorkPackageDTO.put("entryentity", (Object)executeWorkPackageEntryDTOArray);
                executeWorkPackageDTOArray.add((Object)executeWorkPackageDTO);
                THREAD_POOL.execute(() -> {
                    try {
                        log.info("create mroOrder orderno -------" + orderNo);
                        this.dealResult(executeWorkPackageDTOArray, dynamicObject);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
            }
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            log.error(ex.getMessage());
        }
        boolean isError = false;
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            Object workPackageId = extendedDataEntity.getBillPkId();
            Long projectId = ObjectConverterWrapper.getLong((Object)this.projectIdProp.getValueFast((Object)dataEntity));
            boolean hasError = false;
            for (DynamicObject workPackEntry : collection) {
                DynamicObject workPackagePagination;
                DynamicObject jobCard;
                String jobNo = ObjectConverterWrapper.getString((Object)this.jobNoProp.getValueFast((Object)workPackEntry));
                Long jobId = ObjectConverterWrapper.getLong((Object)this.jobIdProp.getValueFast((Object)workPackEntry));
                String errMsg = ObjectConverterWrapper.getString((Object)this.errMsgProp.getValueFast((Object)workPackEntry));
                if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                    hasError = true;
                    isError = true;
                }
                if (!billNo.contains(jobNo) || jobId == null || jobId == 0L || !ObjectConverterWrapper.getBoolean((Object)this.isMultiPageProp.getValueFast((Object)workPackEntry)).booleanValue() || (jobCard = (DynamicObject)this.jobCardProp.getValueFast((Object)workPackEntry)) == null || (workPackagePagination = this.createWorkPackagePagination(workPackageId, this.entryIdProp.getValueFast((Object)workPackEntry), jobId, jobNo, projectId, jobCard)) == null) continue;
                workPackagePaginationList.add(workPackagePagination);
            }
            if (hasError) continue;
            this.billStatusProp.setValueFast((Object)dataEntity, (Object)"D");
            this.dataStatusProp.setValueFast((Object)dataEntity, (Object)"printed");
        }
        if (isError) {
            e.setCancel(true);
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u751f\u6210\u5de5\u5355\u4efb\u52a1\u5b8c\u6210\uff0c\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u6838\u67e5\u3002", (String)"GenerateMroOrderOp_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
        }
        DynamicObject[] dynamicObjectArray = (DynamicObject[])validExtDataEntities.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        TXServiceHelper.executeWithTX((String)"workpackage-generatemroorder", () -> {
            SaveServiceHelper.save((DynamicObject[])workPackageList);
            if (!workPackagePaginationList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])workPackagePaginationList.toArray(new DynamicObject[0]));
            }
        });
    }

    private List<ExtendedDataEntity> sort(Map<Object, ExtendedDataEntity> extendedDataEntityMap, List<ExtendedDataEntity> validExtDataEntities) {
        String sortedIdsStr = this.operateOption.getVariableValue("sortedids", "");
        if (StringUtils.isEmpty((CharSequence)sortedIdsStr)) {
            return validExtDataEntities;
        }
        List sortedIds = (List)SerializationUtils.fromJsonString((String)sortedIdsStr, List.class);
        return sortedIds.stream().map(extendedDataEntityMap::get).collect(Collectors.toList());
    }

    private void initJobNo(List<ExtendedDataEntity> validExtDataEntities, Object manageId) {
        String customerJobCardStatus;
        boolean hasJobNo;
        ArrayList<DynamicObject> workPackageList = new ArrayList<DynamicObject>(validExtDataEntities.size());
        int serialNumberLength = this.getSerialNumberLength();
        int maxSequenceNumber = WorkPackageUtils.getMaxSequenceNumber((long)ObjectConverterWrapper.getLong((Object)manageId));
        HashMap<Long, Integer> mroOderSize = new HashMap<Long, Integer>(validExtDataEntities.size());
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long projectId = ObjectConverterWrapper.getLong((Object)this.projectIdProp.getValueFast((Object)dataEntity));
            Integer orderSize = mroOderSize.computeIfAbsent(projectId, v -> 0);
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            if (collection.isEmpty()) continue;
            hasJobNo = false;
            for (DynamicObject dynamicObject : collection) {
                customerJobCardStatus = ObjectConverterWrapper.getString((Object)this.customerJobCardStatusProp.getValueFast((Object)dynamicObject));
                Object firstInitJobNo = this.jobNoProp.getValueFast((Object)dynamicObject);
                if (StringUtils.isNotBlank((Object)firstInitJobNo)) {
                    hasJobNo = true;
                    break;
                }
                if (WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus)) continue;
                Integer n = orderSize;
                Integer n2 = orderSize = Integer.valueOf(orderSize + 1);
            }
            if (hasJobNo) continue;
            mroOderSize.put(projectId, orderSize);
        }
        HashMap projectNos = new HashMap(mroOderSize.size());
        for (Map.Entry entry : mroOderSize.entrySet()) {
            List<String> jobNos = this.geneJobNo((Long)entry.getKey(), (Integer)entry.getValue());
            projectNos.put(entry.getKey(), jobNos);
        }
        for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
            StringBuilder rangeBuilder = new StringBuilder();
            DynamicObject dataEntity = validExtDataEntity.getDataEntity();
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            if (collection.isEmpty()) continue;
            int orderSize = 0;
            hasJobNo = false;
            for (DynamicObject dynamicObject : collection) {
                customerJobCardStatus = ObjectConverterWrapper.getString((Object)this.customerJobCardStatusProp.getValueFast((Object)dynamicObject));
                Object firstInitJobNo = this.jobNoProp.getValueFast((Object)dynamicObject);
                if (StringUtils.isNotBlank((Object)firstInitJobNo)) {
                    hasJobNo = true;
                    break;
                }
                if (WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus)) continue;
                ++orderSize;
            }
            if (hasJobNo) continue;
            Long projectId = ObjectConverterWrapper.getLong((Object)this.projectIdProp.getValueFast((Object)dataEntity));
            List proJobNos = (List)projectNos.get(projectId);
            List<String> jobNos = proJobNos.subList(0, orderSize);
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject entry = (DynamicObject)collection.get(i);
                this.jobNoProp.setValueFast((Object)entry, (Object)jobNos.get(i));
                this.sequenceNumberProp.setValueFast((Object)entry, (Object)(++maxSequenceNumber));
            }
            this.buildWorkOrderRange(jobNos, dataEntity, serialNumberLength, rangeBuilder);
            this.workOrderRangeProp.setValueFast((Object)dataEntity, (Object)rangeBuilder.toString());
            this.workOrderSizeProp.setValueFast((Object)dataEntity, (Object)orderSize);
            workPackageList.add(dataEntity);
            proJobNos.removeAll(jobNos);
        }
        SaveServiceHelper.save((DynamicObject[])workPackageList.toArray(new DynamicObject[0]));
    }

    public List<String> geneJobNo(Long proId, Integer num) {
        return (List)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"IMroOrderCodeRuleService", (String)"genCodeRuleNumbersByImmediately", (Object[])new Object[]{proId, "", num});
    }

    private void initProp(ExtendedDataEntity firstDataEntity) {
        EntityType subEntityType = (EntityType)firstDataEntity.getDataEntity().getDynamicObjectType();
        this.billStatusProp = subEntityType.findProperty("billstatus");
        this.dataStatusProp = subEntityType.findProperty("datastatus");
        this.projectIdProp = subEntityType.findProperty("project_id");
        this.projectProp = subEntityType.findProperty("project");
        this.workOrderRangeProp = subEntityType.findProperty("workorder_range");
        this.workOrderSizeProp = subEntityType.findProperty("workorder_size");
        this.entryIdProp = subEntityType.findProperty("entryentity.id");
        this.jobIdProp = subEntityType.findProperty("jobid");
        this.jobNoProp = subEntityType.findProperty("jobno");
        this.jobCardProp = subEntityType.findProperty("jobcard");
        this.jobCardIdProp = subEntityType.findProperty("jobcard_id");
        this.isMultiPageProp = subEntityType.findProperty("ismultipage");
        this.paginationProp = subEntityType.findProperty("pagination");
        this.isFirstExecuteProp = subEntityType.findProperty("isfirstexecute");
        this.outSourceProp = subEntityType.findProperty("outsource");
        this.riskJobCardProp = subEntityType.findProperty("riskjobcard");
        this.majorWorkProp = subEntityType.findProperty("majorwork");
        this.priorityProp = subEntityType.findProperty("priority");
        this.sequenceNumberProp = subEntityType.findProperty("sequencenumber");
        this.customerJobCardStatusProp = subEntityType.findProperty("customer_jobcardstatus");
        this.errMsgProp = subEntityType.findProperty("errmsg");
    }

    private DynamicObject createWorkPackagePagination(Object workPackageId, Object workPackageEntryId, Object jobId, String jobNo, Object projectId, DynamicObject jobCard) {
        DynamicObjectCollection pageCollection = jobCard.getDynamicObjectCollection("pageentity");
        if (pageCollection.isEmpty()) {
            return null;
        }
        DynamicObject workPackagePagination = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_pagination_selector"));
        workPackagePagination.set("workpackageid", workPackageId);
        workPackagePagination.set("workpackentryid", workPackageEntryId);
        workPackagePagination.set("jobid", jobId);
        workPackagePagination.set("jobno", (Object)jobNo);
        workPackagePagination.set("project_id", projectId);
        workPackagePagination.set("jobcard_id", jobCard.getPkValue());
        DynamicObjectCollection workPackagePaginationEntry = workPackagePagination.getDynamicObjectCollection("entryentity");
        for (DynamicObject pageEntry : pageCollection) {
            DynamicObject entry = workPackagePaginationEntry.addNew();
            entry.set("seq", (Object)workPackagePaginationEntry.size());
            entry.set("pagination", pageEntry.get("pageseq"));
            entry.set("hours", pageEntry.get("pagesumhours"));
            entry.set("remarks", pageEntry.get("pageremark"));
        }
        return workPackagePagination;
    }

    private long getExecuteOrgId(Object manageId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", manageId)};
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_exec_workpack_manage", "executeorg", filters, null, 1);){
            long l = dataSet.isEmpty() ? 0L : dataSet.next().getLong(0);
            return l;
        }
    }

    private void buildWorkOrderRange(List<String> workOrderArray, DynamicObject workPackage, int serialNumberLength, StringBuilder rangeBuilder) {
        DynamicObject project = (DynamicObject)this.projectProp.getValueFast((Object)workPackage);
        String projectNumber = project == null ? "" : project.getString("number");
        int size = workOrderArray.size();
        if (size == 0) {
            return;
        }
        String workOrderNo = ObjectConverterWrapper.getString((Object)workOrderArray.get(0));
        String startSerialNumber = this.splitWorkOrderNo(workOrderNo, projectNumber, serialNumberLength);
        String endSerialNumber = size == 1 ? startSerialNumber : this.splitWorkOrderNo(ObjectConverterWrapper.getString((Object)workOrderArray.get(size - 1)), projectNumber, serialNumberLength);
        rangeBuilder.append(startSerialNumber).append('-').append(endSerialNumber);
    }

    private int getSerialNumberLength() {
        QFilter[] filters = new QFilter[]{new QFilter("mrotranstype", "=", (Object)1387752287631338496L), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingleFromCache((String)"pom_mrotranstype_coderule", (String)"lshlength", (QFilter[])filters);
        if (codeRule == null) {
            return 4;
        }
        int length = ObjectConverterWrapper.getInt((Object)codeRule.get("lshlength"));
        if (length == 0) {
            length = 4;
        }
        return length;
    }

    private String splitWorkOrderNo(String workOrderNo, String projectNumber, int serialNumberLength) {
        workOrderNo = StringUtils.substring((String)workOrderNo, (int)projectNumber.length(), (int)(workOrderNo.length() - 1));
        return StringUtils.substring((String)workOrderNo, (int)(workOrderNo.length() - serialNumberLength));
    }

    private boolean isNotErrorWorkOrder(DynamicObject dynamicObject) {
        Long jobId = ObjectConverterWrapper.getLong((Object)this.jobIdProp.getValueFast((Object)dynamicObject));
        return jobId != null && jobId != 0L;
    }

    private int getToWorkOrderSize(List<ExtendedDataEntity> validExtDataEntities) {
        int orderSize = 0;
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : collection) {
                String customerJobCardStatus = ObjectConverterWrapper.getString((Object)this.customerJobCardStatusProp.getValueFast((Object)dynamicObject));
                if (WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus) || this.isNotErrorWorkOrder(dynamicObject)) continue;
                ++orderSize;
            }
        }
        return orderSize;
    }

    private void dealResult(JSONArray executeWorkPackageDTOArray, DynamicObject workPackEntry) {
        JSONArray result = (JSONArray)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"BatchCreateMROOrder", (String)"batchCreateMroOrderFromExecPack", (Object[])new Object[]{executeWorkPackageDTOArray});
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        JSONObject workPackage = result.getJSONObject(0);
        JSONArray entry = workPackage.getJSONArray("entryentity");
        String errmsg = workPackage.getString("msg");
        if (StringUtils.isNotEmpty((CharSequence)errmsg)) {
            if (errmsg.length() > 499) {
                errmsg = errmsg.substring(0, 499);
            }
            this.errMsgProp.setValue((Object)workPackEntry, (Object)errmsg);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)entry)) {
            return;
        }
        JSONObject workOrder = entry.getJSONObject(0);
        long jobId = workOrder.getLongValue("orderid");
        this.jobIdProp.setValueFast((Object)workPackEntry, (Object)jobId);
        this.errMsgProp.setValue((Object)workPackEntry, (Object)"");
    }
}

