/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workpackage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.MMCCommonThreadPoolUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.pmc.pmpd.business.helper.OperationHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import org.apache.commons.collections4.CollectionUtils;

public class GeneratePanelJobCardOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(GeneratePanelJobCardOp.class);
    private Object manageId;

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)e.getValidExtDataEntities().get(0);
        this.manageId = extendedDataEntity.getBillPkId();
        List<Object> executeWorkPackageIds = this.listExecuteWorkPackageId();
        if (executeWorkPackageIds.isEmpty()) {
            e.setCancel(true);
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)LocaleStringHelper.buildEmptyQueryResultMsg((String)"pmpd_exec_workpack", (String)"entryentity"));
            this.operationResult.addErrorInfo(operateErrorInfo);
            return;
        }
        this.startFillPanelJobCard(extendedDataEntity, executeWorkPackageIds);
        if (!this.operationResult.isSuccess()) {
            e.setCancel(true);
            return;
        }
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        this.sort(dataEntity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        this.updateExecuteWorkPackageStatus(executeWorkPackageIds);
    }

    private void sort(DynamicObject dataEntity) {
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entry_panel_jobcard");
        collection.sort((o1, o2) -> {
            String nextHourType;
            DynamicObject currentWorkCard = o1.getDynamicObject("panel_jobcard");
            if (currentWorkCard == null) {
                return -1;
            }
            DynamicObject nextWorkCard = o2.getDynamicObject("panel_jobcard");
            if (nextWorkCard == null) {
                return 1;
            }
            String currentHourType = currentWorkCard.getString("cardhourtype");
            int result = currentHourType.compareTo(nextHourType = nextWorkCard.getString("cardhourtype"));
            if (result == 0) {
                DynamicObject currentZone = currentWorkCard.getDynamicObject("zone");
                DynamicObject nextZone = nextWorkCard.getDynamicObject("zone");
                if (currentZone != null && nextZone != null) {
                    return currentZone.getString("number").compareTo(nextZone.getString("number"));
                }
            }
            return result;
        });
        int seq = 1;
        for (DynamicObject dynamicObject : collection) {
            dynamicObject.set("seq", (Object)seq++);
        }
    }

    private Map<Long, Set<Long>> queryImportedPanelComparsionTableRecord() {
        String selectFields = "project, entryentity.subentryentity.paneldef";
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", this.manageId), new QFilter("source", "=", (Object)"import")};
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_panel_comparsion", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dataSet) {
                Long panelId;
                Long projectId = ObjectConverterWrapper.getLong((Object)row.get(0));
                if (projectId == 0L || (panelId = ObjectConverterWrapper.getLong((Object)row.get(1))) == 0L) continue;
                Set projectIds = result.computeIfAbsent(panelId, k -> new HashSet(16));
                projectIds.add(projectId);
            }
        }
        return result;
    }

    private void updateExecuteWorkPackageStatus(List<Object> executeWorkPackageIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmpd_exec_workpack");
        DynamicObject[] result = (DynamicObject[])executeWorkPackageIds.stream().map(executeWorkPackageId -> {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt, executeWorkPackageId);
            dynamicObject.set("billstatus", (Object)"D");
            return dynamicObject;
        }).toArray(DynamicObject[]::new);
        SaveServiceHelper.update((DynamicObject[])result);
    }

    private void startFillPanelJobCard(ExtendedDataEntity extendedDataEntity, List<Object> executeWorkPackageIds) {
        Map<Long, Set<Long>> jobCardId2ProjectIdMap = this.buildWorkCard2ProjectMap(executeWorkPackageIds);
        if (jobCardId2ProjectIdMap.isEmpty()) {
            MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6216\u201c%3$s\u201d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"GeneratePanelJobCardOp_5", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)dt), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dt, (String)"project"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dt, (String)"entryentity.jobcard")));
            this.operationResult.addErrorInfo(operateErrorInfo);
            LOG.info("[GeneratePanelJobCardOp] The project number or job card of the execution work package is empty. manageId: {}, executeWorkPackageIds: {}", this.manageId, executeWorkPackageIds);
            return;
        }
        Map<Long, Set<Long>> panelId2ProjectIdMap = this.buildPanel2ProjectMap(jobCardId2ProjectIdMap);
        if (panelId2ProjectIdMap.isEmpty()) {
            MainEntityType executeWorkPackDt = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7531\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u67e5\u8be2\u201c%3$s\u201d\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"GeneratePanelJobCardOp_6", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)executeWorkPackDt), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)executeWorkPackDt, (String)"entryentity.jobcard"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"mpdm_mrocardroute"), (String)"entryentity1")));
            this.operationResult.addErrorInfo(operateErrorInfo);
            LOG.info("[GeneratePanelJobCardOp] The panel data of the job card is empty. manageId: {}, jobCardIds: {}", this.manageId, panelId2ProjectIdMap.keySet());
            return;
        }
        HashMap<Long, Set<Long>> zoneId2PanelIdMap = new HashMap<Long, Set<Long>>(16);
        Map<Long, Map<String, BigDecimal>> panelInfoMap = this.buildPanelInfoMap(panelId2ProjectIdMap, zoneId2PanelIdMap);
        this.fillPanelJobCard(extendedDataEntity, panelId2ProjectIdMap, panelInfoMap, zoneId2PanelIdMap, executeWorkPackageIds);
    }

    private void genPanelWorkCardList(Map<String, PanelWorkCardBo> panelWorkCardBoMap) {
        ArrayList dataEntities = Lists.newArrayListWithExpectedSize((int)panelWorkCardBoMap.size());
        for (PanelWorkCardBo panelWorkCardBo : panelWorkCardBoMap.values()) {
            dataEntities.add(panelWorkCardBo.getPanelWorkCardList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dataEntities)) {
            DeleteServiceHelper.delete((String)"pmpd_panelworkcard_list", (QFilter[])new QFilter[]{new QFilter("executeworkpackmanage_id", "=", this.manageId)});
            SaveServiceHelper.save((DynamicObject[])dataEntities.toArray(new DynamicObject[0]));
        }
    }

    private void genPanelComparsionTable(List<Object> executeWorkPackageIds) {
        String selectFields = "project, entryentity.customer_jobcardno, entryentity.jobcard";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", executeWorkPackageIds)};
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_exec_workpack", selectFields, filters);){
            if (dataSet.isEmpty()) {
                return;
            }
            HashMap<Long, Map> project2JobCard = new HashMap<Long, Map>(16);
            HashSet<Long> allJobCard = new HashSet<Long>(16);
            for (Row row : dataSet) {
                Long jobCardId;
                Long projectId = row.getLong(0);
                if (projectId == 0L || (jobCardId = row.getLong(2)) == 0L) continue;
                Map customerJobCardNo2JobCardId = project2JobCard.computeIfAbsent(projectId, k -> new HashMap(16));
                Set jobCardIdSet = customerJobCardNo2JobCardId.computeIfAbsent(row.getString(1), k -> new HashSet(16));
                jobCardIdSet.add(jobCardId);
                allJobCard.add(jobCardId);
            }
            if (allJobCard.isEmpty()) {
                return;
            }
            HashSet selectFieldSet = Sets.newHashSet((Object[])new String[]{"entryentity1.panelnumber", "entryentity1.panelsumhours"});
            DynamicObjectType queryType = EntityMetadataCache.getSubDataEntityType((String)"mpdm_mrocardroute", (Collection)selectFieldSet);
            Map cache = BusinessDataServiceHelper.loadFromCache((Object[])allJobCard.toArray(), (DynamicObjectType)queryType);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmpd_panel_comparsion");
            ArrayList list = Lists.newArrayListWithExpectedSize((int)project2JobCard.size());
            for (Map.Entry entry : project2JobCard.entrySet()) {
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt);
                dynamicObject.set("manageid", this.manageId);
                dynamicObject.set("project_id", entry.getKey());
                dynamicObject.set("source", (Object)"executeworkpack");
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                Map customerJobCardNo2JobCardId = (Map)entry.getValue();
                int entrySeq = 1;
                for (Map.Entry customerJobCardNoEntry : customerJobCardNo2JobCardId.entrySet()) {
                    String customerJobCardNo = (String)customerJobCardNoEntry.getKey();
                    for (Long jobCardId : (Set)customerJobCardNoEntry.getValue()) {
                        DynamicObject entry2 = entryEntity.addNew();
                        entry2.set("seq", (Object)entrySeq++);
                        entry2.set("customer_jobcardno", (Object)customerJobCardNo);
                        entry2.set("jobcard_id", (Object)jobCardId);
                        DynamicObject jobCard = (DynamicObject)cache.get(jobCardId);
                        if (jobCard == null) continue;
                        int subEntrySeq = 1;
                        DynamicObjectCollection subEntryEntity = entry2.getDynamicObjectCollection("subentryentity");
                        DynamicObjectCollection panelCollection = jobCard.getDynamicObjectCollection("entryentity1");
                        for (DynamicObject panel : panelCollection) {
                            DynamicObject subEntry = subEntryEntity.addNew();
                            subEntry.set("seq", (Object)subEntrySeq++);
                            subEntry.set("paneldef_id", panel.get("panelnumber_id"));
                            subEntry.set("panelhours", panel.get("panelsumhours"));
                        }
                    }
                }
                list.add(dynamicObject);
            }
            if (!list.isEmpty()) {
                QFilter[] deleteFilters = new QFilter[]{new QFilter("manageid", "=", this.manageId), new QFilter("source", "!=", (Object)"import")};
                DeleteServiceHelper.delete((String)"pmpd_panel_comparsion", (QFilter[])deleteFilters);
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
        }
    }

    private void fillPanelJobCard(ExtendedDataEntity extendedDataEntity, Map<Long, Set<Long>> panelId2ProjectIdSet, Map<Long, Map<String, BigDecimal>> panelInfoMap, Map<Long, Set<Long>> zoneId2PanelIdSet, List<Object> executeWorkPackageIds) {
        Map<Object, DynamicObject> cache = this.queryWorkCardByZone(zoneId2PanelIdSet.keySet());
        if (cache.isEmpty()) {
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7531\u201c%1$s\u201d\u67e5\u8be2\u201c%2$s\u201d\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"GeneratePanelJobCardOp_7", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((String)"mpdm_paneldef", (String)"functionlocation"), LocaleStringHelper.getPropertyDisplayName((String)"pmpd_exec_workpack_manage", (String)"entry_panel_jobcard")));
            this.operationResult.addErrorInfo(operateErrorInfo);
            LOG.info("[GeneratePanelJobCardOp] Query job card data according to functional location is empty. manageId: {}, zoneIds: {}", this.manageId, zoneId2PanelIdSet.keySet());
            return;
        }
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entry_panel_jobcard");
        Set<String> uniqueKeySet = this.processExistedPanelJobCard(collection);
        StringBuilder sb = new StringBuilder();
        DynamicObjectType dt = cache.values().toArray(new DynamicObject[0])[0].getDynamicObjectType();
        ISimpleProperty idProp = dt.getPrimaryKey();
        DataEntityPropertyCollection properties = dt.getProperties();
        IDataEntityProperty zoneIdProp = (IDataEntityProperty)properties.get((Object)"zone_id");
        IDataEntityProperty panelWorkHourTypeProp = (IDataEntityProperty)properties.get((Object)"cardhourtype");
        HashMap<String, PanelWorkCardBo> panelWordCardCache = new HashMap<String, PanelWorkCardBo>(16);
        boolean modified = false;
        for (Map.Entry<Object, DynamicObject> entry : cache.entrySet()) {
            DynamicObject jobCard = entry.getValue();
            Object jobCardId = idProp.getValueFast((Object)jobCard);
            String panelWorkHourType = ObjectConverterWrapper.getString((Object)panelWorkHourTypeProp.getValueFast((Object)jobCard));
            Long zoneId = ObjectConverterWrapper.getLong((Object)zoneIdProp.getValueFast((Object)jobCard));
            Set panelIdSset = zoneId2PanelIdSet.getOrDefault(zoneId, Collections.emptySet());
            for (Long panelId : panelIdSset) {
                Map workHourType2Hours = panelInfoMap.getOrDefault(panelId, Collections.emptyMap());
                Set projectIdSet = panelId2ProjectIdSet.getOrDefault(panelId, Collections.emptySet());
                BigDecimal workHours = (BigDecimal)workHourType2Hours.get(panelWorkHourType);
                if (workHours == null) continue;
                for (Long projectId : projectIdSet) {
                    String uniqueKey = sb.append(projectId).append('_').append(jobCardId).toString();
                    sb.setLength(0);
                    if (uniqueKeySet.contains(uniqueKey)) continue;
                    modified = true;
                    PanelWorkCardBo panelWorkCardBo = (PanelWorkCardBo)panelWordCardCache.get(uniqueKey);
                    if (panelWorkCardBo == null) {
                        DynamicObject panelWorkCardEntry = collection.addNew();
                        panelWorkCardEntry.set("seq", (Object)collection.size());
                        panelWorkCardEntry.set("panel_project_id", (Object)projectId);
                        panelWorkCardEntry.set("panel_jobcard", (Object)jobCard);
                        panelWorkCardEntry.set("panel_jobcard_id", jobCardId);
                        panelWorkCardEntry.set("panel_workhours", (Object)workHours);
                        DynamicObject panelWorkCardList = this.newPanelWorkCardList(projectId);
                        DynamicObject panelWorkCardListEntry = this.initPanelWorkCardListEntry(jobCardId, zoneId, panelId, workHours, panelWorkCardList);
                        panelWorkCardBo = new PanelWorkCardBo();
                        panelWorkCardBo.setPanelWorkCardEntry(panelWorkCardEntry);
                        panelWorkCardBo.setPanelWorkCardList(panelWorkCardList);
                        panelWorkCardBo.setPanelWorkCardListEntry(panelWorkCardListEntry);
                        panelWordCardCache.put(uniqueKey, panelWorkCardBo);
                        continue;
                    }
                    BigDecimal summary = panelWorkCardBo.getPanelWorkCardEntry().getBigDecimal("panel_workhours").add(workHours);
                    panelWorkCardBo.getPanelWorkCardEntry().set("panel_workhours", (Object)summary);
                    this.addPanelInfo4PanelWorkCardList(panelWorkCardBo, panelId, workHours, summary);
                }
            }
        }
        if (modified) {
            long[] panelWorkCardIds = ID.genLongIds((int)panelWordCardCache.size());
            int count = 0;
            for (Map.Entry entry : panelWordCardCache.entrySet()) {
                long panelWorkCardId = panelWorkCardIds[count++];
                ((PanelWorkCardBo)entry.getValue()).getPanelWorkCardEntry().set("id", (Object)panelWorkCardId);
                ((PanelWorkCardBo)entry.getValue()).getPanelWorkCardListEntry().set("panelworkcardid", (Object)panelWorkCardId);
            }
            this.asyncSaveData(executeWorkPackageIds, panelWordCardCache);
        } else {
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)extendedDataEntity, (String)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001\u201c%1$s\u201d\u5df2\u5b58\u5728\uff1b2\u3001\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"GeneratePanelJobCardOp_8", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack_manage"), (String)"entry_panel_jobcard.panel_jobcard"), LocaleStringHelper.getPropertyDisplayName((String)"mpdm_mrocardroute", (String)"cardhourtype")));
            this.operationResult.addErrorInfo(operateErrorInfo);
            LOG.info("[GeneratePanelJobCardOp] Panel hours type mismatch. manageId: {}, jobCardIds: {}", this.manageId, cache.keySet());
        }
    }

    private void asyncSaveData(List<Object> executeWorkPackageIds, Map<String, PanelWorkCardBo> panelWordCardCache) {
        ThreadExecutorService service = MMCCommonThreadPoolUtil.getThreadExecutorService();
        service.execute(() -> {
            try {
                TXServiceHelper.executeWithTX(() -> {
                    this.genPanelComparsionTable(executeWorkPackageIds);
                    this.genPanelWorkCardList(panelWordCardCache);
                });
            }
            catch (Exception exception) {
                LOG.error("Failed to generate associated data of the panel worker card.", (Throwable)exception);
            }
        }, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
    }

    private void addPanelInfo4PanelWorkCardList(PanelWorkCardBo panelWorkCardBo, Long panelId, BigDecimal workHours, BigDecimal summary) {
        DynamicObject panelWorkCardListEntry = panelWorkCardBo.getPanelWorkCardListEntry();
        DynamicObjectCollection panelWorkCardListSubEntryCollection = panelWorkCardListEntry.getDynamicObjectCollection("subentryentity");
        DynamicObject panelWorkCardListSubEntry = panelWorkCardListSubEntryCollection.addNew();
        panelWorkCardListSubEntry.set("seq", (Object)panelWorkCardListSubEntryCollection.size());
        panelWorkCardListSubEntry.set("paneldef", (Object)panelId);
        panelWorkCardListSubEntry.set("panelhours", (Object)workHours);
        panelWorkCardListEntry.set("totalhours", (Object)summary);
    }

    private DynamicObject initPanelWorkCardListEntry(Object jobCardId, Long zoneId, Long panelId, BigDecimal workHours, DynamicObject panelWorkCardList) {
        DynamicObjectCollection panelWorkCardListEntryCollection = panelWorkCardList.getDynamicObjectCollection("entryentity");
        DynamicObject panelWorkCardListEntry = panelWorkCardListEntryCollection.addNew();
        DynamicObjectCollection panelWorkCardListSubEntryCollection = panelWorkCardListEntry.getDynamicObjectCollection("subentryentity");
        DynamicObject panelWorkCardListSubEntry = panelWorkCardListSubEntryCollection.addNew();
        panelWorkCardListSubEntry.set("seq", (Object)panelWorkCardListSubEntryCollection.size());
        panelWorkCardListSubEntry.set("paneldef", (Object)panelId);
        panelWorkCardListSubEntry.set("panelhours", (Object)workHours);
        panelWorkCardListEntry.set("seq", (Object)panelWorkCardListEntryCollection.size());
        panelWorkCardListEntry.set("jobcard_id", jobCardId);
        panelWorkCardListEntry.set("zone_id", (Object)zoneId);
        panelWorkCardListEntry.set("totalhours", (Object)workHours);
        return panelWorkCardListEntry;
    }

    private DynamicObject newPanelWorkCardList(Long projectId) {
        DynamicObject panelWorkCardList = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_panelworkcard_list"));
        panelWorkCardList.set("executeworkpackmanage_id", this.manageId);
        panelWorkCardList.set("project", (Object)projectId);
        return panelWorkCardList;
    }

    private Map<Object, DynamicObject> queryWorkCardByZone(Set<Long> zoneIdSet) {
        QFilter[] filters = new QFilter[]{new QFilter("zone", "in", zoneIdSet), new QFilter("processtype", "=", (Object)"C"), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        return BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (String)"zone, cardhourtype", (QFilter[])filters);
    }

    private Set<String> processExistedPanelJobCard(DynamicObjectCollection collection) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> uniqueKeySet = new HashSet<String>(16);
        DataEntityPropertyCollection properties = collection.getDynamicObjectType().getProperties();
        IDataEntityProperty jobIdProp = (IDataEntityProperty)properties.get((Object)"panel_jobid");
        IDataEntityProperty seqProp = (IDataEntityProperty)properties.get((Object)"seq");
        IDataEntityProperty projectIdProp = (IDataEntityProperty)properties.get((Object)"panel_project_id");
        IDataEntityProperty jobCardIdProp = (IDataEntityProperty)properties.get((Object)"panel_jobcard_id");
        Iterator iterator = collection.iterator();
        int seq = 1;
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            Long jobId = ObjectConverterWrapper.getLong((Object)jobIdProp.getValueFast((Object)entry));
            if (jobId == 0L) {
                iterator.remove();
                continue;
            }
            seqProp.setValueFast((Object)entry, (Object)seq++);
            sb.append(ObjectConverterWrapper.getString((Object)projectIdProp.getValueFast((Object)entry))).append('_').append(ObjectConverterWrapper.getString((Object)jobCardIdProp.getValueFast((Object)entry)));
            uniqueKeySet.add(sb.toString());
            sb.setLength(0);
        }
        return uniqueKeySet;
    }

    private Map<Long, Map<String, BigDecimal>> buildPanelInfoMap(Map<Long, Set<Long>> panelId2ProjectIdSet, Map<Long, Set<Long>> zoneId2PanelIdSet) {
        DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)"mpdm_paneldef", (Collection)Sets.newHashSet((Object[])new String[]{"functionlocation", "paneltimes.progroup", "paneltimes.workhours"}));
        Map panelCache = BusinessDataServiceHelper.loadFromCache((Object[])panelId2ProjectIdSet.keySet().toArray(), (DynamicObjectType)dt);
        if (panelCache.isEmpty()) {
            return Collections.emptyMap();
        }
        ISimpleProperty idProp = dt.getPrimaryKey();
        DataEntityPropertyCollection properties = dt.getProperties();
        IDataEntityProperty zoneIdProp = (IDataEntityProperty)properties.get((Object)"functionlocation_id");
        EntryProp entryProp = (EntryProp)properties.get((Object)"paneltimes");
        DataEntityPropertyCollection entryProperties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        BasedataProp processGroupProp = (BasedataProp)entryProperties.get((Object)"progroup");
        DynamicProperty panelWorkHourTypeProp = processGroupProp.getDynamicComplexPropertyType().getProperty("paneltimetype");
        IDataEntityProperty workHoursProp = (IDataEntityProperty)entryProperties.get((Object)"workhours");
        HashMap<Long, Map<String, BigDecimal>> panelInfoMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        for (Map.Entry entry : panelCache.entrySet()) {
            DynamicObject panelEntity = (DynamicObject)entry.getValue();
            Long panelId = ObjectConverterWrapper.getLong((Object)idProp.getValueFast((Object)panelEntity));
            Map type2SummarHours = panelInfoMap.computeIfAbsent(panelId, k -> new HashMap(16));
            DynamicObjectCollection collection = (DynamicObjectCollection)entryProp.getValueFast((Object)panelEntity);
            for (DynamicObject panelEntry : collection) {
                DynamicObject processGroup = (DynamicObject)processGroupProp.getValueFast((Object)panelEntry);
                if (processGroup == null) continue;
                String panelWorkHourType = ObjectConverterWrapper.getString((Object)panelWorkHourTypeProp.getValueFast((Object)processGroup));
                BigDecimal workHours = type2SummarHours.getOrDefault(panelWorkHourType, BigDecimal.ZERO);
                type2SummarHours.put(panelWorkHourType, workHours.add(ObjectConverterWrapper.getBigDecimal((Object)workHoursProp.getValueFast((Object)panelEntry))));
            }
            Set panelIdSet = zoneId2PanelIdSet.computeIfAbsent(ObjectConverterWrapper.getLong((Object)zoneIdProp.getValueFast((Object)panelEntity)), k -> new HashSet(16));
            panelIdSet.add(panelId);
        }
        return panelInfoMap;
    }

    private Map<Long, Set<Long>> buildPanel2ProjectMap(Map<Long, Set<Long>> jobCardId2ProjectIdSet) {
        DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)"mpdm_mrocardroute", (Collection)Sets.newHashSet((Object[])new String[]{"entryentity1.panelnumber"}));
        Map cache = BusinessDataServiceHelper.loadFromCache((Object[])jobCardId2ProjectIdSet.keySet().toArray(), (DynamicObjectType)dt);
        if (cache.isEmpty()) {
            return Collections.emptyMap();
        }
        ISimpleProperty idProp = dt.getPrimaryKey();
        EntryProp entryProp = (EntryProp)dt.getProperty("entryentity1");
        DataEntityPropertyCollection properties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        IDataEntityProperty panelIdProp = (IDataEntityProperty)properties.get((Object)"panelnumber_id");
        Map<Long, Set<Long>> panelId2ProjectIdMap = this.queryImportedPanelComparsionTableRecord();
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject jobCard = (DynamicObject)entry.getValue();
            Long jobCardId = ObjectConverterWrapper.getLong((Object)idProp.getValueFast((Object)jobCard));
            DynamicObjectCollection collection = (DynamicObjectCollection)entryProp.getValueFast((Object)jobCard);
            for (DynamicObject panelEntry : collection) {
                Long panelId = ObjectConverterWrapper.getLong((Object)panelIdProp.getValueFast((Object)panelEntry));
                if (panelId == 0L) continue;
                Set projectIdSet = panelId2ProjectIdMap.computeIfAbsent(panelId, k -> new HashSet(16));
                projectIdSet.addAll((Collection)jobCardId2ProjectIdSet.get(jobCardId));
            }
        }
        return panelId2ProjectIdMap;
    }

    private Map<Long, Set<Long>> buildWorkCard2ProjectMap(List<Object> executeWorkPackageIds) {
        String selectFields = "project, entryentity.jobcard";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", executeWorkPackageIds)};
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_exec_workpack", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dataSet) {
                Long jobCardId;
                Long projectId = ObjectConverterWrapper.getLong((Object)row.get(0));
                if (projectId == 0L || (jobCardId = ObjectConverterWrapper.getLong((Object)row.get(1))) == 0L) continue;
                Set projectIds = result.computeIfAbsent(jobCardId, k -> new HashSet(16));
                projectIds.add(projectId);
            }
        }
        return result;
    }

    private List<Object> listExecuteWorkPackageId() {
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", this.manageId)};
        return QueryServiceHelper.queryPrimaryKeys((String)"pmpd_exec_workpack", (QFilter[])filters, null, (int)-1);
    }

    private static class PanelWorkCardBo {
        private DynamicObject panelWorkCardEntry;
        private DynamicObject panelWorkCardList;
        private DynamicObject panelWorkCardListEntry;

        private PanelWorkCardBo() {
        }

        public DynamicObject getPanelWorkCardEntry() {
            return this.panelWorkCardEntry;
        }

        public void setPanelWorkCardEntry(DynamicObject panelWorkCardEntry) {
            this.panelWorkCardEntry = panelWorkCardEntry;
        }

        public DynamicObject getPanelWorkCardList() {
            return this.panelWorkCardList;
        }

        public void setPanelWorkCardList(DynamicObject panelWorkCardList) {
            this.panelWorkCardList = panelWorkCardList;
        }

        public DynamicObject getPanelWorkCardListEntry() {
            return this.panelWorkCardListEntry;
        }

        public void setPanelWorkCardListEntry(DynamicObject panelWorkCardListEntry) {
            this.panelWorkCardListEntry = panelWorkCardListEntry;
        }
    }
}

