/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workpackage;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.OperationHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.util.WorkPackVersionUtils;
import kd.pmc.pmpd.common.util.WorkPackageUtils;
import kd.pmc.pmpd.opplugin.workpackage.validator.WorkPackageMatchValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class WorkPackageMatchOp
extends AbstractOperationServicePlugIn {
    private IDataEntityProperty idProp;
    private IDataEntityProperty customerJobCardNoProp;
    private IDataEntityProperty supplementaryCodeProp;
    private IDataEntityProperty customerJobCardStatusProp;
    private IDataEntityProperty customerJobCardVersionProp;
    private boolean isContractWorkPackage;
    private final List<Object[]> paramsList = new ArrayList<Object[]>(10);
    private Map<Long, Long> selectedWorkCardMap;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("manageid");
        fieldKeys.add("customer_jobcardno");
        fieldKeys.add("customer_jobcardversion");
        fieldKeys.add("customer_jobcardstatus");
        fieldKeys.add("jobcard_id");
        fieldKeys.add("jobcard");
        fieldKeys.add("jobcardtitle");
        fieldKeys.add("workcategory_id");
        fieldKeys.add("programno");
        fieldKeys.add("auxiliarycode");
        fieldKeys.add("pagination");
        fieldKeys.add("ismultipage");
        fieldKeys.add("jobno");
        fieldKeys.add("fieldsource");
        if ("pmpd_contract_workpack".equals(this.billEntityType.getName())) {
            fieldKeys.add("programhours");
            fieldKeys.add("workcardhours");
        } else {
            fieldKeys.add("riskjobcard");
            fieldKeys.add("isfirstexecute");
            fieldKeys.add("datastatus");
            fieldKeys.add("outsource");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WorkPackageMatchValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ExtendedDataEntity firstDataEntity = (ExtendedDataEntity)e.getValidExtDataEntities().get(0);
        Tuple<Long, Long> executeWorkPackageManageInfo = this.getExecuteWorkPackageManageInfo(firstDataEntity);
        if (executeWorkPackageManageInfo == null) {
            e.setCancel(true);
            OperateErrorInfo operateErrorInfo = OperationHelper.buildSingleErrorInfo((ExtendedDataEntity)firstDataEntity, (String)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u201c%s\u201d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"WorkPackageMatchOp_3", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((String)"pmpd_exec_workpack_manage")));
            this.operationResult.addErrorInfo(operateErrorInfo);
            return;
        }
        this.isContractWorkPackage = "pmpd_contract_workpack".equals(this.billEntityType.getName());
        this.initProp(firstDataEntity);
        int length = e.getDataEntities().length;
        HashSet<String> customerJobCardNoSet = new HashSet<String>(16);
        ArrayList workPackIds = Lists.newArrayListWithExpectedSize((int)length);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            workPackIds.add(ObjectConverterWrapper.getLong((Object)this.idProp.getValueFast((Object)dataEntity)));
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : collection) {
                if (this.cantMatch(entry)) continue;
                customerJobCardNoSet.add(ObjectConverterWrapper.getString((Object)this.customerJobCardNoProp.getValueFast((Object)entry)));
            }
        }
        Map<String, Map<String, Map<String, List<DynamicObject>>>> customerJobCardMap4JobCardDatabase = this.buildCustomerJobCardMap4JobCardDatabase(customerJobCardNoSet, executeWorkPackageManageInfo);
        ArrayList differenceReportList = Lists.newArrayListWithExpectedSize((int)length);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            Map<String, Map<String, Map<String, List<DynamicObject>>>> customerJobCardMap4JobCardList = this.buildCustomerJobCardMap4JobCardList(dataEntity);
            if (customerJobCardMap4JobCardList.isEmpty()) continue;
            Long workPackageId = ObjectConverterWrapper.getLong((Object)this.idProp.getValueFast((Object)dataEntity));
            List<DynamicObject> differenceReports = this.matchWorkCard(workPackageId, customerJobCardMap4JobCardList, customerJobCardMap4JobCardDatabase);
            differenceReportList.addAll(differenceReports);
        }
        List<Object> removeIds = this.processRepeat(differenceReportList);
        TXServiceHelper.executeWithTX(() -> {
            if (!removeIds.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"pmpd_difference_report"), (Object[])removeIds.toArray());
            }
            this.archiveDifferenceReport(workPackIds);
            SaveServiceHelper.save((DynamicObject[])differenceReportList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
            WorkPackVersionUtils.update4WorkCard(this.paramsList);
        });
    }

    private boolean cantMatch(DynamicObject dynamicObject) {
        return WorkPackageUtils.checkCustomerWorkCardStatus((String)ObjectConverterWrapper.getString((Object)this.customerJobCardStatusProp.getValueFast((Object)dynamicObject)));
    }

    private void archiveDifferenceReport(List<Long> workPackIds) {
        DynamicObject[] datas;
        QFilter[] filters = new QFilter[]{new QFilter("workpackageid", "in", workPackIds), new QFilter("ishistory", "=", (Object)Character.valueOf('0'))};
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)"pmpd_difference_report", (String)"ishistory", (QFilter[])filters)) {
            data.set("ishistory", (Object)Character.valueOf('1'));
        }
        SaveServiceHelper.update((DynamicObject[])datas);
    }

    private void initProp(ExtendedDataEntity firstDataEntity) {
        EntityType subEntityType = (EntityType)firstDataEntity.getDataEntity().getDynamicObjectType();
        this.idProp = subEntityType.getPrimaryKey();
        this.customerJobCardNoProp = subEntityType.findProperty("customer_jobcardno");
        this.customerJobCardStatusProp = subEntityType.findProperty("customer_jobcardstatus");
        this.customerJobCardVersionProp = subEntityType.findProperty("customer_jobcardversion");
        this.supplementaryCodeProp = subEntityType.findProperty("auxiliarycode");
    }

    private Tuple<Long, Long> getExecuteWorkPackageManageInfo(ExtendedDataEntity workPackage) {
        String selectFields = "customer, equipment";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", workPackage.getValue("manageid"))};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_exec_workpack_manage", (String)selectFields, (QFilter[])filters, null, (int)1);){
            if (dataSet.isEmpty()) {
                Tuple<Long, Long> tuple = null;
                return tuple;
            }
            Row row = dataSet.next();
            Tuple tuple = new Tuple((Object)row.getLong(0), (Object)row.getLong(1));
            return tuple;
        }
    }

    private List<DynamicObject> matchWorkCard(Long workPackageId, Map<String, Map<String, Map<String, List<DynamicObject>>>> customerJobCardMap4JobCardList, Map<String, Map<String, Map<String, List<DynamicObject>>>> customerJobCardMap4JobCardDatabase) {
        ArrayList<DynamicObject> differenceReportList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, Map<String, Map<String, List<DynamicObject>>>> customerJobCardNoEntry : customerJobCardMap4JobCardList.entrySet()) {
            String customerJobCardNo = customerJobCardNoEntry.getKey();
            Map<String, Map<String, List<DynamicObject>>> supplementaryCodeMap4JobCardList = customerJobCardNoEntry.getValue();
            Map<String, Map<String, List<DynamicObject>>> supplementaryCodeMap4Database = customerJobCardMap4JobCardDatabase.get(customerJobCardNo);
            if (MapUtils.isEmpty(supplementaryCodeMap4Database)) {
                differenceReportList.addAll(this.genMissingWorkCardReports(workPackageId, customerJobCardNo, supplementaryCodeMap4JobCardList));
                continue;
            }
            for (Map.Entry<String, Map<String, List<DynamicObject>>> supplementaryCodeEntry : supplementaryCodeMap4JobCardList.entrySet()) {
                String[] keys;
                String customerJobCardVersion;
                String supplementaryCode = supplementaryCodeEntry.getKey();
                Map<String, List<DynamicObject>> versionMap4JobCardList = supplementaryCodeEntry.getValue();
                if (StringUtils.isNotBlank((CharSequence)supplementaryCode)) {
                    Map<String, List<DynamicObject>> versionMap4Database = supplementaryCodeMap4Database.get(supplementaryCode);
                    if (MapUtils.isEmpty(versionMap4Database)) {
                        differenceReportList.addAll(this.genMissingWorkCardReports(workPackageId, customerJobCardNo, supplementaryCode, versionMap4JobCardList));
                        continue;
                    }
                    for (Map.Entry<String, List<DynamicObject>> versionEntry : versionMap4JobCardList.entrySet()) {
                        customerJobCardVersion = versionEntry.getKey();
                        List<DynamicObject> workPackEntryCollection = versionEntry.getValue();
                        List<DynamicObject> workCards = versionMap4Database.get(customerJobCardVersion);
                        if (CollectionUtils.isEmpty(workCards)) {
                            differenceReportList.add(this.genInconsistentVersionReport(workPackageId, customerJobCardNo, supplementaryCode, customerJobCardVersion, versionMap4Database));
                            WorkPackageUtils.clearMatchResult(workPackEntryCollection, (boolean)this.isContractWorkPackage);
                            continue;
                        }
                        this.handleSingleOrMultiWorkCard(differenceReportList, workPackageId, customerJobCardNo, supplementaryCode, customerJobCardVersion, workCards, workPackEntryCollection);
                    }
                    continue;
                }
                if (supplementaryCodeMap4Database.size() == 1 && this.verifySupplementaryCode((keys = supplementaryCodeMap4Database.keySet().toArray(new String[0]))[0])) {
                    differenceReportList.addAll(this.genMissingWorkCardReports(workPackageId, customerJobCardNo, supplementaryCode, versionMap4JobCardList));
                    continue;
                }
                List versionMap4DatabaseList = null;
                for (Map.Entry<String, List<DynamicObject>> versionEntry : versionMap4JobCardList.entrySet()) {
                    customerJobCardVersion = versionEntry.getKey();
                    ArrayList<DynamicObject> allWorkCard = new ArrayList<DynamicObject>(10);
                    for (Map.Entry<String, Map<String, List<DynamicObject>>> supplementaryCodeEntry4Database : supplementaryCodeMap4Database.entrySet()) {
                        Map<String, List<DynamicObject>> versionMap4Database;
                        List<DynamicObject> workCards;
                        if (this.verifySupplementaryCode(supplementaryCodeEntry4Database.getKey()) || (workCards = (versionMap4Database = supplementaryCodeEntry4Database.getValue()).get(customerJobCardVersion)) == null) continue;
                        allWorkCard.addAll(workCards);
                    }
                    if (allWorkCard.isEmpty()) {
                        if (versionMap4DatabaseList == null) {
                            versionMap4DatabaseList = supplementaryCodeMap4Database.entrySet().stream().filter(entry -> !this.verifySupplementaryCode((String)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
                        }
                        differenceReportList.add(this.genInconsistentVersionReport(workPackageId, customerJobCardNo, supplementaryCode, customerJobCardVersion, versionMap4DatabaseList));
                        WorkPackageUtils.clearMatchResult(versionEntry.getValue(), (boolean)this.isContractWorkPackage);
                        continue;
                    }
                    this.handleSingleOrMultiWorkCard(differenceReportList, workPackageId, customerJobCardNo, supplementaryCode, customerJobCardVersion, allWorkCard, versionEntry.getValue());
                }
            }
        }
        return differenceReportList;
    }

    private boolean verifySupplementaryCode(String supplementaryCode) {
        return StringUtils.containsIgnoreCase((CharSequence)supplementaryCode, (CharSequence)"DUP");
    }

    private void handleSingleOrMultiWorkCard(List<DynamicObject> differenceReportList, Long workPackageId, String customerJobCardNo, String supplementaryCode, String customerJobCardVersion, List<DynamicObject> workCards, List<DynamicObject> workPackEntrys) {
        if (workCards.size() == 1) {
            DynamicObject workCard = workCards.get(0);
            List<String> differenceTypes = this.verifyWorkCard(workCard);
            if (differenceTypes.isEmpty()) {
                for (DynamicObject workPackEntry : workPackEntrys) {
                    this.paramsList.add(new Object[]{workCard.getPkValue(), workPackEntry.getPkValue()});
                    WorkPackageUtils.fillJobCardInfo((DynamicObject)workPackEntry, (DynamicObject)workCard, (boolean)this.isContractWorkPackage);
                }
                return;
            }
            differenceReportList.add(this.genOtherTypeReport(workPackageId, customerJobCardNo, supplementaryCode, customerJobCardVersion, workCard, differenceTypes));
        } else {
            Map<Long, Long> selectedWorkCardMap = this.getSelectedWorkCardMap(workPackageId);
            if (selectedWorkCardMap.isEmpty()) {
                differenceReportList.add(this.genMultipleWorkCardReport(workPackageId, customerJobCardNo, supplementaryCode, customerJobCardVersion, workCards, workPackEntrys));
            } else {
                Map workCardMap = workCards.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), Function.identity(), (k1, k2) -> k1));
                Iterator<DynamicObject> iterator = workPackEntrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject workCard;
                    DynamicObject workPackageEntry = iterator.next();
                    long workPackageEntryId = (Long)workPackageEntry.getPkValue();
                    Long workCardId = selectedWorkCardMap.get(workPackageEntryId);
                    if (workCardId == null || (workCard = (DynamicObject)workCardMap.get(workCardId)) == null) continue;
                    iterator.remove();
                    WorkPackageUtils.fillJobCardInfo((DynamicObject)workPackageEntry, (DynamicObject)workCard, (boolean)this.isContractWorkPackage);
                }
                if (!workPackEntrys.isEmpty()) {
                    differenceReportList.add(this.genMultipleWorkCardReport(workPackageId, customerJobCardNo, supplementaryCode, customerJobCardVersion, workCards, workPackEntrys));
                }
            }
        }
        WorkPackageUtils.clearMatchResult(workPackEntrys, (boolean)this.isContractWorkPackage);
    }

    private Map<Long, Long> getSelectedWorkCardMap(long workPackageId) {
        if (this.selectedWorkCardMap != null) {
            return this.selectedWorkCardMap;
        }
        String selectFields = "entryentity.jobcard, entry_workpack.workpackentryid";
        QFilter[] filters = new QFilter[]{new QFilter("workpackageid", "=", (Object)workPackageId), new QFilter("differencetype", "=", (Object)",multi,"), new QFilter("entryentity.isselect", "=", (Object)Character.valueOf('1'))};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_difference_report", (String)selectFields, (QFilter[])filters, (String)"id desc");){
            if (dataSet.isEmpty()) {
                this.selectedWorkCardMap = Collections.emptyMap();
            } else {
                this.selectedWorkCardMap = new HashMap<Long, Long>(16);
                for (Row row : dataSet) {
                    this.selectedWorkCardMap.putIfAbsent(ObjectConverterWrapper.getLong((Object)row.get(1)), ObjectConverterWrapper.getLong((Object)row.get(0)));
                }
            }
            Map<Long, Long> map = this.selectedWorkCardMap;
            return map;
        }
    }

    private DynamicObject genOtherTypeReport(Long workPackageId, String customerJobCardNo, String supplementaryCode, String customerJobCardVersion, DynamicObject workCard, List<String> differenceTypes) {
        DynamicObject report = this.genWorkPackDifferenceReport(workPackageId, customerJobCardNo, customerJobCardVersion, supplementaryCode);
        this.setMultiDropDownValues(report, String.join((CharSequence)",", differenceTypes));
        DynamicObjectCollection collection = report.getDynamicObjectCollection("entryentity");
        DynamicObject reportEntry = collection.addNew();
        reportEntry.set("seq", (Object)1);
        reportEntry.set("jobcard_id", workCard.getPkValue());
        reportEntry.set("differenceversion", workCard.get("cardversion"));
        return report;
    }

    private List<String> verifyWorkCard(DynamicObject workCard) {
        ArrayList<String> types = new ArrayList<String>(10);
        if (WorkPackageUtils.verifyWorkHourInfo((DynamicObject)workCard)) {
            types.add("nopagehours");
        }
        return types;
    }

    private DynamicObject genMultipleWorkCardReport(Long workPackageId, String customerJobCardNo, String supplementaryCode, String customerJobCardVersion, List<DynamicObject> workCards, List<DynamicObject> workPackEntrys) {
        DynamicObject report = this.genWorkPackDifferenceReport(workPackageId, customerJobCardNo, customerJobCardVersion, supplementaryCode);
        this.setMultiDropDownValues(report, "multi");
        DynamicObjectCollection collection = report.getDynamicObjectCollection("entryentity");
        for (DynamicObject workCard : workCards) {
            DynamicObject reportEntry = collection.addNew();
            reportEntry.set("seq", (Object)collection.size());
            reportEntry.set("jobcard_id", workCard.getPkValue());
            reportEntry.set("differenceversion", workCard.get("cardversion"));
        }
        DynamicObjectCollection workPackCollection = report.getDynamicObjectCollection("entry_workpack");
        for (DynamicObject workPackEntry : workPackEntrys) {
            DynamicObject reportEntry = workPackCollection.addNew();
            reportEntry.set("seq", (Object)workPackCollection.size());
            reportEntry.set("workpackentryid", workPackEntry.getPkValue());
        }
        return report;
    }

    private DynamicObject genInconsistentVersionReport(Long workPackageId, String customerJobCardNo, String supplementaryCode, String customerJobCardVersion, List<Map<String, List<DynamicObject>>> versionMap4DatabaseList) {
        DynamicObject report = this.genWorkPackDifferenceReport(workPackageId, customerJobCardNo, customerJobCardVersion, supplementaryCode);
        this.setMultiDropDownValues(report, "inconformity");
        DynamicObjectCollection collection = report.getDynamicObjectCollection("entryentity");
        for (Map<String, List<DynamicObject>> versionMap4Database : versionMap4DatabaseList) {
            for (Map.Entry<String, List<DynamicObject>> entry : versionMap4Database.entrySet()) {
                String differenceVersion = entry.getKey();
                for (DynamicObject workCard : entry.getValue()) {
                    DynamicObject reportEntry = collection.addNew();
                    reportEntry.set("seq", (Object)collection.size());
                    reportEntry.set("differenceversion", (Object)differenceVersion);
                    reportEntry.set("jobcard_id", workCard.getPkValue());
                }
            }
        }
        return report;
    }

    private DynamicObject genInconsistentVersionReport(Long workPackageId, String customerJobCardNo, String supplementaryCode, String customerJobCardVersion, Map<String, List<DynamicObject>> versionMap4Database) {
        DynamicObject report = this.genWorkPackDifferenceReport(workPackageId, customerJobCardNo, customerJobCardVersion, supplementaryCode);
        this.setMultiDropDownValues(report, "inconformity");
        DynamicObjectCollection collection = report.getDynamicObjectCollection("entryentity");
        for (Map.Entry<String, List<DynamicObject>> entry : versionMap4Database.entrySet()) {
            String differenceVersion = entry.getKey();
            for (DynamicObject workCard : entry.getValue()) {
                DynamicObject reportEntry = collection.addNew();
                reportEntry.set("seq", (Object)collection.size());
                reportEntry.set("differenceversion", (Object)differenceVersion);
                reportEntry.set("jobcard_id", workCard.getPkValue());
            }
        }
        return report;
    }

    private List<DynamicObject> genMissingWorkCardReports(Long workPackageId, String customerWorkCardNo, String supplementaryCode, Map<String, List<DynamicObject>> workPackVersionMap) {
        ArrayList<DynamicObject> missingWorkCardReports = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, List<DynamicObject>> entry : workPackVersionMap.entrySet()) {
            String customerWorkCardVersion = entry.getKey();
            DynamicObject report = this.genWorkPackDifferenceReport(workPackageId, customerWorkCardNo, customerWorkCardVersion, supplementaryCode);
            this.setMultiDropDownValues(report, "defect");
            missingWorkCardReports.add(report);
            WorkPackageUtils.clearMatchResult(entry.getValue(), (boolean)this.isContractWorkPackage);
        }
        return missingWorkCardReports;
    }

    private List<DynamicObject> genMissingWorkCardReports(Long workPackageId, String customerWorkCardNo, Map<String, Map<String, List<DynamicObject>>> supplementaryCodeMap4JobCardList) {
        ArrayList<DynamicObject> missingWorkCardReports = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, Map<String, List<DynamicObject>>> supplementaryCodeEntry : supplementaryCodeMap4JobCardList.entrySet()) {
            String supplementaryCode = supplementaryCodeEntry.getKey();
            for (Map.Entry<String, List<DynamicObject>> customerWorkCardVersionEntry : supplementaryCodeEntry.getValue().entrySet()) {
                String customerWorkCardVersion = customerWorkCardVersionEntry.getKey();
                DynamicObject report = this.genWorkPackDifferenceReport(workPackageId, customerWorkCardNo, customerWorkCardVersion, supplementaryCode);
                this.setMultiDropDownValues(report, "defect");
                missingWorkCardReports.add(report);
                WorkPackageUtils.clearMatchResult(customerWorkCardVersionEntry.getValue(), (boolean)this.isContractWorkPackage);
            }
        }
        return missingWorkCardReports;
    }

    private DynamicObject genWorkPackDifferenceReport(Long workPackageId, String customerJobCardNo, String customerJobCardVersion, String supplementaryCode) {
        DynamicObject report = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_difference_report"));
        report.set("workpackageid", (Object)workPackageId);
        report.set("customer_jobcardno", (Object)customerJobCardNo);
        report.set("customer_jobcardversion", (Object)customerJobCardVersion);
        report.set("supplementarycode", (Object)supplementaryCode);
        return report;
    }

    private void setMultiDropDownValues(DynamicObject report, String dropDownValue) {
        String multiValues = "," + dropDownValue + ",";
        report.set("differencetype", (Object)multiValues);
        report.set("typevalue", (Object)multiValues);
    }

    private Map<String, Map<String, Map<String, List<DynamicObject>>>> buildCustomerJobCardMap4JobCardDatabase(Set<String> customerJobCardNoSet, Tuple<Long, Long> executeWorkPackageManageInfo) {
        long modelMpdOneId = WorkPackageUtils.getMaintenanceModel((long)((Long)executeWorkPackageManageInfo.item2), (String)"modelmpdone");
        QFilter[] filters = new QFilter[]{new QFilter("cardnum", "in", customerJobCardNoSet), new QFilter("customer", "=", executeWorkPackageManageInfo.item1), new QFilter("materialtype", "=", (Object)modelMpdOneId), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        return WorkPackageUtils.getWorkCardByCustomWorkCard((QFilter[])filters);
    }

    private Map<String, Map<String, Map<String, List<DynamicObject>>>> buildCustomerJobCardMap4JobCardList(DynamicObject dataEntity) {
        HashMap<String, Map<String, Map<String, List<DynamicObject>>>> resultMap = new HashMap<String, Map<String, Map<String, List<DynamicObject>>>>(16);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : collection) {
            if (this.cantMatch(entry)) continue;
            Map supplementaryCodeMap = resultMap.computeIfAbsent(ObjectConverterWrapper.getString((Object)this.customerJobCardNoProp.getValueFast((Object)entry)), k -> new HashMap(16));
            Map versionMap = supplementaryCodeMap.computeIfAbsent(ObjectConverterWrapper.getString((Object)this.supplementaryCodeProp.getValueFast((Object)entry)), k -> new HashMap(16));
            List workPackEntrys = versionMap.computeIfAbsent(ObjectConverterWrapper.getString((Object)this.customerJobCardVersionProp.getValueFast((Object)entry)), k -> new ArrayList(10));
            workPackEntrys.add(entry);
        }
        return resultMap;
    }

    private List<Object> processRepeat(List<DynamicObject> reports) {
        if (reports.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> uniqueKeys = this.getUniqueKeys();
        Tuple<List<Set<Object>>, List<List<Object>>> tuple = this.buildFieldValues(reports, uniqueKeys);
        List filterFieldValues = (List)tuple.item1;
        List fieldValues = (List)tuple.item2;
        QFilter[] filters = this.buildFilters(uniqueKeys, filterFieldValues);
        String selectFields = "id, " + String.join((CharSequence)",", uniqueKeys);
        ArrayList<Object> removeIds = new ArrayList<Object>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_difference_report", (String)selectFields, (QFilter[])filters, null);){
            block9: for (Row row : dataSet) {
                Iterator iterator = fieldValues.iterator();
                while (iterator.hasNext()) {
                    List fieldValue = (List)iterator.next();
                    boolean isMatch = true;
                    for (int i = 0; i < uniqueKeys.size(); ++i) {
                        String propName = uniqueKeys.get(i);
                        Object value = row.get(propName);
                        if (this.equalsValue(fieldValue.get(i), value)) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    removeIds.add(row.get(0));
                    iterator.remove();
                    continue block9;
                }
            }
        }
        return removeIds;
    }

    private QFilter[] buildFilters(List<String> uniqueKeys, List<Set<Object>> fieldValues) {
        int size = uniqueKeys.size();
        QFilter[] filters = new QFilter[size];
        for (int i = 0; i < size; ++i) {
            filters[i] = new QFilter(uniqueKeys.get(i), "in", fieldValues.get(i));
        }
        return filters;
    }

    private Tuple<List<Set<Object>>, List<List<Object>>> buildFieldValues(List<DynamicObject> reports, List<String> uniqueyKeys) {
        int size = uniqueyKeys.size();
        List<IDataEntityProperty> uniqueyProps = this.convert(uniqueyKeys);
        ArrayList filterFieldValues = Lists.newArrayListWithExpectedSize((int)size);
        ArrayList fieldValues = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            filterFieldValues.add(new HashSet(16));
        }
        for (DynamicObject report : reports) {
            ArrayList<Object> values = new ArrayList<Object>(10);
            for (int i = 0; i < size; ++i) {
                Object value = uniqueyProps.get(i).getValueFast((Object)report);
                ((Set)filterFieldValues.get(i)).add(value);
                values.add(value);
            }
            fieldValues.add(values);
        }
        return new Tuple((Object)filterFieldValues, (Object)fieldValues);
    }

    private List<IDataEntityProperty> convert(List<String> uniqueyKeys) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_difference_report");
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        return uniqueyKeys.stream().map(arg_0 -> ((DataEntityPropertyCollection)properties).get(arg_0)).collect(Collectors.toList());
    }

    private List<String> getUniqueKeys() {
        return Lists.newArrayList((Object[])new String[]{"workpackageid", "customer_jobcardno", "supplementarycode", "customer_jobcardversion", "differencetype"});
    }

    private boolean equalsValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Integer && v2 instanceof Long) {
            return ((Integer)v1).longValue() == ((Long)v2).longValue();
        }
        if (v1 instanceof Long && v2 instanceof Integer) {
            return ((Long)v1).longValue() == ((Integer)v2).longValue();
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof String && v2 instanceof String) {
            return ((String)v1).trim().equals(((String)v2).trim());
        }
        return v1.equals(v2);
    }
}

