/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.workpackage.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.util.WorkPackImportUtils;
import kd.pmc.pmpd.common.util.WorkPackageUtils;

public class ExecuteWorkPackSaveValidator
extends AbstractValidator {
    public void validate() {
        HashMap<String, Long> cancelOrRevisionMap = new HashMap<String, Long>(16);
        HashMap<String, Set<String>> customerJobCardNoMap = new HashMap<String, Set<String>>(16);
        HashMap<String, Integer> maxSupplementNoMap = new HashMap<String, Integer>(16);
        HashMap<String, Long> name2Project = new HashMap<String, Long>(16);
        this.queryWorkPackInfo(customerJobCardNoMap, maxSupplementNoMap, cancelOrRevisionMap, name2Project);
        HashMap<String, Set<String>> customerJobCardNoValidator = new HashMap<String, Set<String>>(16);
        StringBuilder uniqueKeyBuilder = new StringBuilder();
        HashMap<Long, String> workPackEntryMap = new HashMap<Long, String>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            HashSet<String> uniqueKeys = new HashSet<String>(16);
            int entryEntitySize = entryEntity.size();
            for (int i = 0; i < entryEntitySize; ++i) {
                DynamicObject entry2 = (DynamicObject)entryEntity.get(i);
                int currentIndex = i + 1;
                String customerJobCardNo = entry2.getString("customer_jobcardno");
                String supplementaryCode = entry2.getString("auxiliarycode");
                String customerJobCardStatus = entry2.getString("customer_jobcardstatus");
                if (StringUtils.isBlank((CharSequence)customerJobCardStatus)) {
                    this.verifyCustomerJobCardNo(extendedDataEntity, currentIndex, customerJobCardNoMap, customerJobCardNo, supplementaryCode);
                } else if (WorkPackageUtils.checkCustomerWorkCardStatus((String)customerJobCardStatus)) {
                    String uniqueKey = this.buildUniqueKey(uniqueKeyBuilder, customerJobCardNo, supplementaryCode);
                    Long workPackEntryId = (Long)cancelOrRevisionMap.get(uniqueKey);
                    if (this.verifyCustomerJobCardStatus(extendedDataEntity, currentIndex, customerJobCardNo, supplementaryCode, customerJobCardStatus, workPackEntryId)) {
                        workPackEntryMap.put(workPackEntryId, uniqueKey);
                    } else {
                        uniqueKeys.add(uniqueKey);
                    }
                }
                this.verifySupplementaryCode(extendedDataEntity, currentIndex, customerJobCardNoValidator, customerJobCardNo, supplementaryCode);
            }
            if (uniqueKeys.isEmpty()) continue;
            workPackEntryMap.entrySet().removeIf(entry -> uniqueKeys.contains(entry.getValue()));
        }
        this.getOption().setVariableValue("workPackEntry", SerializationUtils.toJsonString(workPackEntryMap));
        if (WorkPackImportUtils.isFromImport((OperateOption)this.getOption())) {
            this.getOption().setVariableValue("supplementNo", SerializationUtils.toJsonString(maxSupplementNoMap));
            this.getOption().setVariableValue("name2Project", SerializationUtils.toJsonString(name2Project));
        }
    }

    private void verifySupplementaryCode(ExtendedDataEntity extendedDataEntity, int index, Map<String, Set<String>> customerJobCardNoValidator, String customerJobCardNo, String supplementaryCode) {
        Set supplementaryCodes;
        if (StringUtils.isNotBlank((CharSequence)supplementaryCode) && !(supplementaryCodes = customerJobCardNoValidator.computeIfAbsent(customerJobCardNo, k -> new HashSet(16))).add(supplementaryCode)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$d\u884c\uff0c\u5f53\u524d\u201c%3$s\u201d\u5b58\u5728\u91cd\u590d\u7684\u201c%4$s=%5$s\u3001%6$s=%7$s\u201d\u6570\u636e\u3002", (String)"ExecuteWorkPackSaveValidator_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"entryentity"), index, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"entryentity"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer_jobcardno"), customerJobCardNo, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"auxiliarycode"), supplementaryCode);
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private boolean verifyCustomerJobCardStatus(ExtendedDataEntity extendedDataEntity, int index, String customerJobCardNo, String supplementaryCode, String customerJobCardStatus, Long workPackEntryId) {
        if (workPackEntryId == null) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
            IDataEntityProperty statusProp = dataEntityType.findProperty("customer_jobcardstatus");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$d\u884c\uff0c\u5f53\u201c%3$s=%4$s\u201d\u65f6\uff0c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u201c%5$s=%6$s\u3001%7$s%8$s\u201d\u7684\u6570\u636e\u3002", (String)"ExecuteWorkPackSaveValidator_1", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"entryentity"), index, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer_jobcardstatus"), statusProp instanceof ComboProp ? ((ComboProp)statusProp).getItemByName(customerJobCardStatus) : customerJobCardStatus, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer_jobcardno"), customerJobCardNo, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"auxiliarycode"), StringUtils.isBlank((CharSequence)supplementaryCode) ? ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"ExecuteWorkPackSaveValidator_2", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]) : String.format("=%s", supplementaryCode));
            this.addErrorMessage(extendedDataEntity, errorMsg);
            return false;
        }
        return true;
    }

    private void verifyCustomerJobCardNo(ExtendedDataEntity extendedDataEntity, int index, Map<String, Set<String>> customerJobCardNoMap, String customerJobCardNo, String supplementaryCode) {
        if (StringUtils.isBlank((CharSequence)supplementaryCode)) {
            if (customerJobCardNoMap.containsKey(customerJobCardNo)) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
                String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$d\u884c\uff0c\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u201c%3$s\u4e3a\u7a7a\u3001%4$s=%5$s\u201d\u6570\u636e\u3002", (String)"ExecuteWorkPackSaveValidator_3", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"entryentity"), index, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer_jobcardstatus"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer_jobcardno"), customerJobCardNo);
                this.addErrorMessage(extendedDataEntity, errorMsg);
            } else {
                Set supplementaryCodes = customerJobCardNoMap.computeIfAbsent(customerJobCardNo, k -> new HashSet(16));
                supplementaryCodes.add(supplementaryCode);
            }
        } else {
            Set<String> supplementaryCodes = customerJobCardNoMap.get(customerJobCardNo);
            if (supplementaryCodes != null && !supplementaryCodes.add(supplementaryCode)) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
                String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$d\u884c\uff0c\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u201c%3$s\u4e3a\u7a7a\u3001%4$s=%5$s\u3001%6$s=%7$s\u201d\u6570\u636e\u3002", (String)"ExecuteWorkPackSaveValidator_4", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"entryentity"), index, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer_jobcardstatus"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer_jobcardno"), customerJobCardNo, LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"auxiliarycode"), supplementaryCode);
                this.addErrorMessage(extendedDataEntity, errorMsg);
            }
        }
    }

    private void queryWorkPackInfo(Map<String, Set<String>> customerJobCardNoMap, Map<String, Integer> maxSupplementNoMap, Map<String, Long> uniqueValueMap, Map<String, Long> name2Project) {
        long manageId = this.getDataEntities()[0].getDataEntity().getLong("manageid");
        HashSet<Long> ids = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            ids.add(ObjectConverterWrapper.getLong((Object)dataEntity.getBillPkId()));
        }
        StringBuilder uniqueKeyBuilder = new StringBuilder();
        String selectFields = "id, name, supplement, entryentity.id, entryentity.customer_jobcardno, entryentity.auxiliarycode, entryentity.customer_jobcardstatus, project";
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", (Object)manageId)};
        String orderBy = "entryentity.id desc";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_exec_workpack", (String)selectFields, (QFilter[])filters, (String)orderBy);){
            for (Row row : dataSet) {
                Long projectId;
                if (ids.contains(ObjectConverterWrapper.getLong((Object)row.get(0)))) continue;
                String name = ObjectConverterWrapper.getString((Object)row.get(1));
                Integer supplementNo = ObjectConverterWrapper.getInt((Object)row.get(2));
                if (supplementNo == 0 && (projectId = ObjectConverterWrapper.getLong((Object)row.get(7))) != 0L) {
                    name2Project.put(name, projectId);
                }
                maxSupplementNoMap.putIfAbsent(name, supplementNo);
                String customerJobCardNo = ObjectConverterWrapper.getString((Object)row.get(4));
                String supplementaryCode = ObjectConverterWrapper.getString((Object)row.get(5));
                Set supplementaryCodes = customerJobCardNoMap.computeIfAbsent(customerJobCardNo, k -> new HashSet(16));
                supplementaryCodes.add(supplementaryCode);
                if (WorkPackageUtils.checkCustomerWorkCardStatus((String)ObjectConverterWrapper.getString((Object)row.get(6)))) continue;
                String uniqueKey = this.buildUniqueKey(uniqueKeyBuilder, customerJobCardNo, supplementaryCode);
                uniqueValueMap.putIfAbsent(uniqueKey, ObjectConverterWrapper.getLong((Object)row.get(3)));
            }
        }
    }

    private String buildUniqueKey(StringBuilder uniqueKeyBuilder, String customerJobCardNo, String supplementaryCode) {
        uniqueKeyBuilder.setLength(0);
        uniqueKeyBuilder.append(customerJobCardNo).append('-').append(supplementaryCode.trim());
        return uniqueKeyBuilder.toString();
    }
}

