/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public class ProjectHumanResourcePlanningUtil {
    public static boolean isAuthority(String userId, DynamicObject creator) {
        return userId.equals(creator.getString("id"));
    }

    public static boolean isAuthority(String userId, DynamicObjectCollection administrators) {
        for (DynamicObject administrator : administrators) {
            if (!userId.equals(administrator.getString("fbasedataid.id"))) continue;
            return true;
        }
        return false;
    }

    public static Set<Integer> getIsRoleAdministrators(DynamicObjectCollection roleEntityColl, String userId) {
        HashSet<Integer> sizes = new HashSet<Integer>(10);
        for (int i = 0; i < roleEntityColl.size(); ++i) {
            DynamicObjectCollection roleAdministrators = (DynamicObjectCollection)((DynamicObject)roleEntityColl.get(i)).get("roleadministrators");
            for (DynamicObject roleAdministrator : roleAdministrators) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)userId, (CharSequence)roleAdministrator.getString("fbasedataid.id"))) continue;
                sizes.add(i);
            }
        }
        return sizes;
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            if (value == null || value.size() <= 0) continue;
            result.add(value);
        }
        return result;
    }

    public static Map<Boolean, String> checkSubentryEntity(DynamicObjectCollection roleEntityColl) {
        if (!roleEntityColl.isEmpty()) {
            HashMap<Boolean, String> map = new HashMap<Boolean, String>(1);
            for (DynamicObject roleObj : roleEntityColl) {
                DynamicObjectCollection subRowObjs = roleObj.getDynamicObjectCollection("subentryentity");
                int requirementNumber = roleObj.getInt("requirementnumber");
                if (requirementNumber >= subRowObjs.size()) continue;
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u89d2\u8272\u4fe1\u606f\u5206\u5f55\uff0c\u89d2\u8272\u3010%s\u3011\u9700\u6c42\u4eba\u6570\u5c0f\u4e8e\u5206\u914d\u4eba\u6570\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58", (String)"ProjectHumanResourcePlanningUtil_0", (String)"mmc-pmpd-common", (Object[])new Object[0]), roleObj.getString("role.name")));
                map.put(Boolean.FALSE, errorMsg.toString());
                return map;
            }
        }
        return null;
    }
}

