/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.bigtask;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.pmc.pmpd.common.bigtask.BigTaskHelper;

public abstract class AbstractBigTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo.isTaskEnd()) {
            String status = taskInfo.getStatus();
            if ("COMPLETED".equals(status)) {
                String returnData = taskInfo.getData();
                Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
                boolean success = (Boolean)returnMap.get("success");
                Object data = returnMap.get("data");
                if (success) {
                    this.showSuccessMessage(data);
                } else {
                    this.getMainView().showErrorNotification(String.valueOf(data));
                }
            } else if (TaskStatusConstant.isFailure((String)status)) {
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    this.getMainView().showErrMessage(taskInfo.getFailureReason(), BigTaskHelper.getErrorMsg());
                } else {
                    this.getMainView().showErrorNotification(BigTaskHelper.getErrorTips());
                }
            } else if ("TIMEOUT".equals(status)) {
                this.getMainView().showTipNotification(BigTaskHelper.getTimeOutTips());
            } else {
                this.getMainView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u5df2\u88ab\u8df3\u8fc7\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractBigTaskClick_0", (String)"mmc-pmpd-common", (Object[])new Object[0]));
            }
        } else {
            IFormView parentView = this.getParentView();
            if (parentView == null) {
                this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u4efb\u52a1\u7684\u9875\u9762\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u518d\u6253\u5f00\u8fdb\u5ea6\u754c\u9762\u3002", (String)"AbstractBigTaskClick_1", (String)"mmc-pmpd-common", (Object[])new Object[0]));
            } else {
                this.showProgressForm(parentView);
            }
        }
    }

    protected abstract void showSuccessMessage(Object var1);

    private void showProgressForm(IFormView view) {
        if (this.isExistProgressForm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        JobInfo jobInfo = jobFormInfo.getJobInfo();
        String caption = jobInfo.getName();
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        showParameter.getCustomParams().put("ServiceAppId", jobInfo.getAppId());
        String jobFormInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobFormInfoStr);
        showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
        this.getMainView().sendFormAction(view);
        this.setProgressPageId(showParameter.getPageId());
    }
}

