/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.bigtask;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class BigTaskHelper {
    private static final Log LOG = LogFactory.getLog(BigTaskHelper.class);

    private BigTaskHelper() {
    }

    public static void showBigTaskResult(IFormView formView, Map<String, Object> taskResult, Consumer<Object> successConsumer) {
        String taskInfoStr = (String)taskResult.get("taskinfo");
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        String returnData = taskInfo.getData();
        Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
        String taskName = (String)returnMap.get("taskName");
        LOG.info("{}Execution completed. Start executing callback events, taskInfo: {}", (Object)taskName, (Object)taskInfoStr);
        String status = taskInfo.getStatus();
        if ("COMPLETED".equals(status)) {
            boolean success = (Boolean)returnMap.get("success");
            Object data = returnMap.get("data");
            if (success) {
                successConsumer.accept(data);
            } else {
                int errorLevelValue = (Integer)returnMap.get("errorLevel");
                ErrorLevel errorLevel = ErrorLevel.valueOf((int)errorLevelValue);
                if (errorLevel == ErrorLevel.Warning) {
                    formView.showTipNotification(String.valueOf(data));
                } else {
                    formView.showErrorNotification(String.valueOf(data));
                }
            }
        } else if (taskInfo.isFailure()) {
            if (SystemParamServiceHelper.isShowStackTrace()) {
                formView.showErrMessage(taskInfo.getFailureReason(), BigTaskHelper.getErrorMsg());
            } else {
                formView.showErrorNotification(BigTaskHelper.getErrorTips());
            }
            LOG.error("{}Execution failed. The reason is: {}", (Object)taskInfo.getFailureReason());
        } else if ("TIMEOUT".equals(status)) {
            formView.showTipNotification(BigTaskHelper.getTimeOutTips());
        } else {
            LOG.warn("{}Execution status exception. status: {}", (Object)taskName, (Object)status);
        }
    }

    public static String getTimeOutTips() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8d85\u65f6\u3002", (String)"BigTaskHelper_0", (String)"mmc-pmpd-common", (Object[])new Object[0]);
    }

    public static String getErrorMsg() {
        return ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u529f\u80fd\u51fa\u9519\u4ee5\u81f4\u65e0\u6cd5\u4f7f\u7528\u3002", (String)"BigTaskHelper_1", (String)"mmc-pmpd-common", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BigTaskHelper_2", (String)"mmc-pmpd-common", (Object[])new Object[0]);
    }

    public static Map<String, Object> warn(String taskName, String message) {
        return BigTaskHelper.createRetrunData(taskName, false, message, ErrorLevel.Warning);
    }

    public static Map<String, Object> fail(String taskName, String message) {
        return BigTaskHelper.createRetrunData(taskName, false, message, ErrorLevel.Error);
    }

    public static Map<String, Object> success(String taskName, Object data) {
        return BigTaskHelper.createRetrunData(taskName, true, data, null);
    }

    public static Map<String, Object> ex(String taskName, Throwable throwable) {
        String message = SystemParamServiceHelper.isShowStackTrace() ? ExceptionUtils.getStackTrace((Throwable)throwable) : BigTaskHelper.getErrorTips();
        return BigTaskHelper.fail(taskName, message);
    }

    public static String getErrorTips() {
        return ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u529f\u80fd\u51fa\u9519\u4ee5\u81f4\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BigTaskHelper_3", (String)"mmc-pmpd-common", (Object[])new Object[0]);
    }

    private static Map<String, Object> createRetrunData(String taskName, boolean success, Object data, ErrorLevel errorLevel) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)3);
        returnMap.put("taskName", taskName);
        returnMap.put("success", success);
        returnMap.put("data", data);
        if (errorLevel != null) {
            returnMap.put("errorLevel", errorLevel.getValue());
        }
        return returnMap;
    }
}

