/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.bigtask;

import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;

public class JobInfoBuilder {
    private String name;
    private String appId;
    private String taskClassName;
    private Map<String, Object> params;

    private JobInfoBuilder() {
    }

    public static JobInfoBuilder builder() {
        return new JobInfoBuilder();
    }

    public JobInfoBuilder name(String name) {
        this.name = name;
        return this;
    }

    public JobInfoBuilder appId(String appId) {
        this.appId = appId;
        return this;
    }

    public JobInfoBuilder taskClassName(String taskClassName) {
        this.taskClassName = taskClassName;
        return this;
    }

    public JobInfoBuilder params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public JobInfo build() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(this.name);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(this.taskClassName);
        jobInfo.setParams(this.params);
        jobInfo.setRunByLang(Lang.get());
        return jobInfo;
    }
}

