/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.function.Consumer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateTimeEdit;

public final class DateTimeCheckHelper {
    private DateTimeCheckHelper() {
    }

    public static void startDateTimeChanged(IFormView formView, Date startDateTime, String endDateTimeKey, String tip, Consumer<Date> consumer) {
        if (startDateTime == null) {
            if (DateTimeCheckHelper.isHideEndTimeFieldTip(formView, endDateTimeKey)) {
                DateTimeCheckHelper.showEndDateTimeFieldTip(formView, endDateTimeKey, "", false);
            }
            return;
        }
        IDataModel model = formView.getModel();
        Date endDateTime = (Date)model.getValue(endDateTimeKey);
        if (endDateTime != null) {
            if (startDateTime.compareTo(endDateTime) >= 0) {
                model.setValue(endDateTimeKey, null);
                DateTimeCheckHelper.showEndDateTimeFieldTip(formView, endDateTimeKey, tip, true);
            } else if (consumer != null) {
                consumer.accept(endDateTime);
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDateTime);
        calendar.add(13, 1);
        DateTimeEdit dateTimeEdit = (DateTimeEdit)formView.getControl(endDateTimeKey);
        dateTimeEdit.setMinDate(calendar.getTime());
    }

    public static void endDateTimeChanged(IFormView formView, Date endDateTime, String startDateTimeKey, String endDateTimeKey, Consumer<Date> consumer) {
        if (endDateTime != null) {
            Date startDateTime;
            if (DateTimeCheckHelper.isHideEndTimeFieldTip(formView, endDateTimeKey)) {
                DateTimeCheckHelper.showEndDateTimeFieldTip(formView, endDateTimeKey, "", false);
            }
            if (consumer != null && (startDateTime = (Date)formView.getModel().getValue(startDateTimeKey)) != null) {
                consumer.accept(startDateTime);
            }
        }
    }

    private static boolean isHideEndTimeFieldTip(IFormView formView, String cacheKey) {
        String cacheData = formView.getPageCache().get(cacheKey);
        return StringUtils.isNotEmpty((CharSequence)cacheData) && Boolean.parseBoolean(cacheData);
    }

    private static void showEndDateTimeFieldTip(IFormView formView, String endDateTimeKey, String tips, boolean success) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, endDateTimeKey, tips);
        fieldTip.setSuccess(!success);
        formView.showFieldTip(fieldTip);
        formView.getPageCache().put(endDateTimeKey, Boolean.toString(success));
    }
}

