/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.common.helper.FilterConditionPaser;

public class HoldElement
implements Serializable {
    private static final long serialVersionUID = -5794564253941715341L;
    private long pk;
    private String name;
    private String holdEntityNumber;
    private String filterCondition;
    private int holdeScore;
    private QFilter holdFilter;
    private String holdFild;
    private String holdScoreName;

    public HoldElement() {
    }

    public HoldElement(DynamicObject holdElement) {
        this.pk = holdElement.getPkValue() == null ? 0L : Long.parseLong(holdElement.getPkValue().toString());
        this.name = holdElement.getString("holdname");
        DynamicObject entityObj = holdElement.getDynamicObject("holdobject");
        this.holdEntityNumber = entityObj.get("number") == null ? "" : entityObj.get("number").toString();
        this.filterCondition = holdElement.getString("holdfilterjson_tag");
        this.holdeScore = holdElement.getInt("holdscore");
        this.parseInit();
    }

    private void parseInit() {
        CRCondition holdFormulaObj = (CRCondition)SerializationUtils.fromJsonString((String)this.filterCondition, CRCondition.class);
        FilterCondition holdFilterCondition = holdFormulaObj.getFilterCondition();
        this.holdFilter = FilterConditionPaser.parseFilterConditionToQFilter(this.holdEntityNumber, holdFilterCondition);
        this.holdFild = this.holdFilter.getProperty();
    }

    public long getPk() {
        return this.pk;
    }

    public String getName() {
        return this.name;
    }

    public void setPk(long pk) {
        this.pk = pk;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHoldEntityNumber(String holdEntityNumber) {
        this.holdEntityNumber = holdEntityNumber;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public void setHoldeScore(int holdeScore) {
        this.holdeScore = holdeScore;
    }

    public void setHoldFilter(QFilter holdFilter) {
        this.holdFilter = holdFilter;
    }

    public void setHoldFild(String holdFild) {
        this.holdFild = holdFild;
    }

    public String getHoldEntityNumber() {
        return this.holdEntityNumber;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public int getHoldeScore() {
        return this.holdeScore;
    }

    public QFilter getHoldFilter() {
        return this.holdFilter;
    }

    public String getHoldFild() {
        return this.holdFild;
    }

    public String getHoldScoreName() {
        return this.holdScoreName;
    }

    public void setHoldScoreName(String holdScoreName) {
        this.holdScoreName = holdScoreName;
    }
}

