/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;

public class LocaleStringHelper {
    private static final String SEPARATOR = ".";

    public static String getEntityDisplayName(String entityNumber) {
        return LocaleStringHelper.getEntityDisplayName((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
    }

    public static String getEntityDisplayName(IDataEntityType dataEntityType) {
        return LocaleStringHelper.getDisplayName(dataEntityType);
    }

    public static String getPropertyDisplayName(String entityNumber, String propertyKey) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        return LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, propertyKey);
    }

    public static String getPropertyDisplayName(IDataEntityType dataEntityType, String propertyKey) {
        if (dataEntityType instanceof EntityType && !StringUtils.contains((CharSequence)propertyKey, (CharSequence)SEPARATOR)) {
            EntityType entityType = (EntityType)dataEntityType;
            return LocaleStringHelper.getDisplayName(entityType.findProperty(propertyKey));
        }
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String[] splitArray = StringUtils.split((String)propertyKey, (String)SEPARATOR);
        if (splitArray.length == 1) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)splitArray[0]);
            return LocaleStringHelper.getDisplayName(property);
        }
        int maxIndex = splitArray.length - 1;
        for (int i = 0; i < maxIndex; ++i) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)splitArray[i]);
            if (!(property instanceof EntryProp)) {
                return LocaleStringHelper.getDisplayName(property);
            }
            EntryProp entryProp = (EntryProp)property;
            properties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        }
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)splitArray[maxIndex]);
        return LocaleStringHelper.getDisplayName(property);
    }

    public static String getDisplayName(IDataEntityProperty property) {
        if (property == null) {
            return "";
        }
        return LocaleStringHelper.getDisplayName(property.getDisplayName());
    }

    public static String buildEmptyQueryResultMsg(String entityNumber, String propertyKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"LocaleStringHelper_0", (String)"mmc-pmpd-common", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)dataEntityType), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, propertyKey));
    }

    public static String buildEmptyFieldValueMsg(IDataEntityType dataEntityType, String propertyKey) {
        return String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u503c\u4e3a\u7a7a\u3002", (String)"LocaleStringHelper_1", (String)"mmc-pmpd-common", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName(dataEntityType, propertyKey));
    }

    private static String getDisplayName(LocaleString displayName) {
        return displayName == null ? "" : displayName.toString();
    }

    private static String getDisplayName(IDataEntityType dataEntityType) {
        return dataEntityType == null ? "" : LocaleStringHelper.getDisplayName(dataEntityType.getDisplayName());
    }
}

