/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;

public class SimilarMainElement
implements Serializable {
    private static final long serialVersionUID = 2501938081010631600L;
    private String entityNumber;
    private long pk;
    private boolean isUseable;
    private String name;
    private boolean isFilter;
    private String entityPropName;
    private String entityProp;
    private String projectProp;
    private String projectPropName;
    private int score;
    private String scoreName;

    public SimilarMainElement() {
    }

    public SimilarMainElement(DynamicObject entityObj, DynamicObject mainElement) {
        if (entityObj == null || mainElement == null) {
            throw new KDException(new ErrorCode("params is null", "SimilarMainElement Init Error."), new Object[0]);
        }
        this.entityNumber = entityObj.getPkValue() == null ? "" : entityObj.getPkValue().toString();
        this.isUseable = mainElement.getBoolean("isuseable");
        this.pk = mainElement.getPkValue() == null ? 0L : Long.parseLong(mainElement.getPkValue().toString());
        this.name = mainElement.getString("elementname");
        this.isFilter = mainElement.getBoolean("isasfilter");
        this.score = mainElement.getInt("score");
        this.initProperty(mainElement);
    }

    private void initProperty(DynamicObject mainElement) {
        String entityFieldProp = mainElement.get("entityfieldprop") == null ? null : mainElement.get("entityfieldprop").toString();
        String projectFieldProp = mainElement.get("projectfieldprop") == null ? null : mainElement.get("projectfieldprop").toString();
        this.parseField("entity", entityFieldProp);
        this.parseField("project", projectFieldProp);
    }

    private void parseField(String fieldType, String fieldProp) {
        if (StringUtils.isNotBlank((CharSequence)fieldProp)) {
            ExpressionProperty prop = (ExpressionProperty)SerializationUtils.fromJsonString((String)fieldProp, ExpressionProperty.class);
            Object mainType = null;
            String expression = prop.getExpression();
            String entryPath = prop.getEntryPath();
            String prefix = prop.getPrefix();
            if (StringUtils.equals((CharSequence)"entity", (CharSequence)fieldType)) {
                this.entityProp = expression.replace(prefix + ".", "");
                this.entityPropName = prop.getFullName();
            } else {
                this.projectProp = expression.replace(prefix + ".", "");
                this.projectPropName = prop.getFullName();
            }
        }
    }

    public long getPk() {
        return this.pk;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public boolean isUseable() {
        return this.isUseable;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public void setPk(long pk) {
        this.pk = pk;
    }

    public void setUseable(boolean useable) {
        this.isUseable = useable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFilter(boolean filter) {
        this.isFilter = filter;
    }

    public void setEntityPropName(String entityPropName) {
        this.entityPropName = entityPropName;
    }

    public void setEntityProp(String entityProp) {
        this.entityProp = entityProp;
    }

    public void setProjectProp(String projectProp) {
        this.projectProp = projectProp;
    }

    public void setProjectPropName(String projectPropName) {
        this.projectPropName = projectPropName;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String getEntityProp() {
        return this.entityProp;
    }

    public String getProjectProp() {
        return this.projectProp;
    }

    public String getEntityPropName() {
        return this.entityPropName;
    }

    public String getProjectPropName() {
        return this.projectPropName;
    }

    public int getScore() {
        return this.score;
    }

    public String getScoreName() {
        return this.scoreName;
    }

    public void setScoreName(String scoreName) {
        this.scoreName = scoreName;
    }
}

