/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.pmc.pmpd.common.helper.HoldElement;
import kd.pmc.pmpd.common.helper.SimilarMainElement;
import kd.pmc.pmpd.common.helper.SpFiledHelper;

public class SimilarPrjCalcParams
implements Serializable {
    private static final long serialVersionUID = -5838079330087949593L;
    private Long projectOrgId;
    private String projectOrgNum;
    private String projectOrgName;
    private long similarProject;
    private String entityObj;
    private int scoreLine;
    private int projects;
    private String filterCondition;
    private SpFiledHelper mainElements;
    private List<HoldElement> holdElements;
    private long billPk;
    private String billnumber;
    private long callogId;

    public SimilarPrjCalcParams() {
    }

    public SimilarPrjCalcParams(DynamicObject data) {
        if (data == null) {
            throw new KDException(new ErrorCode("params is null", "SimilarPrjCalcParams Init Error."), new Object[0]);
        }
        DynamicObject entity = data.getDynamicObject("entityobject");
        this.entityObj = entity == null ? "" : entity.getPkValue().toString();
        this.scoreLine = data.getInt("scoreline");
        this.projects = data.getInt("projects");
        this.filterCondition = data.getString("filterjson_tag");
        DynamicObject orgObj = data.getDynamicObject("createorg");
        if (Objects.isNull(orgObj)) {
            this.projectOrgId = 0L;
            this.projectOrgNum = "";
            this.projectOrgName = "";
        } else {
            this.projectOrgId = orgObj.getLong("id");
            this.projectOrgNum = orgObj.getString("number");
            this.projectOrgName = orgObj.getString("name");
        }
        this.similarProject = data.getPkValue() == null ? 0L : Long.parseLong(data.getPkValue().toString());
        DynamicObjectCollection mainEntrys = data.getDynamicObjectCollection("mainelement");
        SpFiledHelper similarHelper = new SpFiledHelper(entity);
        for (DynamicObject mainElement : mainEntrys) {
            SimilarMainElement mainElementEntity = new SimilarMainElement(entity, mainElement);
            similarHelper.addElement(mainElementEntity);
        }
        this.mainElements = similarHelper;
        DynamicObjectCollection holdEntrys = data.getDynamicObjectCollection("holdelement");
        ArrayList<HoldElement> holds = new ArrayList<HoldElement>(holdEntrys.size());
        holdEntrys.forEach(holdEntry -> {
            HoldElement holdElement = new HoldElement((DynamicObject)holdEntry);
            holds.add(holdElement);
        });
        this.holdElements = holds;
    }

    public SimilarPrjCalcParams(AbstractFormDataModel dataModel) {
        DynamicObject entity = (DynamicObject)dataModel.getValue("entityobject");
        this.entityObj = entity == null ? "" : entity.getPkValue().toString();
        this.scoreLine = (Integer)dataModel.getValue("scoreline");
        this.projects = (Integer)dataModel.getValue("projects");
        this.filterCondition = (String)dataModel.getValue("filterjson_tag");
        DynamicObject orgObj = (DynamicObject)dataModel.getValue("projectorg");
        this.projectOrgId = orgObj.getPkValue() == null ? 0L : Long.parseLong(orgObj.getPkValue().toString());
        this.projectOrgNum = orgObj.getString("number");
        this.projectOrgName = orgObj.getString("name");
        DynamicObject similarProjectObj = (DynamicObject)dataModel.getValue("similarproject");
        this.similarProject = similarProjectObj == null ? 0L : Long.parseLong(similarProjectObj.getPkValue().toString());
        DynamicObjectCollection mainEntrys = dataModel.getEntryEntity("mainelement");
        SpFiledHelper similarHelper = new SpFiledHelper(entity);
        for (DynamicObject mainElement : mainEntrys) {
            SimilarMainElement mainElementEntity = new SimilarMainElement(entity, mainElement);
            similarHelper.addElement(mainElementEntity);
        }
        this.mainElements = similarHelper;
        DynamicObjectCollection holdEntrys = dataModel.getEntryEntity("holdelement");
        ArrayList<HoldElement> holds = new ArrayList<HoldElement>(holdEntrys.size());
        holdEntrys.forEach(holdEntry -> {
            HoldElement holdElement = new HoldElement((DynamicObject)holdEntry);
            holds.add(holdElement);
        });
        this.holdElements = holds;
    }

    public Long getProjectOrgId() {
        return this.projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }

    public String getProjectOrgNum() {
        return this.projectOrgNum;
    }

    public String getProjectOrgName() {
        return this.projectOrgName;
    }

    public long getSimilarProject() {
        return this.similarProject;
    }

    public void setSimilarProject(long similarProject) {
        this.similarProject = similarProject;
    }

    public String getEntityObj() {
        return this.entityObj;
    }

    public void setEntityObj(String entityObj) {
        this.entityObj = entityObj;
    }

    public int getScoreLine() {
        return this.scoreLine;
    }

    public void setScoreLine(int scoreLine) {
        this.scoreLine = scoreLine;
    }

    public int getProjects() {
        return this.projects;
    }

    public void setProjects(int projects) {
        this.projects = projects;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public SpFiledHelper getMainElements() {
        return this.mainElements;
    }

    public void setMainElements(SpFiledHelper mainElements) {
        this.mainElements = mainElements;
    }

    public List<HoldElement> getHoldElements() {
        return this.holdElements;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }

    public void setHoldElements(List<HoldElement> holdElements) {
        this.holdElements = holdElements;
    }

    public long getBillPk() {
        return this.billPk;
    }

    public String getBillnumber() {
        return this.billnumber;
    }

    public void setBillnumber(String billnumber) {
        this.billnumber = billnumber;
    }

    public long getCallogId() {
        return this.callogId;
    }

    public void setCallogId(long callogId) {
        this.callogId = callogId;
    }
}

