/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DateTimeEditHelper {
    private static final String TODAY = "today";
    private static final Date MINDATE;
    private static final Date MAXDATE;

    private DateTimeEditHelper() {
    }

    public static void setDisplayFormatString(IFormView formView, String displayFormatString, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        HashMap<String, String> itemMap = new HashMap<String, String>(2);
        itemMap.put("df", displayFormatString);
        HashMap<String, HashMap<String, String>> paramMap = new HashMap<String, HashMap<String, String>>(2);
        paramMap.put("item", itemMap);
        for (String key : keys) {
            formView.updateControlMetadata(key, paramMap);
        }
    }

    public static void setDefaultSelectedDate(IFormView formView, String defaultFormatString, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        ArrayList metas = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (String key : keys) {
            HashMap meta = Maps.newHashMapWithExpectedSize((int)2);
            meta.put("k", key);
            meta.put(TODAY, defaultFormatString);
            metas.add(meta);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        clientViewProxy.addAction("u", (Object)metas);
    }

    public static void setDefaultSelectedDate(IFormView formView, String dateTimeKey, boolean isMin) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)formView.getControl(dateTimeKey);
        if (dateTimeEdit == null) {
            return;
        }
        TimeZone timeZone = dateTimeEdit.getTimeZone().getTimeZone();
        HashMap meta = Maps.newHashMapWithExpectedSize((int)2);
        meta.put("k", dateTimeKey);
        meta.put(TODAY, isMin ? DateTimeEditHelper.getMinFormatString(timeZone) : DateTimeEditHelper.getMaxFormatString(timeZone));
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        clientViewProxy.addAction("u", (Object)meta);
    }

    public static void setDefaultSelectedDate(IFormView formView, String entryKey, String defaultFormatString, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put(TODAY, defaultFormatString);
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        for (String key : keys) {
            clientViewProxy.preInvokeControlMethod(entryKey, "setColFmtInfo", new Object[]{key, paramMap});
        }
    }

    public static TimeZone getTimeZone(IFormView formView, String dateTimeKey) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)formView.getControl(dateTimeKey);
        return dateTimeEdit == null ? KDDateUtils.getTimeZone() : dateTimeEdit.getTimeZone().getTimeZone();
    }

    public static String getMinFormatString(TimeZone timeZone) {
        return KDDateFormatUtils.getDateFormat((TimeZone)timeZone).format(new Date());
    }

    public static String getMaxFormatString(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 0);
        return KDDateFormatUtils.getDateTimeFormat((TimeZone)timeZone).format(calendar.getTime());
    }

    public static void recoveryMaxDate(IFormView formView, String dateTimeKey) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)formView.getControl(dateTimeKey);
        dateTimeEdit.setMaxDate(MAXDATE);
    }

    public static void recoveryMinDate(IFormView formView, String dateTimeKey) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)formView.getControl(dateTimeKey);
        dateTimeEdit.setMinDate(MINDATE);
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2999);
        calendar.set(2, 11);
        calendar.set(5, 31);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        MAXDATE = calendar.getTime();
        calendar.set(1, 1900);
        MINDATE = calendar.getTime();
    }
}

