/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper.control;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;

public final class EntryGridHelper {
    public static void batchMoveEntryRow(IFormView formView, String entryKey, int[] rows, int targetIndex) {
        if (ArrayUtils.isEmpty((int[])rows)) {
            return;
        }
        Arrays.sort(rows);
        IDataModel model = formView.getModel();
        EntryProp entryProp = (EntryProp)model.getProperty(entryKey);
        DynamicObjectType dt = entryProp.getDynamicCollectionItemPropertyType();
        DynamicObject[] entryEntity = model.getEntryEntity(entryKey, rows[0], rows[rows.length - 1] + 1);
        DynamicObjectCollection collection = new DynamicObjectCollection(dt, null);
        for (int i = entryEntity.length - 1; i >= 0; --i) {
            DynamicObject dynamicObject = collection.addNew();
            dynamicObject.set("id", entryEntity[i].getPkValue());
        }
        model.deleteEntryRows(entryKey, rows);
        model.beginInit();
        int[] selectRows = model.batchInsertEntryRow(entryProp, targetIndex, collection);
        List properties = dt.getProperties().stream().skip(2L).filter(iDataEntityProperty -> !iDataEntityProperty.isDbIgnore()).collect(Collectors.toList());
        for (int i = 0; i < selectRows.length; ++i) {
            int row = selectRows[i];
            DynamicObject dynamicObject = entryEntity[i];
            for (IDataEntityProperty property : properties) {
                model.setValue(property.getName(), property.getValueFast((Object)dynamicObject), row);
            }
        }
        model.endInit();
        model.setDataChanged(false);
        formView.updateView(entryKey);
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entryKey);
        entryGrid.selectRows(selectRows, selectRows[0]);
    }

    public static void batchCreateNewEntryRow(IFormView formView, String entryKey, TableValueSetter tvs) {
        AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(entryKey, tvs);
        model.endInit();
        formView.updateView(entryKey);
    }
}

