/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.helper.control;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;

public class PointLineChartHelper {
    public static PointLineChart getPointLineChart(IFormView formView, String key) {
        PointLineChart pointLineChart = (PointLineChart)formView.getControl(key);
        pointLineChart.setShowTooltip(true);
        pointLineChart.setMargin(Position.left, "40px");
        pointLineChart.setMargin(Position.right, "40px");
        return pointLineChart;
    }

    public static void createXAxis(PointLineChart pointLineChart, String name, String[] categorys) {
        Axis xAxis = pointLineChart.createXAxis(name, AxisType.category);
        xAxis.setCategorys(categorys);
        PointLineChartHelper.setAxisLineStyle(xAxis);
        PointLineChartHelper.setAxisNameStyle(xAxis);
    }

    public static Axis createYAxis(PointLineChart pointLineChart, String name) {
        Axis yAxis = pointLineChart.createYAxis(name, AxisType.value);
        PointLineChartHelper.setAxisLineStyle(yAxis);
        PointLineChartHelper.setAxisNameStyle(yAxis);
        PointLineChartHelper.setSplitLineStyle(yAxis);
        return yAxis;
    }

    public static Series createLineSeries(PointLineChart pointLineChart, String name, boolean showLable, Number[] data) {
        LineSeries series = pointLineChart.createSeries(name);
        if (showLable) {
            Label label = new Label();
            label.setShow(true);
            series.setLabel(label);
        }
        series.setData(data);
        return series;
    }

    private static void setAxisLineStyle(Axis axis) {
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(2);
        lineStyleMap.put("color", "#999999");
        HashMap<String, HashMap<String, String>> axisLineMap = new HashMap<String, HashMap<String, String>>(2);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    private static void setAxisNameStyle(Axis axis) {
        HashMap<String, String> nameStyleMap = new HashMap<String, String>(2);
        nameStyleMap.put("color", "#000000");
        axis.setPropValue("nameTextStyle", nameStyleMap);
    }

    private static void setSplitLineStyle(Axis axis) {
        HashMap<String, String> lineStyle = new HashMap<String, String>(2);
        lineStyle.put("type", "dotted");
        HashMap<String, HashMap<String, String>> splitLine = new HashMap<String, HashMap<String, String>>(2);
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
    }

    public static void setPercentageStyle(PointLineChart pointLineChart, Axis axis, Series series) {
        if (pointLineChart.isShowTooltip()) {
            pointLineChart.addTooltip("formatter", (Object)"function(params){\n\tlet res = \"\";\n\n\tres += params[0].axisValue + '<br/>';\n\tfor (var i = 0, l = params.length; i < l; i++) {\n\t\tres += params[i].marker + params[i].seriesName + ' : ';\n\t\tif(params[i].value) {\n\t\t\tres += params[i].value;\n\t\t}else{\n\t\t\tres += '0';\n\t\t}\n\t\tres += '%';\n\t\tres += '<br/>';\n\t}\n\treturn res;\n}");
            ArrayList<String> toolTipFuncPath = new ArrayList<String>();
            toolTipFuncPath.add("tooltip");
            toolTipFuncPath.add("formatter");
            pointLineChart.addFuncPath(toolTipFuncPath);
        }
        HashMap<String, String> formatterMap = new HashMap<String, String>(2);
        formatterMap.put("formatter", "{value}%");
        axis.setPropValue("axisLabel", formatterMap);
        Label label = series.getLabel();
        if (label != null) {
            label.setFormatter("{c}%");
        }
    }
}

