/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.model;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.util.ThreadLocals;
import kd.pmc.pmpd.common.enums.ShiftSystemEnum;
import kd.pmc.pmpd.common.model.DailySummaryResult;

public class EstimateContext {
    private static final ThreadLocal<EstimateContext> CURRENT = ThreadLocals.create();
    private static final int SCALE = 2;
    private static final int ROUNDING_MODE = 1;
    private ShiftSystemEnum shiftSystem;
    private Long industryId;
    private Long industryOneId;
    private int trt;
    private BigDecimal stageDays;
    private Date startTime;
    private BigDecimal summaryWorkHours;
    private BigDecimal totalWorkHours;
    private BigDecimal remainingDays;
    private BigDecimal remainingWorkHour;
    private Calendar calendar = Calendar.getInstance();
    private final Map<Date, DailySummaryResult> startDate2DailySummaryResult = new LinkedHashMap<Date, DailySummaryResult>(16);
    private String industryEntryKey;
    private String industryIdKey;
    private String industryOneIdKey;
    private String totalHoursKey;
    private String stageWorkHourEntryKey;
    private String dailyWorkHourEntryKey;
    private String summaryWorkHourEntryKey;
    private String percentageKey;

    public static EstimateContext get() {
        EstimateContext estimateContext = CURRENT.get();
        if (estimateContext == null) {
            estimateContext = new EstimateContext();
            CURRENT.set(estimateContext);
        }
        return estimateContext;
    }

    public static void remove() {
        CURRENT.remove();
    }

    public Long getIndustryId() {
        return this.industryId;
    }

    public void setIndustryId(Long industryId) {
        this.industryId = industryId;
    }

    public Long getIndustryOneId() {
        return this.industryOneId;
    }

    public void setIndustryOneId(Long industryOneId) {
        this.industryOneId = industryOneId;
    }

    public BigDecimal getSummaryWorkHours() {
        return this.summaryWorkHours;
    }

    public void setSummaryWorkHours(BigDecimal summaryWorkHours) {
        this.summaryWorkHours = summaryWorkHours;
    }

    public BigDecimal getTotalWorkHours() {
        return this.totalWorkHours;
    }

    public void setTotalWorkHours(BigDecimal totalWorkHours) {
        this.totalWorkHours = totalWorkHours;
    }

    public ShiftSystemEnum getShiftSystem() {
        return this.shiftSystem;
    }

    public void setShiftSystem(ShiftSystemEnum shiftSystem) {
        this.shiftSystem = shiftSystem;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Map<Date, DailySummaryResult> getStartDate2DailySummaryResult() {
        return this.startDate2DailySummaryResult;
    }

    public String getIndustryEntryKey() {
        return this.industryEntryKey;
    }

    public String getIndustryIdKey() {
        return this.industryIdKey;
    }

    public String getIndustryOneIdKey() {
        return this.industryOneIdKey;
    }

    public String getTotalHoursKey() {
        return this.totalHoursKey;
    }

    public String getStageWorkHourEntryKey() {
        return this.stageWorkHourEntryKey;
    }

    public String getDailyWorkHourEntryKey() {
        return this.dailyWorkHourEntryKey;
    }

    public String getSummaryWorkHourEntryKey() {
        return this.summaryWorkHourEntryKey;
    }

    public String getPercentageKey() {
        return this.percentageKey;
    }

    public BigDecimal getStageDays() {
        return this.stageDays;
    }

    public void setStageDays(BigDecimal stageDays) {
        this.stageDays = stageDays;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public BigDecimal getRemainingDays() {
        return this.remainingDays;
    }

    public void setRemainingDays(BigDecimal remainingDays) {
        this.remainingDays = remainingDays;
    }

    public BigDecimal getRemainingWorkHour() {
        return this.remainingWorkHour;
    }

    public void setRemainingWorkHour(BigDecimal remainingWorkHour) {
        this.remainingWorkHour = remainingWorkHour;
    }

    public int getTrt() {
        return this.trt;
    }

    public void setTrt(int trt) {
        this.trt = trt;
    }

    public static int getScale() {
        return 2;
    }

    public static int getRoundingMode() {
        return 1;
    }

    public void initEstimateContext() {
        this.industryEntryKey = "entryentity";
        this.stageWorkHourEntryKey = "subentryentity_stage";
        this.dailyWorkHourEntryKey = "subentryentity_daily";
        this.summaryWorkHourEntryKey = "entryentity_summary";
        this.industryIdKey = "industry_id";
        this.industryOneIdKey = "industryone_id";
        this.totalHoursKey = "totalhours";
        this.percentageKey = "stage_percentage";
        this.startDate2DailySummaryResult.clear();
    }

    public void initStandardContext() {
        this.industryEntryKey = "s_entryentity";
        this.stageWorkHourEntryKey = "s_subentryentity_stage";
        this.dailyWorkHourEntryKey = "s_subentryentity_daily";
        this.summaryWorkHourEntryKey = "s_entryentity_summary";
        this.industryIdKey = "s_industry_id";
        this.industryOneIdKey = "s_industryone_id";
        this.totalHoursKey = "s_totalhours";
        this.percentageKey = "s_stage_percentage";
        this.startDate2DailySummaryResult.clear();
    }
}

