/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.enums.ResourcePublicStatusEnum;
import kd.pmc.pmpd.common.helper.ResourcePlanHelper;
import kd.pmc.pmpd.common.util.MileStoneTplUtils;
import kd.pmc.pmpd.common.util.TimeResult;
import org.apache.commons.lang3.time.DateUtils;

public class NoseToTailUtil {
    public static void clearApprochNoseId(List<Long> approchEntryIds) {
        if (!CollectionUtils.isEmpty(approchEntryIds) && !CollectionUtils.isEmpty(approchEntryIds = approchEntryIds.stream().filter(x -> 0L != x).collect(Collectors.toList()))) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update ", new Object[0]).append("T_PMPD_APPROACHENTRY", new Object[0]);
            sqlBuilder.append(" set  fnosetotailid = ?  ", new Object[]{0L});
            sqlBuilder.append(" , fisnosetotail = ? where ", new Object[]{"0"});
            sqlBuilder.appendIn("fentryid", approchEntryIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"pmc"), (SqlBuilder)sqlBuilder);
        }
    }

    public static void clearPlanNoseId(List<Long> planIds) {
        if (!CollectionUtils.isEmpty(planIds) && !CollectionUtils.isEmpty(planIds = planIds.stream().filter(x -> 0L != x).collect(Collectors.toList()))) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update ", new Object[0]).append("t_pmpd_resourceplan_a", new Object[0]);
            sqlBuilder.append(" set  fnosetotailid = ?  ", new Object[]{0L});
            sqlBuilder.append(" , fisnosetotail = ? where ", new Object[]{"0"});
            sqlBuilder.appendIn("fid", planIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"pmc"), (SqlBuilder)sqlBuilder);
        }
    }

    public static void updateApprochNoseId(Long approachId, Long noseToTailId) {
        if (approachId != 0L) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update ", new Object[0]).append("T_PMPD_APPROACHENTRY", new Object[0]);
            sqlBuilder.append(" set  fnosetotailid = ?  ", new Object[]{noseToTailId});
            sqlBuilder.append(" , fisnosetotail = ? where ", new Object[]{"1"});
            sqlBuilder.append("fentryid  = ? ", new Object[]{approachId});
            DB.execute((DBRoute)DBRoute.of((String)"pmc"), (SqlBuilder)sqlBuilder);
        }
    }

    public static void updatePlanNoseId(Long resourceplanId, Long noseToTailId, int diffDay) {
        DynamicObject resourcePlan;
        if (resourceplanId != 0L && Objects.nonNull(resourcePlan = BusinessDataServiceHelper.loadSingle((Object)resourceplanId, (String)"pmpd_resourceplan"))) {
            resourcePlan.set("isnosetotail", (Object)"1");
            resourcePlan.set("nosetotail", (Object)noseToTailId);
            if (diffDay != 0) {
                Date estiApproachTime = DateUtils.addDays((Date)resourcePlan.getDate("estiapproachtime"), (int)diffDay);
                resourcePlan.set("estiapproachtime", (Object)estiApproachTime);
                resourcePlan.set("estideparttime", (Object)DateUtils.addDays((Date)resourcePlan.getDate("estideparttime"), (int)diffDay));
                ResourcePlanHelper.recalWorkHour(resourcePlan);
                for (DynamicObject entry : resourcePlan.getDynamicObjectCollection("entry_repair")) {
                    entry.set("sectionstarttime", (Object)DateUtils.addDays((Date)entry.getDate("sectionstarttime"), (int)diffDay));
                    entry.set("sectionendtime", (Object)DateUtils.addDays((Date)entry.getDate("sectionendtime"), (int)diffDay));
                }
                NoseToTailUtil.updateMileStone(resourcePlan);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resourcePlan});
        }
    }

    public static void updateMileStone(DynamicObject resourcePlan) {
        DynamicObject planTpl = resourcePlan.getDynamicObject("plantpl");
        if (planTpl != null) {
            DynamicObjectCollection mileStoneEntry = resourcePlan.getDynamicObjectCollection("milestoneentry");
            mileStoneEntry.clear();
            Date estiApproachTime = resourcePlan.getDate("estiapproachtime");
            BigDecimal repairCycleDay = resourcePlan.getBigDecimal("repaircycleday");
            DynamicObject planTemp = BusinessDataServiceHelper.loadSingle((Object)planTpl.getPkValue(), (String)"pmpd_milestonetpl");
            Map milestoneTimes = estiApproachTime == null ? null : MileStoneTplUtils.calTplTime((DynamicObject)planTemp, (Date)estiApproachTime, (BigDecimal)repairCycleDay);
            DynamicObjectCollection milestones = planTemp.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject milestone : milestones) {
                String biztype = milestone.getString("biztype");
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)biztype)) continue;
                DynamicObject stoneDyn = mileStoneEntry.addNew();
                Long id = milestone.getLong("id");
                TimeResult timeResult = milestoneTimes == null ? null : (TimeResult)milestoneTimes.get(id);
                stoneDyn.set("milestonename", milestone.get("milestonename"));
                stoneDyn.set("planbegin", milestone.get("planbegin"));
                stoneDyn.set("percent", milestone.get("percent"));
                stoneDyn.set("milestoneid", milestone.get("id"));
                stoneDyn.set("mitstarttime", (Object)(timeResult == null ? null : timeResult.getBeginDate()));
            }
        }
    }

    public static void updateNoseByDeletePlanId(Long resourceplanId) {
        DynamicObject[] load;
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"pmpd_nosetotail", (QFilter[])new QFilter[]{new QFilter("entryentity.resourceplan", "=", (Object)resourceplanId)}, null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pmpd_nosetotail");
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])objects.toArray(), (DynamicObjectType)dataEntityType)) {
            DynamicObjectCollection entryEentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryEentity) {
                if (!resourceplanId.equals(object.getLong("resourceplan.id"))) continue;
                object.set("resourceplan", null);
            }
            NoseToTailUtil.sortEntity(entryEentity);
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }

    public static DynamicObject updateNoseBySavePlanNo(DynamicObject dataEntity) {
        Boolean isNoseToTail = dataEntity.getBoolean("isnosetotail");
        String publishStatus = dataEntity.getString("pulishstatus");
        if (isNoseToTail.booleanValue() && StringUtils.equals((CharSequence)publishStatus, (CharSequence)ResourcePublicStatusEnum.PRE.getValue())) {
            DynamicObject noseToTail = dataEntity.getDynamicObject("nosetotail");
            long pkValue = (Long)dataEntity.getPkValue();
            String billNo = dataEntity.getString("billno");
            if (Objects.isNull(noseToTail)) {
                NoseToTailUtil.updateNoseBySavePlanNo(billNo, pkValue);
            } else {
                long count = (noseToTail = NoseToTailUtil.getNoseToTailById((Long)noseToTail.getPkValue())).getDynamicObjectCollection("entryentity").stream().filter(x -> x.getLong("resourceplan.id") == pkValue).count();
                if (count == 0L) {
                    NoseToTailUtil.updateNoseBySavePlanNo(billNo, pkValue);
                } else {
                    return noseToTail;
                }
            }
        }
        return null;
    }

    public static DynamicObject updateNoseBySavePlanNo(String resourcePlanNo, Long resourcePlanId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid from", new Object[0]).append("t_pmpd_approachentry", new Object[0]);
        sqlBuilder.append(" where  fresourceplanno = ? ", new Object[]{resourcePlanNo});
        long approachId = 0L;
        try (DataSet data = DB.queryDataSet((String)NoseToTailUtil.class.getName(), (DBRoute)new DBRoute("pmc"), (SqlBuilder)sqlBuilder);){
            for (Row row : data) {
                approachId = row.getLong(0);
            }
        }
        if (approachId == 0L) {
            return null;
        }
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"pmpd_nosetotail", (QFilter[])new QFilter[]{new QFilter("entryentity.approach", "=", (Object)approachId)}, null, (int)1);
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return null;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pmpd_nosetotail");
        DynamicObject noseToTail = BusinessDataServiceHelper.loadSingle(objects.get(0), (DynamicObjectType)dataEntityType);
        DynamicObjectCollection entryEntity = noseToTail.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : entryEntity) {
            if (approachId != object.getLong("approach.id")) continue;
            DynamicObject resourcePlan = BusinessDataServiceHelper.loadSingle((Object)resourcePlanId, (String)"pmpd_resourceplanf7");
            object.set("resourceplan", (Object)resourcePlan);
        }
        NoseToTailUtil.sortEntity(entryEntity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noseToTail});
        return noseToTail;
    }

    public static DynamicObject getNoseToTailById(Long noseToTailId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pmpd_nosetotail");
        DynamicObject noseToTail = BusinessDataServiceHelper.loadSingle((Object)noseToTailId, (DynamicObjectType)dataEntityType);
        return noseToTail;
    }

    public static void sortEntity(DynamicObjectCollection orginEntity) {
        List collect = orginEntity.stream().filter(x -> Objects.nonNull(x.get("resourceplan")) || Objects.nonNull(x.get("approach"))).sorted(Comparator.comparing(x -> Objects.isNull(x.getDate("resourceplan.estiapproachtime")) ? new Date(Long.MAX_VALUE) : x.getDate("resourceplan.estiapproachtime"))).collect(Collectors.toList());
        orginEntity.clear();
        for (int i = 0; i < collect.size(); ++i) {
            DynamicObject entry = (DynamicObject)collect.get(i);
            entry.set("seq", (Object)(i + 1));
            int preIntervalDays = 0;
            if (i != 0) {
                preIntervalDays = ((DynamicObject)collect.get(i - 1)).getInt("nextintervalday");
            }
            entry.set("preintervalday", (Object)preIntervalDays);
            int nextIntervalDays = 0;
            Date preEnd = entry.getDate("resourceplan.estideparttime");
            Date nextStart = null;
            if (i < collect.size() - 1) {
                nextStart = ((DynamicObject)collect.get(i + 1)).getDate("resourceplan.estiapproachtime");
            }
            if (Objects.nonNull(preEnd) && Objects.nonNull(nextStart)) {
                nextIntervalDays = NoseToTailUtil.getDiffDay(preEnd, nextStart);
            }
            entry.set("nextintervalday", (Object)nextIntervalDays);
            orginEntity.add(i, entry);
        }
    }

    public static int getDiffDay(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        startCalendar.set(11, 0);
        startCalendar.set(12, 0);
        startCalendar.set(13, 0);
        startCalendar.set(14, 0);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        endCalendar.set(11, 0);
        endCalendar.set(12, 0);
        endCalendar.set(13, 0);
        endCalendar.set(14, 0);
        long miles = endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis();
        BigDecimal day = new BigDecimal("86400000");
        BigDecimal divide = new BigDecimal(Long.toString(miles)).divide(day, 0, 4);
        return divide.intValue();
    }

    public static Date getTodayEnd() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        Date time = todayEnd.getTime();
        return time;
    }
}

