/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmbd.common.util.CommonUtils;
import kd.pmc.pmpd.common.enums.ProjectTeamEnum;

public class ProjectTeamUtils {
    public static Set<Long> getUsers(Long projectId) {
        HashSet<Long> users = new HashSet<Long>(16);
        String selectFields = CommonUtils.getSelects((String[])new String[]{"entryentity.subentryentity.enterprisehmrespo.id"});
        QFilter idFilter = new QFilter("pmbdproduct", "=", (Object)projectId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getEnterpriseHmResPoForProject", (String)"pmbd_project_hm_res_pl1", (String)selectFields, (QFilter[])new QFilter[]{idFilter, statusFilter}, null);){
            for (Row row : ds) {
                if (row.getLong("entryentity.subentryentity.enterprisehmrespo.id") == 0L) continue;
                users.add(row.getLong("entryentity.subentryentity.enterprisehmrespo.id"));
            }
        }
        return users;
    }

    public static Set<Long> getUsers() {
        HashSet<Long> users = new HashSet<Long>(16);
        String selectFields = CommonUtils.getSelects((String[])new String[]{"id"});
        QFilter idFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getEnterpriseHmResPo", (String)"pmbd_enterprise_hm_res_po", (String)selectFields, (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : ds) {
                if (row.getLong("id") == 0L) continue;
                users.add(row.getLong("id"));
            }
        }
        return users;
    }

    public static Map<Long, Map<String, Object>> getUserForTeam(Long projectTeamId, Long teamId) {
        HashMap<Long, Map<String, Object>> users = new HashMap<Long, Map<String, Object>>(16);
        String selectFields = CommonUtils.getSelects((String[])new String[]{"entryentity.subentryentity.enterprisehmrespo.id", "entryentity.subentryentity.ismain", "entryentity.subentryentity.role.id"});
        QFilter idFilter = new QFilter("id", "=", (Object)projectTeamId);
        QFilter teamidFilter = new QFilter("entryentity.id", "=", (Object)teamId);
        QFilter ismainFilter = new QFilter("entryentity.subentryentity.memberstatus", "=", (Object)ProjectTeamEnum.ADD.getValue());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getProjectTeam", (String)"pmpd_projectteam", (String)selectFields, (QFilter[])new QFilter[]{idFilter, teamidFilter, ismainFilter}, null);){
            for (Row row : ds) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("entryentity.subentryentity.ismain", row.getBoolean("entryentity.subentryentity.ismain"));
                map.put("entryentity.subentryentity.role.id", row.getString("entryentity.subentryentity.role.id"));
                if (row.getLong("entryentity.subentryentity.enterprisehmrespo.id") == 0L) continue;
                users.put(row.getLong("entryentity.subentryentity.enterprisehmrespo.id"), map);
            }
        }
        return users;
    }

    public static DynamicObject getProjectTeam(Long id) {
        String selectFields = CommonUtils.getSelects((String[])new String[]{"id", "entryentity", "entryentity.id", "billstatus", "subentryentity", "subentryentity.enterprisehmrespo", "subentryentity.memberstatus", "subentryentity.addteamdata", "subentryentity.memberstatus", "subentryentity.ismain", "subentryentity.leaveteamdata", "subentryentity.role", "role.id"});
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"pmpd_projectteam", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        return dyn;
    }

    public static List<DynamicObject> copyToEnterpriseHmResPo(Map<Long, List<Map<String, Object>>> productMap, Set<Long> userSet) {
        ArrayList<Map<String, Object>> selectEnterpriseHmResPoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> addEnterpriseHmResPo = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> updateEnterpriseHmResPo = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> deleteEnterpriseHmResPo = new ArrayList<Map<String, Object>>(10);
        ProjectTeamUtils.getEnterpriseHmResPo(productMap.keySet(), selectEnterpriseHmResPoList, userSet);
        if (userSet.isEmpty()) {
            return new ArrayList<DynamicObject>(1);
        }
        ProjectTeamUtils.analysisEnterpriseHmResPo(productMap, addEnterpriseHmResPo, updateEnterpriseHmResPo, deleteEnterpriseHmResPo, selectEnterpriseHmResPoList);
        if (addEnterpriseHmResPo.isEmpty() && updateEnterpriseHmResPo.isEmpty() && deleteEnterpriseHmResPo.isEmpty()) {
            return new ArrayList<DynamicObject>(1);
        }
        String selectFields = CommonUtils.getSelects((String[])new String[]{"id", "projectentity", "projectentity.sourcename", "projectentity.projecthmrespl", "projectentity.role", "projectentity.addproducttime", "projectentity.projectcreater", "projectentity.projectcreatedate", "projectentity.projectmodifier", "projectentity.projectmodifydate", "projectentity.teamentryentityid"});
        QFilter idsFilter = new QFilter("id", "in", userSet);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"pmbd_enterprise_hm_res_po", (String)selectFields, (QFilter[])new QFilter[]{idsFilter});
        List<DynamicObject> list = ProjectTeamUtils.updateEnterpriseHmResPo(dynObjs, addEnterpriseHmResPo, updateEnterpriseHmResPo, deleteEnterpriseHmResPo);
        return list;
    }

    private static void getEnterpriseHmResPo(Set<Long> productSet, List<Map<String, Object>> selectEnterpriseHmResPoList, Set<Long> userSet) {
        String selectFields = CommonUtils.getSelects((String[])new String[]{"id", "projectentity", "projectentity.projecthmrespl", "projectentity.role", "projectentity.addproducttime", "projectentity.teamentryentityid"});
        QFilter ProjectHmResPlIdFilter = new QFilter("projectentity.projecthmrespl", "in", productSet);
        QFilter sourceNameFilter = new QFilter("projectentity.sourcename", "=", (Object)"1002");
        try (DataSet ds = ORM.create().queryDataSet("getEnterpriseHmResPo", "pmbd_enterprise_hm_res_po", selectFields, new QFilter[]{ProjectHmResPlIdFilter, sourceNameFilter});){
            for (Row row : ds) {
                if (row.getLong("projectentity.projecthmrespl") == 0L) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("id", row.getLong("id"));
                map.put("projecthmrespl", row.getLong("projectentity.projecthmrespl"));
                map.put("role", row.getString("projectentity.role"));
                map.put("addproducttime", row.getDate("projectentity.addproducttime"));
                map.put("teamentryentityid", row.getLong("projectentity.teamentryentityid"));
                selectEnterpriseHmResPoList.add(map);
                userSet.add(row.getLong("id"));
            }
        }
    }

    private static void analysisEnterpriseHmResPo(Map<Long, List<Map<String, Object>>> productMap, List<Map<String, Object>> addEnterpriseHmResPo, List<Map<String, Object>> updateEnterpriseHmResPo, List<Map<String, Object>> deleteEnterpriseHmResPo, List<Map<String, Object>> selectEnterpriseHmResPoList) {
        for (Map.Entry<Long, List<Map<String, Object>>> entrySet : productMap.entrySet()) {
            List<Map<String, Object>> productList = entrySet.getValue();
            for (Map<String, Object> product : productList) {
                boolean isAdd = true;
                Iterator<Map<String, Object>> it = selectEnterpriseHmResPoList.iterator();
                while (it.hasNext()) {
                    Map<String, Object> selectMap = it.next();
                    if (product.get("id").equals(selectMap.get("projecthmrespl")) && selectMap.get("id").equals(product.get("enterprisehmrespo")) && product.get("entryentity.id").equals(selectMap.get("teamentryentityid"))) {
                        Date oldDate = (Date)selectMap.get("addproducttime");
                        Date newDate = (Date)product.get("addteamdata");
                        if (oldDate == null) {
                            if (newDate == null) {
                                isAdd = false;
                                it.remove();
                                continue;
                            }
                            updateEnterpriseHmResPo.add(product);
                        } else if (newDate != null && oldDate.getTime() != newDate.getTime()) {
                            updateEnterpriseHmResPo.add(product);
                        } else if (!selectMap.get("role").equals(product.get("role"))) {
                            updateEnterpriseHmResPo.add(product);
                        }
                        isAdd = false;
                        it.remove();
                        continue;
                    }
                    if (product.get("id").equals(selectMap.get("projecthmrespl"))) continue;
                    it.remove();
                }
                if (!isAdd) continue;
                addEnterpriseHmResPo.add(product);
            }
        }
        deleteEnterpriseHmResPo.addAll(selectEnterpriseHmResPoList);
    }

    private static List<DynamicObject> updateEnterpriseHmResPo(DynamicObject[] dynObjs, List<Map<String, Object>> addEnterpriseHmResPo, List<Map<String, Object>> updateEnterpriseHmResPo, List<Map<String, Object>> deleteEnterpriseHmResPo) {
        ArrayList<DynamicObject> updateDynObjs = new ArrayList<DynamicObject>(10);
        for (DynamicObject dynObj : dynObjs) {
            Iterator<Map<String, Object>> addit = addEnterpriseHmResPo.iterator();
            boolean isUpdate = false;
            DynamicObjectCollection dynObjColl = (DynamicObjectCollection)dynObj.get("projectentity");
            while (addit.hasNext()) {
                Map<String, Object> addMap = addit.next();
                if (dynObj.getLong("id") != ((Long)addMap.get("enterprisehmrespo")).longValue()) continue;
                DynamicObject productEntryObj = new DynamicObject(dynObjColl.getDynamicObjectType());
                productEntryObj.set("sourcename", (Object)"1002");
                productEntryObj.set("projecthmrespl", addMap.get("id"));
                productEntryObj.set("role", addMap.get("role"));
                productEntryObj.set("addproducttime", addMap.get("addteamdata"));
                productEntryObj.set("projectcreater", (Object)RequestContext.get().getUserId());
                productEntryObj.set("projectcreatedate", (Object)new Date());
                productEntryObj.set("teamentryentityid", addMap.get("entryentity.id"));
                dynObjColl.add((Object)productEntryObj);
                addit.remove();
                isUpdate = true;
            }
            Iterator<Map<String, Object>> updateit = updateEnterpriseHmResPo.iterator();
            while (updateit.hasNext()) {
                Map<String, Object> updateMap = updateit.next();
                for (DynamicObject updateDynObj : dynObjColl) {
                    if (updateDynObj.getLong("projecthmrespl") == 0L || updateDynObj.getLong("projecthmrespl") != ((Long)updateMap.get("id")).longValue() || dynObj.getLong("id") != ((Long)updateMap.get("enterprisehmrespo")).longValue() || updateDynObj.getLong("teamentryentityid") != ((Long)updateMap.get("entryentity.id")).longValue()) continue;
                    updateDynObj.set("addproducttime", updateMap.get("addteamdata"));
                    updateDynObj.set("projectmodifier", (Object)RequestContext.get().getUserId());
                    updateDynObj.set("projectmodifydate", (Object)new Date());
                    updateDynObj.set("role", updateMap.get("role"));
                    updateit.remove();
                    isUpdate = true;
                }
            }
            Iterator<Map<String, Object>> deleteit = deleteEnterpriseHmResPo.iterator();
            DynamicObjectCollection deleteDynObjColl = new DynamicObjectCollection();
            while (deleteit.hasNext()) {
                Map<String, Object> deleteMap = deleteit.next();
                for (DynamicObject deleteDynObj : dynObjColl) {
                    if (deleteDynObj.getLong("projecthmrespl") == 0L || deleteDynObj.getLong("projecthmrespl") != ((Long)deleteMap.get("projecthmrespl")).longValue() || !deleteMap.get("teamentryentityid").equals(deleteDynObj.get("teamentryentityid")) || dynObj.getLong("id") != ((Long)deleteMap.get("id")).longValue()) continue;
                    deleteDynObjColl.add((Object)deleteDynObj);
                    isUpdate = true;
                    deleteit.remove();
                }
            }
            if (!deleteDynObjColl.isEmpty()) {
                dynObjColl.removeAll((Collection)deleteDynObjColl);
            }
            if (!isUpdate) continue;
            dynObj.set("projectentity", (Object)dynObjColl);
            updateDynObjs.add(dynObj);
        }
        return updateDynObjs;
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            if (value == null || value.size() <= 0) continue;
            result.add(value);
        }
        return result;
    }
}

