/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeekUtils {
    public static List<Map<String, Object>> getWeekOfYear(int year) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(2);
        int weekNumOfYear = WeekUtils.getWeekNumOfYear(new Date());
        Calendar c = Calendar.getInstance();
        WeekFields wfs = WeekFields.of(DayOfWeek.MONDAY, 4);
        int num = LocalDate.of(year, 12, 31).get(wfs.weekOfWeekBasedYear());
        num = num == 1 ? 52 : num;
        for (int i = 1; i <= num; ++i) {
            String days = WeekUtils.getDay(year, i, DayOfWeek.MONDAY) + "," + WeekUtils.getDay(year, i, DayOfWeek.TUESDAY) + "," + WeekUtils.getDay(year, i, DayOfWeek.WEDNESDAY) + "," + WeekUtils.getDay(year, i, DayOfWeek.THURSDAY) + "," + WeekUtils.getDay(year, i, DayOfWeek.FRIDAY) + "," + WeekUtils.getDay(year, i, DayOfWeek.SATURDAY) + "," + WeekUtils.getDay(year, i, DayOfWeek.SUNDAY);
            String[] split = WeekUtils.trim(days, ",").split(",");
            String start = split[0];
            int month = Integer.parseInt(start.split("-")[0]);
            String end = split[split.length - 1];
            days = start + "~" + end;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("year", year);
            data.put("month", month);
            data.put("week", i);
            data.put("days", days);
            data.put("startDay", start);
            data.put("end", end);
            data.put("isCurrentWeek", 0);
            if (weekNumOfYear == i) {
                data.put("isCurrentWeek", 1);
            }
            list.add(data);
        }
        return list;
    }

    private static String getDay(Integer year, Integer num, DayOfWeek dayOfWeek) {
        String numStr = num < 10 ? "0" + String.valueOf(num) : String.valueOf(num);
        String weekDate = String.format("%s-W%s-%s", year, numStr, dayOfWeek.getValue());
        String date = LocalDate.parse(weekDate, DateTimeFormatter.ISO_WEEK_DATE).toString();
        String[] split = date.split("-");
        if (!split[0].equals(year.toString())) {
            return "";
        }
        date = split[1] + "-" + split[2];
        return date;
    }

    public static String trim(String str, String element) {
        if (str == null || str.equals("")) {
            return str;
        }
        boolean beginIndexFlag = true;
        boolean endIndexFlag = true;
        do {
            int beginIndex = str.indexOf(element) == 0 ? 1 : 0;
            int endIndex = str.lastIndexOf(element) + 1 == str.length() ? str.lastIndexOf(element) : str.length();
            str = str.substring(beginIndex, endIndex);
            beginIndexFlag = str.indexOf(element) == 0;
            boolean bl = endIndexFlag = str.lastIndexOf(element) + 1 == str.length();
        } while (beginIndexFlag || endIndexFlag);
        return str;
    }

    public static int getWeekNumOfYear(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.setTime(date);
        return c.get(3);
    }

    public static int getMonth(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return c.get(2) + 1;
    }

    public static Date getYearBegin(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getYearEnd(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(2, 11);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }
}

