/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;

public final class WorkPackImportUtils {
    private WorkPackImportUtils() {
    }

    public static String buildImportFormTitle(String caption, Object executeWorkPackManageId) {
        return caption + "[" + executeWorkPackManageId + "]";
    }

    public static long getExecuteWorkPackManageId(String listName) {
        String[] splitArray = StringUtils.split((String)listName, (String)"[");
        if (splitArray == null || splitArray.length < 2) {
            return 0L;
        }
        if ((splitArray = StringUtils.split((String)splitArray[1], (String)"]")) == null || splitArray.length == 0) {
            return 0L;
        }
        return ObjectConverterWrapper.getLong(splitArray[0]);
    }

    public static Map<String, Integer> getName2MaxSupplementNo(String entityNumber, long executeWorkPackManageId) {
        String selectFields = "name, supplement";
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", (Object)executeWorkPackManageId)};
        HashMap<String, Integer> name2MaxSupplementNo = new HashMap<String, Integer>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getName2MaxSupplementNo", (String)entityNumber, (String)selectFields, (QFilter[])filters, (String)"id desc");){
            for (Row row : dataSet) {
                String name = ObjectConverterWrapper.getString(row.get(0));
                Integer supplementNo = ObjectConverterWrapper.getInt(row.get(1));
                name2MaxSupplementNo.putIfAbsent(name, supplementNo);
            }
        }
        return name2MaxSupplementNo;
    }

    public static Map<String, Integer> getName2MaxSupplementNo(String entityNumber, long executeWorkPackManageId, Set<String> names) {
        String selectFields = "name, supplement";
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", (Object)executeWorkPackManageId), new QFilter("name", "in", names)};
        HashMap name2MaxSupplementNo = Maps.newHashMapWithExpectedSize((int)names.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMaxSupplementNo", (String)entityNumber, (String)selectFields, (QFilter[])filters, (String)"id desc");){
            for (Row row : dataSet) {
                String name = ObjectConverterWrapper.getString(row.get(0));
                Integer supplementNo = ObjectConverterWrapper.getInt(row.get(1));
                name2MaxSupplementNo.putIfAbsent(name, supplementNo);
            }
        }
        return name2MaxSupplementNo;
    }

    public static Tuple<String, Long> getMaxSupplementNoAndProject(String entityNumber, long executeWorkPackManageId, String name) {
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", (Object)executeWorkPackManageId), new QFilter("name", "=", (Object)name)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMaxSupplementNo", (String)entityNumber, (String)"supplement, project", (QFilter[])filters, null);){
            if (dataSet.isEmpty()) {
                Tuple tuple = new Tuple((Object)"0", (Object)0L);
                return tuple;
            }
            Long projectId = 0L;
            int maxSupplementNo = 0;
            for (Row row : dataSet) {
                Integer supplementNo = ObjectConverterWrapper.getInt(row.get(0));
                maxSupplementNo = Math.max(maxSupplementNo, supplementNo);
                if (supplementNo != 0) continue;
                projectId = ObjectConverterWrapper.getLong(row.get(1));
            }
            Iterator iterator = new Tuple((Object)String.valueOf(++maxSupplementNo), (Object)projectId);
            return iterator;
        }
    }

    public static String startImport(AbstractFormPlugin formPlugin, Object manageId, Object orgId, String entityNumber, String importPluginName) {
        IFormView view = formPlugin.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        FormShowParameter importFormShowParameter = new FormShowParameter();
        importFormShowParameter.setFormId("bos_importstart");
        Map customParams = importFormShowParameter.getCustomParams();
        WorkPackImportUtils.buildImportParams(entityNumber, formShowParameter, customParams, manageId, orgId, importPluginName);
        importFormShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        importFormShowParameter.setParentPageId(view.getPageId());
        importFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "import-" + entityNumber));
        importFormShowParameter.setAppId(formShowParameter.getServiceAppId());
        String pageId = importFormShowParameter.getPageId();
        view.showForm(importFormShowParameter);
        return pageId;
    }

    private static void buildImportParams(String entityNumber, FormShowParameter formShowParameter, Map<String, Object> customParams, Object manageId, Object orgId, String importPluginName) {
        customParams.put("ServiceAppId", formShowParameter.getServiceAppId());
        customParams.put("CheckRightAppId", formShowParameter.getCheckRightAppId());
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityNumber);
        customParams.put("BillFormId", formConfig.getEntityTypeId());
        String title = "pmpd_panel_comparsion".equals(entityNumber) ? ResManager.loadKDString((String)"\u5bf9\u7167\u8868", (String)"WorkPackImportUtils_1", (String)"mmc-pmpd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5de5\u4f5c\u5305", (String)"WorkPackImportUtils_2", (String)"mmc-pmpd-common", (Object[])new Object[0]);
        customParams.put("ListName", WorkPackImportUtils.buildImportFormTitle(title, manageId));
        customParams.put("PermissionItemId", formShowParameter.getPermissionItemId());
        customParams.put("RealPermissionEntityId", formConfig.getEntityTypeId());
        customParams.put("MainOrgIds", SerializationUtils.toJsonString((Object)Lists.newArrayList((Object[])new Object[]{orgId})));
        customParams.put("OperateName", ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"WorkPackImportUtils_0", (String)"mmc-pmpd-common", (Object[])new Object[0]));
        customParams.put("ImportPlugin", importPluginName);
    }

    public static boolean isFromImport(OperateOption operateOption) {
        return ObjectConverterWrapper.getBoolean(operateOption.getVariableValue("importtag_of_datasource", "false"));
    }
}

