/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.model.WorkPackageProjectInfo;
import org.apache.commons.collections4.CollectionUtils;

public final class WorkPackageUtils {
    public static void showSequenceConfigurationForm(IFormView formView, String entryKey, CloseCallBack closeCallBack) {
        int nextIndex;
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkPackageUtils_0", (String)"mmc-pmpd-common", (Object[])new Object[0]));
            return;
        }
        int length = selectRows.length;
        int rowCount = formView.getModel().getEntryRowCount(entryKey);
        if (length == rowCount) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u6240\u6709\u884c\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"WorkPackageUtils_1", (String)"mmc-pmpd-common", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < length && (nextIndex = i + 1) != length; ++i) {
            if (selectRows[nextIndex] - selectRows[i] == 1) continue;
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fde\u7eed\u7684\u6570\u636e\u3002", (String)"WorkPackageUtils_2", (String)"mmc-pmpd-common", (Object[])new Object[0]));
            return;
        }
        int minSelectedSeq = selectRows[0];
        int minValue = minSelectedSeq == 0 ? 2 : 1;
        int maxValue = rowCount - length + 1;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_seq_config");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("minValue", (Object)minValue);
        formShowParameter.setCustomParam("maxValue", (Object)maxValue);
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }

    public static List<Object> listProjectIdByExecuteWorkPakcageManageId(long executeWorkPackageManageId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)executeWorkPackageManageId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"WorkPackageUtils", (String)"pmpd_exec_workpack_manage", (String)"equipment", (QFilter[])filters, null, (int)1);){
            if (dataSet.isEmpty()) {
                List<Object> list = Collections.emptyList();
                return list;
            }
            long equiementId = dataSet.next().getLong(0);
            List<Object> list = WorkPackageUtils.listProjectIdByEquipmentId(equiementId);
            return list;
        }
    }

    public static List<Object> listProjectIdByEquipmentId(long equiementId) {
        if (equiementId == 0L) {
            return new ArrayList<Object>();
        }
        QFilter[] filters = new QFilter[4];
        filters[0] = new QFilter("devices", "=", (Object)equiementId);
        filters[1] = new QFilter("status", "=", (Object)"C");
        filters[2] = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        HashSet<Long> prjstateIds = new HashSet<Long>(3);
        prjstateIds.add(696208292405629952L);
        prjstateIds.add(696208189016036352L);
        prjstateIds.add(696208443861947392L);
        filters[3] = new QFilter("prjstate.id", "not in", prjstateIds);
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"pmpd_project", (String)"id", (QFilter[])filters);
        return cache.isEmpty() ? Collections.emptyList() : new ArrayList(cache.keySet());
    }

    public static long getMainProjectId(long equiementId) {
        QFilter[] filters = new QFilter[]{new QFilter("devices", "=", (Object)equiementId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"pmpd_project", (String)"id, ismain", (QFilter[])filters);
        if (cache.isEmpty()) {
            return 0L;
        }
        if (cache.size() == 1) {
            return ObjectConverterWrapper.getLong(cache.keySet().toArray()[0]);
        }
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject project = (DynamicObject)entry.getValue();
            if (!project.getBoolean("ismain")) continue;
            return ObjectConverterWrapper.getLong(entry.getKey());
        }
        return 0L;
    }

    public static long getMainProjectId(List<Object> projectIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", projectIds), new QFilter("ismain", "=", (Object)true)};
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"pmpd_project", (String)"id", (QFilter[])filters);
        if (cache.isEmpty()) {
            return 0L;
        }
        return ObjectConverterWrapper.getLong(cache.keySet().toArray()[0]);
    }

    public static Map<Object, WorkPackageProjectInfo> getWorkPackageProjectInfo(Object[] projectIdArray) {
        HashSet selectFields = Sets.newHashSet((Object[])new String[]{"expstartdate", "fixlevel", "workscope", "entryentity.saleconstract", "entryentity.saleconstractno"});
        DynamicObjectType queryType = EntityMetadataCache.getSubDataEntityType((String)"pmpd_project", (Collection)selectFields);
        Map cache = BusinessDataServiceHelper.loadFromCache((Object[])projectIdArray, (DynamicObjectType)queryType);
        if (cache.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)cache.size());
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject project = (DynamicObject)entry.getValue();
            WorkPackageProjectInfo workPakcageProjectInfo = new WorkPackageProjectInfo();
            workPakcageProjectInfo.setProjectId((Long)entry.getKey());
            workPakcageProjectInfo.setCheckTypeId(project.getLong("fixlevel_id"));
            workPakcageProjectInfo.setWorkScopeId(project.getLong("workscope_id"));
            workPakcageProjectInfo.setEstimateApproachTime(project.getDate("expstartdate"));
            DynamicObjectCollection collection = project.getDynamicObjectCollection("entryentity");
            if (!collection.isEmpty()) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(0);
                workPakcageProjectInfo.setContractId(dynamicObject.getLong("saleconstract"));
                workPakcageProjectInfo.setContractNo(dynamicObject.getString("saleconstractno"));
            }
            resultMap.put(entry.getKey(), workPakcageProjectInfo);
        }
        return resultMap;
    }

    public static WorkPackageProjectInfo getWorkPackageProjectInfo(Long projectId) {
        if (projectId == 0L) {
            return null;
        }
        Map<Object, WorkPackageProjectInfo> workPackageProjectInfoMap = WorkPackageUtils.getWorkPackageProjectInfo(new Object[]{projectId});
        return workPackageProjectInfoMap.get(projectId);
    }

    public static Map<String, Map<String, Map<String, List<DynamicObject>>>> getWorkCardByCustomWorkCard(QFilter[] filters) {
        String selectFields = "cardname, cardnum, cardversion, group, refwordcard, cardnumid, panel, riskcard, pageentity.pageseq, pageentity.pagesumhours, entryentity1, firstexe, isom";
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (String)selectFields, (QFilter[])filters);
        if (cache.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, List<DynamicObject>>>> resultMap = new HashMap<String, Map<String, Map<String, List<DynamicObject>>>>(16);
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject workCard = (DynamicObject)entry.getValue();
            Map supplementaryCodeMap = resultMap.computeIfAbsent(workCard.getString("cardnum"), k -> new HashMap(16));
            Map versionMap = supplementaryCodeMap.computeIfAbsent(workCard.getString("cardnumid"), k -> new HashMap(16));
            List workCards = versionMap.computeIfAbsent(workCard.getString("cardversion"), k -> new ArrayList(10));
            workCards.add(workCard);
        }
        return resultMap;
    }

    public static boolean verifyWorkHourInfo(DynamicObject workCard) {
        return CollectionUtils.isEmpty((Collection)workCard.getDynamicObjectCollection("pageentity"));
    }

    public static long getMaintenanceModel(long equipmentId, String modelType) {
        long maintenanceModelId = WorkPackageUtils.getMaintenanceModel(equipmentId);
        if (maintenanceModelId == 0L) {
            return maintenanceModelId;
        }
        Map<String, Long> maintenanceModelMap = WorkPackageUtils.findMaintenanceModel(maintenanceModelId);
        return maintenanceModelMap.getOrDefault(modelType, maintenanceModelId);
    }

    public static Map<String, Long> findMaintenanceModel(long maintenanceModelId) {
        if (maintenanceModelId == 0L) {
            return Collections.emptyMap();
        }
        Object response = DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMrTypeConfigModelService", (String)"getParentTypeById", (Object[])new Object[]{maintenanceModelId});
        return response instanceof Map ? (Map)response : Collections.emptyMap();
    }

    public static long getMaintenanceModel(long equipmentId) {
        DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)"mpdm_materialmtcinfo", (Collection)Sets.newHashSet((Object[])new String[]{"maintenequipmodel"}));
        DynamicObject equipment = BusinessDataServiceHelper.loadSingleFromCache((Object)equipmentId, (DynamicObjectType)dt);
        return equipment == null ? 0L : equipment.getLong("maintenequipmodel_id");
    }

    public static DynamicObject getMaintenanceScheme(long customerId, long modelOneId) {
        QFilter[] filters = new QFilter[]{new QFilter("mrtype", "=", (Object)modelOneId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"fmm_overhaulscheme", (String)"customers.fbasedataid_id, entryentity.entryworkcard, entryentity.entryapplicablerule", (QFilter[])filters);
        if (cache.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject result = (DynamicObject)entry.getValue();
            DynamicObjectCollection customers = result.getDynamicObjectCollection("customers");
            for (DynamicObject customer : customers) {
                if (customerId != customer.getLong("fbasedataid_id")) continue;
                return result;
            }
        }
        return cache.values().toArray(new DynamicObject[0])[0];
    }

    public static void clearMatchResult(List<DynamicObject> workPackEntryCollection, boolean isContractWorkPackage) {
        for (DynamicObject workPackageEntry : workPackEntryCollection) {
            workPackageEntry.set("jobcard_id", null);
            workPackageEntry.set("jobcard", null);
            workPackageEntry.set("jobcardtitle", null);
            workPackageEntry.set("workcategory_id", null);
            workPackageEntry.set("programno", null);
            String fieldSource = workPackageEntry.getString("fieldsource");
            if ("automatic".equals(fieldSource)) {
                workPackageEntry.set("auxiliarycode", null);
            }
            if (isContractWorkPackage) {
                workPackageEntry.set("programhours", null);
                workPackageEntry.set("workcardhours", null);
            } else {
                workPackageEntry.set("riskjobcard", null);
                workPackageEntry.set("isfirstexecute", null);
                workPackageEntry.set("outsource", null);
            }
            workPackageEntry.set("pagination", null);
            workPackageEntry.set("ismultipage", null);
        }
    }

    public static void fillJobCardInfo(DynamicObject workPackageEntry, DynamicObject jobCard, boolean isContractWorkPackage) {
        workPackageEntry.set("jobcard_id", jobCard.getPkValue());
        workPackageEntry.set("jobcard", (Object)jobCard);
        workPackageEntry.set("jobcardtitle", jobCard.get("cardname"));
        workPackageEntry.set("workcategory_id", jobCard.get("group_id"));
        workPackageEntry.set("programno", jobCard.get("refwordcard.number"));
        String auxiliaryCode = workPackageEntry.getString("auxiliarycode");
        if (StringUtils.isBlank((CharSequence)auxiliaryCode)) {
            workPackageEntry.set("auxiliarycode", jobCard.get("cardnumid"));
            workPackageEntry.set("fieldsource", (Object)"automatic");
        }
        if (isContractWorkPackage) {
            workPackageEntry.set("programhours", jobCard.get("refwordcard.totalhours"));
        } else {
            workPackageEntry.set("riskjobcard", jobCard.get("riskcard"));
            workPackageEntry.set("isfirstexecute", jobCard.get("firstexe"));
            workPackageEntry.set("outsource", jobCard.get("isom"));
        }
        DynamicObjectCollection pageCollection = jobCard.getDynamicObjectCollection("pageentity");
        int pageSize = pageCollection.size();
        workPackageEntry.set("ismultipage", (Object)(pageSize > 1 ? 1 : 0));
        if (pageSize == 1) {
            DynamicObject pageEntryEntity = (DynamicObject)pageCollection.get(0);
            workPackageEntry.set("pagination", pageEntryEntity.get("pageseq"));
            if (isContractWorkPackage) {
                workPackageEntry.set("workcardhours", pageEntryEntity.get("pagesumhours"));
            }
        } else {
            workPackageEntry.set("pagination", null);
            if (isContractWorkPackage) {
                workPackageEntry.set("workcardhours", null);
            }
        }
    }

    public static List<Object> listExecuteWorkPackageId(Object executeWorkPackageId) {
        return QueryServiceHelper.queryPrimaryKeys((String)"pmpd_exec_workpack", (QFilter[])new QFilter[]{new QFilter("manageid", "=", executeWorkPackageId)}, null, (int)-1);
    }

    public static List<Object> listExecuteWorkPackagePaginationId(List<Object> executeWorkPackageIdList) {
        return executeWorkPackageIdList.isEmpty() ? Collections.emptyList() : QueryServiceHelper.queryPrimaryKeys((String)"pmpd_pagination_selector", (QFilter[])new QFilter[]{new QFilter("workpackageid", "in", executeWorkPackageIdList)}, (String)"id", (int)-1);
    }

    /*
     * Exception decompiling
     */
    public static int getMaxSequenceNumber(long executeWorkPackManageId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean checkInternalWorkCard(DynamicObject workCard, long customerId, long modelMpdOneId) {
        long workCardCustomerId = workCard.getLong("customer_id");
        boolean checkCustomer = true;
        if (workCardCustomerId != 0L) {
            checkCustomer = customerId == workCardCustomerId;
        }
        boolean checkModelMpdOne = true;
        long workCardModelMpdOneId = workCard.getLong("materialtype_id");
        if (workCardModelMpdOneId != 0L) {
            checkModelMpdOne = modelMpdOneId == workCardModelMpdOneId;
        }
        return checkCustomer && checkModelMpdOne;
    }

    public static boolean checkCustomerWorkCardStatus(String status) {
        return "revision".equals(status) || "cancel".equals(status);
    }

    public static void updateExecuteWorkPackManageHeader(long executeWorkPackageManageId, WorkPackageProjectInfo workPackageManageProjectInfo) {
        if (workPackageManageProjectInfo != null) {
            MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack_manage");
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt, (Object)executeWorkPackageManageId);
            dynamicObject.set("checktype_id", (Object)workPackageManageProjectInfo.getCheckTypeId());
            dynamicObject.set("workscope_id", (Object)workPackageManageProjectInfo.getWorkScopeId());
            dynamicObject.set("estimatedentrytime", (Object)workPackageManageProjectInfo.getEstimateApproachTime());
            DataEntityState dataEntityState = dynamicObject.getDataEntityState();
            dataEntityState.setDirty((ISimpleProperty)dt.getProperty("checktype_id"), true);
            dataEntityState.setDirty((ISimpleProperty)dt.getProperty("workscope_id"), true);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static WorkPackageProjectInfo updateExecuteWorkPackManageHeader(long executeWorkPackageManageId) {
        List<Object> projectIds = WorkPackageUtils.listProjectIdByExecuteWorkPakcageManageId(executeWorkPackageManageId);
        WorkPackageProjectInfo workPackageProjectInfo = null;
        int size = projectIds.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            workPackageProjectInfo = WorkPackageUtils.getWorkPackageProjectInfo((Long)projectIds.get(0));
            WorkPackageUtils.updateExecuteWorkPackManageHeader(executeWorkPackageManageId, workPackageProjectInfo);
        } else {
            long mainProjectId = WorkPackageUtils.getMainProjectId(projectIds);
            WorkPackageUtils.updateExecuteWorkPackManageHeader(executeWorkPackageManageId, WorkPackageUtils.getWorkPackageProjectInfo(mainProjectId));
        }
        return workPackageProjectInfo;
    }

    public static void addInternalWorkCard(long projectId, long jobCardId, DynamicObject workCard, DynamicObjectCollection collection) {
        DynamicObject inernalJobCardEntry = collection.addNew();
        inernalJobCardEntry.set("seq", (Object)collection.size());
        inernalJobCardEntry.set("internal_project_id", (Object)projectId);
        inernalJobCardEntry.set("internal_jobcard_id", (Object)jobCardId);
        DynamicObjectCollection pageEntryCollection = workCard.getDynamicObjectCollection("pageentity");
        if (!pageEntryCollection.isEmpty()) {
            inernalJobCardEntry.set("internal_pagination", (Object)((DynamicObject)pageEntryCollection.get(0)).getString("pageseq"));
        }
    }

    public static boolean verifyContinuity(List<Integer> numbers) {
        if (CollectionUtils.isEmpty(numbers)) {
            return true;
        }
        if (numbers.size() == 1) {
            return true;
        }
        numbers.sort(Integer::compareTo);
        int maxIndex = numbers.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            if (i == maxIndex) {
                return true;
            }
            if (numbers.get(i + 1) - numbers.get(i) == 1) continue;
            return false;
        }
        return true;
    }
}

