/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.util;

import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;

public class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String validateBaseRef(DynamicObject[] dataEntities) {
        String entityNameF7 = "";
        if (dataEntities.length > 0) {
            entityNameF7 = dataEntities[0].getDataEntityType().getName();
        }
        return CommonUtils.validateBaseRef(dataEntities, entityNameF7);
    }

    public static String validateBaseRef(DynamicObject[] dataEntities, String entityNameF7) {
        String error = "";
        int length = dataEntities.length;
        if (entityNameF7.length() == 0) {
            return error;
        }
        for (int i = 0; i < length; ++i) {
            MainEntityType refMainType;
            String extendName;
            DynamicObject dataObj = dataEntities[i];
            Object idValue = dataObj.getPkValue();
            String entityName = dataObj.getDataEntityType().getName();
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            checker.setDraftValidReference(true);
            BaseDataCheckRefrenceResult refrenceResult = checker.checkRef((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityNameF7), idValue);
            if (!refrenceResult.isRefence() || StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)(extendName = (refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey())).getExtendName()))) continue;
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (!(property instanceof IFieldHandle) || !StringUtils.equals((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) continue;
                fieldName = ((IFieldHandle)property).getDisplayName().toString();
                break;
            }
            error = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff1a[%1$s]\u7684\u5b57\u6bb5[%2$s]\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e", (String)"CommonUtils_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), billName, fieldName);
            return error;
        }
        return error;
    }

    public static String getSelects(String ... vals) {
        if (vals != null && vals.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                sb.append(vals[i]);
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }
}

