/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmpd.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pmpd.mservice.api.ISimilarProjectService;
import kd.pmc.pmpd.common.helper.SimilarPrjCalcParams;
import kd.pmc.pmps.business.task.helper.SimilarTaskHelper;
import kd.pmc.pmps.business.task.helper.SmlarProjRecsHelper;
import kd.pmc.pmps.business.task.model.TaskRunTimeInfo;
import kd.pmc.pmps.business.task.step.AbstractRunnerStep;
import kd.pmc.pmps.business.task.step.impl.CalcDataCheckStep;
import kd.pmc.pmps.business.task.step.impl.PrepareExcuteDataStep;
import kd.pmc.pmps.business.task.step.impl.getSimilarPjExcute;

public class SimilarProjectServiceImpl
implements ISimilarProjectService {
    public Map<String, String> getSimilarProject(Long objId, Long sechmeId) {
        DynamicObject sechmeObj = BusinessDataServiceHelper.loadSingle((Object)sechmeId, (String)"pmpd_similarproject");
        if (Objects.isNull(sechmeObj)) {
            return this.hasErrorResult(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u76f8\u4f3c\u9879\u76ee\u65b9\u6848\u3002", (String)"SimilarProjectServiceImpl_0", (String)"mmc-pmpd-mservice", (Object[])new Object[0]));
        }
        DynamicObject entityobject = sechmeObj.getDynamicObject("entityobject");
        DynamicObject sourObj = BusinessDataServiceHelper.loadSingle((Object)objId, (String)entityobject.getString("number"));
        if (Objects.isNull(sourObj)) {
            return this.hasErrorResult(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636e\u5bf9\u8c61\u3002", (String)"SimilarProjectServiceImpl_1", (String)"mmc-pmpd-mservice", (Object[])new Object[0]));
        }
        DynamicObjectCollection mainelements = sechmeObj.getDynamicObjectCollection("mainelement");
        DynamicObjectCollection holdelement = sechmeObj.getDynamicObjectCollection("holdelement");
        if (mainelements.isEmpty() && holdelement.isEmpty()) {
            return this.hasErrorResult(ResManager.loadKDString((String)"\u76f8\u4f3c\u9879\u76ee\u65b9\u6848,\u4e3b\u8981\u7d20\u4e0e\u9608\u503c\u8981\u7d20\u5206\u5f55\u5fc5\u987b\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"SimilarProjectServiceImpl_2", (String)"mmc-pmpd-mservice", (Object[])new Object[0]));
        }
        for (DynamicObject e : mainelements) {
            if (!e.getBoolean("isuseable")) continue;
            HashMap entityfieldprop = (HashMap)SerializationUtils.fromJsonString((String)e.getString("entityfieldprop"), Map.class);
            String exp = (String)entityfieldprop.get("expression");
            exp = exp.replace("model.", "");
            DynamicObjectCollection dycolls = QueryServiceHelper.query((String)entityobject.getString("number"), (String)exp, (QFilter[])new QFilter("id", "=", (Object)objId).toArray());
            if (!dycolls.isEmpty()) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u8c61\u4e2d\u5b57\u6bb5\u3010%s\u3011\u7684\u503c\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5b57\u6bb5\u503c\u6216\u8c03\u6574\u76f8\u4f3c\u9879\u76ee\u65b9\u6848\u3002", (String)"SimilarProjectServiceImpl_3", (String)"mmc-pmpd-mservice", (Object[])new Object[0]), e.getString("entityfield"));
            return this.hasErrorResult(msg);
        }
        return this.calSimilarProject(sourObj, sechmeObj);
    }

    private Map<String, String> calSimilarProject(DynamicObject sourObj, DynamicObject sechmeObj) {
        SimilarPrjCalcParams param = new SimilarPrjCalcParams(sechmeObj);
        long billid = sourObj.getLong("id");
        this.addLog(param, sourObj);
        TaskRunTimeInfo ctx = this.getRunTimeInfo(param, billid);
        DynamicObject detailObject = SmlarProjRecsHelper.getDetailObject((TaskRunTimeInfo)ctx);
        ctx.setDetailObject(detailObject);
        SimilarTaskHelper.hasBeginning((TaskRunTimeInfo)ctx);
        ArrayList<Object> steps = new ArrayList<Object>(8);
        CalcDataCheckStep checker = new CalcDataCheckStep(ctx, param);
        steps.add(checker);
        PrepareExcuteDataStep excureFilter = new PrepareExcuteDataStep(ctx, param);
        steps.add(excureFilter);
        getSimilarPjExcute getSimilarPjStep = new getSimilarPjExcute(ctx, param);
        steps.add(getSimilarPjStep);
        for (int i = 0; i < steps.size(); ++i) {
            AbstractRunnerStep step = (AbstractRunnerStep)steps.get(i);
            step.execute();
            if (ctx.isStop()) break;
        }
        SimilarTaskHelper.hasComplete((TaskRunTimeInfo)ctx);
        return this.isSuccess(detailObject);
    }

    private Map<String, String> isSuccess(DynamicObject detailObject) {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("status", "success");
        resultMap.put("msg", ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"SimilarProjectServiceImpl_4", (String)"mmc-pmpd-mservice", (Object[])new Object[0]));
        DynamicObjectCollection smlarprojects = detailObject.getDynamicObjectCollection("smlarproject");
        ArrayList projects = Lists.newArrayList();
        for (DynamicObject entry : smlarprojects) {
            Long projectId = entry.getLong("project");
            projects.add(projectId);
        }
        resultMap.put("result", SerializationUtils.toJsonString((Object)projects));
        return resultMap;
    }

    private void addLog(SimilarPrjCalcParams param, DynamicObject sourObj) {
        DynamicObject caculateLog = this.createNewLog(param);
        param.setCallogId(caculateLog.getPkValue() == null ? 0L : Long.parseLong(caculateLog.getPkValue().toString()));
        DynamicObjectCollection caculateLogEntrys = caculateLog.getDynamicObjectCollection("entry");
        caculateLogEntrys.clear();
        boolean isbill = sourObj.getDynamicObjectType().getProperties().stream().anyMatch(p -> StringUtils.equals((CharSequence)p.getName(), (CharSequence)"billno"));
        String number = "";
        number = isbill ? sourObj.getString("billno") : sourObj.getString("number");
        DynamicObject projRecsList = this.createNewSmlPjList(param, sourObj.getLong("id"), number);
        DynamicObject logEntry = caculateLogEntrys.addNew();
        logEntry.set("entityid", (Object)sourObj.getLong("id"));
        logEntry.set("billno", (Object)number);
        logEntry.set("calresult", (Object)projRecsList.getString("billno"));
        logEntry.set("calresultid", (Object)projRecsList.getLong("id"));
        projRecsList.set("taskid", (Object)"");
        logEntry.set("taskid", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{caculateLog});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projRecsList});
    }

    private DynamicObject createNewSmlPjList(SimilarPrjCalcParams calcParams, Long billId, String number) {
        ORM orm = ORM.create();
        DynamicObject projRecsList = orm.newDynamicObject("pmpd_smlarprojrecs");
        Long logId = orm.genLongId("pmpd_smlarprojrecs");
        String projListNumber = CodeRuleServiceHelper.getNumber((String)"pmpd_smlarprojrecs", (DynamicObject)projRecsList, (String)String.valueOf(calcParams.getProjectOrgId()));
        projRecsList.set("id", (Object)logId);
        projRecsList.set("billno", (Object)projListNumber);
        projRecsList.set("billstatus", (Object)"A");
        projRecsList.set("entityobject", (Object)calcParams.getEntityObj());
        projRecsList.set("entityno", (Object)number);
        projRecsList.set("entityid", (Object)billId);
        projRecsList.set("sourcetype", (Object)"A");
        projRecsList.set("projectorg", (Object)calcParams.getProjectOrgId());
        projRecsList.set("org", (Object)calcParams.getProjectOrgId());
        projRecsList.set("creator", (Object)RequestContext.get().getCurrUserId());
        projRecsList.set("createtime", (Object)System.currentTimeMillis());
        projRecsList.set("calclog", (Object)calcParams.getCallogId());
        projRecsList.set("similarprojct", (Object)calcParams.getSimilarProject());
        return projRecsList;
    }

    private Map<String, String> hasErrorResult(String msg) {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("status", "failure");
        resultMap.put("msg", msg);
        resultMap.put("result", "");
        return resultMap;
    }

    private DynamicObject createNewLog(SimilarPrjCalcParams calcParams) {
        ORM orm = ORM.create();
        long currentTimeMillis = System.currentTimeMillis();
        long currentUserid = RequestContext.get().getCurrUserId();
        DynamicObject caculateLog = orm.newDynamicObject("pmpd_calcsimilar_log");
        Long logId = orm.genLongId("pmpd_calcsimilar_log");
        String number = CodeRuleServiceHelper.getNumber((String)"pmpd_calcsimilar_log", (DynamicObject)caculateLog, (String)String.valueOf(calcParams.getProjectOrgId()));
        if (StringUtils.isEmpty((CharSequence)number)) {
            number = ID.genStringId();
        }
        caculateLog.set("id", (Object)logId);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createtime", (Object)currentTimeMillis);
        caculateLog.set("similarprojct", (Object)calcParams.getSimilarProject());
        caculateLog.set("entityobject", (Object)calcParams.getEntityObj());
        caculateLog.set("calstatus", (Object)"A");
        caculateLog.set("creator", (Object)currentUserid);
        caculateLog.set("projectorg", (Object)calcParams.getProjectOrgId());
        caculateLog.set("createorg", (Object)calcParams.getProjectOrgId());
        caculateLog.set("starttime", (Object)currentTimeMillis);
        caculateLog.set("status", (Object)"A");
        caculateLog.set("enable", (Object)"1");
        return caculateLog;
    }

    private TaskRunTimeInfo getRunTimeInfo(SimilarPrjCalcParams param, Long billId) {
        String entityObjectid = param.getEntityObj();
        long entityid = billId;
        long callogid = param.getCallogId();
        long orgid = param.getProjectOrgId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("pmpd");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName("Pmpd SimilarProject Schedule");
        String objId = UUID.randomUUID().toString();
        jobInfo.setId(objId);
        jobInfo.setRunByLang(Lang.get());
        String taskId = JobClient.dispatch((JobInfo)jobInfo);
        return new TaskRunTimeInfo(taskId, entityObjectid, entityid, callogid, orgid);
    }
}

