/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmpd.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.pmpd.mservice.api.WorkPackageService;
import kd.mmc.pmpd.mservice.util.ResponseUtils;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import org.apache.commons.collections4.CollectionUtils;

public class WorkPackageServiceImpl
implements WorkPackageService {
    private static final Log LOG = LogFactory.getLog(WorkPackageServiceImpl.class);

    public Map<String, Object> getWorkCardByProject(Set<Long> projectIds, Map<String, Object> customParams) {
        String selectFields;
        if (CollectionUtils.isEmpty(projectIds)) {
            return ResponseUtils.fail(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u9879\u76ee\u53f7\u4e3a\u7a7a\u3002", (String)"WorkPackageServiceImpl_0", (String)"mmc-pmpd-mservice", (Object[])new Object[0]));
        }
        LOG.info("[WorkPackageService]Start to execute getWorkCardByProject. projectIds: {}, customParams: {}");
        if (customParams == null) {
            customParams = new HashMap<String, Object>(16);
        }
        HashMap<Long, Object> result = new HashMap<Long, Object>(16);
        if (ObjectConverterWrapper.getBoolean((Object)customParams.getOrDefault("includeWorkPackWorkCard", true)).booleanValue()) {
            selectFields = "project, entryentity.jobcard";
            this.getWorkPackInfo("pmpd_exec_workpack", selectFields, this.getExecuteWorkPackFilters(projectIds), result, this::processWorkCardQueryResult);
        }
        if (ObjectConverterWrapper.getBoolean((Object)customParams.get("includePanelWorkCard")).booleanValue()) {
            selectFields = "entry_panel_jobcard.panel_project, entry_panel_jobcard.panel_jobcard";
            this.getWorkPackInfo("pmpd_exec_workpack_manage", selectFields, this.getPanelWorkCardFilters(projectIds), result, this::processWorkCardQueryResult);
        }
        if (ObjectConverterWrapper.getBoolean((Object)customParams.get("includeInternalWorkCard")).booleanValue()) {
            selectFields = "entry_internal_jobcard.internal_project, entry_internal_jobcard.internal_jobcard";
            this.getWorkPackInfo("pmpd_exec_workpack_manage", selectFields, this.getInternalWorkCardFilters(projectIds), result, this::processWorkCardQueryResult);
        }
        return ResponseUtils.success(result);
    }

    public Map<String, Object> getWorkCardAndWorkOrderByProject(Set<Long> projectIds, Map<String, Object> customParams) {
        String selectFields;
        if (CollectionUtils.isEmpty(projectIds)) {
            return ResponseUtils.fail(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u9879\u76ee\u53f7\u4e3a\u7a7a\u3002", (String)"WorkPackageServiceImpl_0", (String)"mmc-pmpd-mservice", (Object[])new Object[0]));
        }
        LOG.info("[WorkPackageService]Start to execute getWorkCardAndWorkOrderByProject.  projectIds: {}, customParams: {}");
        if (customParams == null) {
            customParams = new HashMap<String, Object>(16);
        }
        Boolean returnWorkOrderNo = ObjectConverterWrapper.getBoolean((Object)customParams.get("returnWorkOrderNo"));
        HashMap<Long, Object> result = new HashMap<Long, Object>(16);
        if (ObjectConverterWrapper.getBoolean((Object)customParams.getOrDefault("includeWorkPackWorkCard", true)).booleanValue()) {
            selectFields = "project, entryentity.jobcard workCardId, entryentity.jobid workOrderId";
            if (returnWorkOrderNo.booleanValue()) {
                selectFields = selectFields + ", entryentity.jobno workOrderNo";
            }
            this.getWorkPackInfo("pmpd_exec_workpack", selectFields, this.getExecuteWorkPackFilters(projectIds), result, this::processWorkCardAndWorkOrderQueryResult);
        }
        if (ObjectConverterWrapper.getBoolean((Object)customParams.get("includePanelWorkCard")).booleanValue()) {
            selectFields = "entry_panel_jobcard.panel_project, entry_panel_jobcard.panel_jobcard workCardId, entry_panel_jobcard.panel_jobid workOrderId";
            if (returnWorkOrderNo.booleanValue()) {
                selectFields = selectFields + ", entry_panel_jobcard.panel_jobno workOrderNo";
            }
            this.getWorkPackInfo("pmpd_exec_workpack_manage", selectFields, this.getPanelWorkCardFilters(projectIds), result, this::processWorkCardAndWorkOrderQueryResult);
        }
        if (ObjectConverterWrapper.getBoolean((Object)customParams.get("includeInternalWorkCard")).booleanValue()) {
            selectFields = "entry_internal_jobcard.internal_project, entry_internal_jobcard.internal_jobcard workCardId, entry_internal_jobcard.internal_jobid workOrderId";
            if (returnWorkOrderNo.booleanValue()) {
                selectFields = selectFields + ", entry_internal_jobcard.internal_jobno workOrderNo";
            }
            this.getWorkPackInfo("pmpd_exec_workpack_manage", selectFields, this.getInternalWorkCardFilters(projectIds), result, this::processWorkCardAndWorkOrderQueryResult);
        }
        return ResponseUtils.success(result);
    }

    private QFilter[] getExecuteWorkPackFilters(Set<Long> projectIds) {
        return new QFilter[]{new QFilter("project", "in", projectIds)};
    }

    private QFilter[] getPanelWorkCardFilters(Set<Long> projectIds) {
        QFilter[] filters = new QFilter[]{new QFilter("entry_panel_jobcard.panel_project", "in", projectIds)};
        return filters;
    }

    private QFilter[] getInternalWorkCardFilters(Set<Long> projectIds) {
        QFilter[] filters = new QFilter[]{new QFilter("entry_internal_jobcard.internal_project", "in", projectIds)};
        return filters;
    }

    private void getWorkPackInfo(String entityNumber, String selectFields, QFilter[] filters, Map<Long, Object> result, BiConsumer<DataSet, Map<Long, Object>> consumer) {
        try (DataSet dataSet = ORM.create().queryDataSet("WorkPackageServiceImpl.getWorkPackInfo", entityNumber, selectFields, filters);){
            if (consumer != null) {
                consumer.accept(dataSet, result);
            }
        }
    }

    private void processWorkCardQueryResult(DataSet dataSet, Map<Long, Object> result) {
        for (Row row : dataSet) {
            Long workCardId = ObjectConverterWrapper.getLong((Object)row.get(1));
            if (workCardId == 0L) continue;
            Set wordCardIdSet = (Set)result.computeIfAbsent(row.getLong(0), k -> new HashSet(16));
            wordCardIdSet.add(workCardId);
        }
    }

    private void processWorkCardAndWorkOrderQueryResult(DataSet dataSet, Map<Long, Object> result) {
        List extraFieldNames = Arrays.stream(dataSet.getRowMeta().getFieldNames()).skip(3L).collect(Collectors.toList());
        int extraFieldSize = extraFieldNames.size();
        for (Row row : dataSet) {
            Long workCardId = ObjectConverterWrapper.getLong((Object)row.get(1));
            if (workCardId == 0L) continue;
            Long workOrderId = ObjectConverterWrapper.getLong((Object)row.get(2));
            List returnDataList = (List)result.computeIfAbsent(row.getLong(0), k -> new ArrayList(10));
            HashMap returnDataMap = Maps.newHashMapWithExpectedSize((int)extraFieldSize);
            returnDataMap.put("workCardId", workCardId);
            returnDataMap.put("workOrderId", workOrderId);
            for (String extraFieldName : extraFieldNames) {
                returnDataMap.put(extraFieldName, row.get(extraFieldName));
            }
            returnDataList.add(returnDataMap);
        }
    }
}

