/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmpd.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pmpd.mservice.api.WorkingHourService;
import kd.mmc.pmpd.mservice.util.ResponseUtils;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.business.workhour.WorkHourEstimateHelper;
import kd.pmc.pmpd.business.workhour.WorkHourHelper;
import kd.pmc.pmpd.business.workhour.WorkHourTemplateHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.model.DailySummaryResult;
import kd.pmc.pmpd.common.model.EstimateContext;
import org.apache.commons.collections4.CollectionUtils;

public class WorkingHourServiceImpl
implements WorkingHourService {
    private static final Log LOG = LogFactory.getLog(WorkingHourServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> reestimate(List<String> resourcePlanNos, Map<String, Object> params) {
        LOG.info("[WorkingHourServiceImpl]resourcePlanNos: {}. params: {}", resourcePlanNos, params);
        if (CollectionUtils.isEmpty(resourcePlanNos)) {
            return ResponseUtils.fail("ResourcePlanNos is empty.");
        }
        List<Object> workHourEstimateBillIds = this.getWorkHourEstimateBillIds(resourcePlanNos);
        if (CollectionUtils.isEmpty(workHourEstimateBillIds)) {
            return ResponseUtils.fail("WorkHourEstimateBillIds is empty.");
        }
        int totalCount = workHourEstimateBillIds.size();
        Boolean writebackToResourcePlan = ObjectConverterWrapper.getBoolean((Object)params.getOrDefault("writebackToResourcePlan", Boolean.FALSE));
        Object[] resourcePlans = this.loadResourcePlan(resourcePlanNos, writebackToResourcePlan);
        if (ArrayUtils.isEmpty((Object[])resourcePlans)) {
            return ResponseUtils.fail("ResourcePlans is empty.");
        }
        Object[] ids = workHourEstimateBillIds.toArray();
        if (ObjectConverterWrapper.getBoolean((Object)params.getOrDefault("updateStandardWorkHour", Boolean.FALSE)).booleanValue()) {
            OperationServiceHelper.executeOperate((String)"getstandardworkhour", (String)"pmpd_hour_estimate", (Object[])ids, (OperateOption)OperateOption.create());
        }
        if (ObjectConverterWrapper.getBoolean((Object)params.getOrDefault("updateReportWorkHour", Boolean.FALSE)).booleanValue()) {
            WorkHourHelper.updateReportWorkHour((List)Lists.newArrayList(workHourEstimateBillIds));
        }
        Boolean calculateEstimateWorkHour = ObjectConverterWrapper.getBoolean((Object)params.getOrDefault("calculateEstimateWorkHour", Boolean.TRUE));
        Boolean calculateStandardWorkHour = ObjectConverterWrapper.getBoolean((Object)params.getOrDefault("calculateStandardWorkHour", Boolean.TRUE));
        DynamicObject[] workHourEstimateBills = this.loadWorkHourEstimateBill(ids, calculateEstimateWorkHour, calculateStandardWorkHour);
        Map<String, List<DynamicObject>> resourcePlanMap = Arrays.stream(resourcePlans).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("billno")));
        try {
            this.reestimateByResourcePlan(workHourEstimateBills, resourcePlanMap, writebackToResourcePlan, calculateEstimateWorkHour, calculateStandardWorkHour);
        }
        finally {
            EstimateContext.remove();
        }
        int successCount = workHourEstimateBillIds.size();
        String successMsg = String.format("totalCount\uff1a%1$d\uff0csuccessCount\uff1a%2$d\uff0cfailCount\uff1a%3$d", totalCount, successCount, totalCount - successCount);
        return ResponseUtils.success(successMsg);
    }

    private void reestimateByResourcePlan(DynamicObject[] workHourEstimateBills, Map<String, List<DynamicObject>> resourcePlanMap, Boolean writebackToResourcePlan, Boolean calculateEstimateWorkHour, Boolean calculateStandardWorkHour) {
        EstimateContext estimateContext = EstimateContext.get();
        for (DynamicObject workHourEstimateBill : workHourEstimateBills) {
            try {
                BiConsumer<Date, DailySummaryResult> biConsumer;
                BigDecimal trt;
                Tuple tuple;
                String resourcePlanNo = workHourEstimateBill.getString("resourceplan");
                List<DynamicObject> resourcePlans = resourcePlanMap.get(resourcePlanNo);
                if (CollectionUtils.isEmpty(resourcePlans) || (tuple = (Tuple)resourcePlans.stream().filter(dynamicObject -> "0".equals(dynamicObject.getString("pulishstatus"))).map(dynamicObject -> new Tuple((Object)dynamicObject.getDate("preapproachtime"), (Object)dynamicObject.getBigDecimal("workrepaircycle"))).findFirst().orElse(null)) == null) continue;
                Date startTime = (Date)tuple.item1;
                if (startTime == null) {
                    LOG.info("[WorkingHourServiceImpl.reestimateByResourcePlan]startTime is null. estimatedBillId: {}", workHourEstimateBill.getPkValue());
                }
                if ((trt = (BigDecimal)tuple.item2).compareTo(BigDecimal.ZERO) == 0) {
                    LOG.info("[WorkingHourServiceImpl.reestimateByResourcePlan]trt = 0. estimatedBillId: {}", workHourEstimateBill.getPkValue());
                }
                DynamicObject stageWorkHourTemplate = workHourEstimateBill.getDynamicObject("stage_workhour");
                WorkHourTemplateHelper.resetContext((EstimateContext)estimateContext, (Date)startTime, (BigDecimal)trt, (DynamicObject)stageWorkHourTemplate, (DynamicObject)workHourEstimateBill);
                if (calculateEstimateWorkHour.booleanValue()) {
                    estimateContext.initEstimateContext();
                    biConsumer = null;
                    if (writebackToResourcePlan.booleanValue()) {
                        List<DynamicObjectCollection> estimateAllEntryData = this.getAllEntryData(resourcePlans, "entry_workhour");
                        this.clearEntryData(estimateAllEntryData);
                        biConsumer = (date, dailySummaryResult) -> this.writeBackEstimateWorkHourData(estimateAllEntryData, (Date)date, (DailySummaryResult)dailySummaryResult);
                    }
                    WorkHourEstimateHelper.estimateWorkHour((boolean)true, (DynamicObject)workHourEstimateBill, biConsumer);
                }
                if (!calculateStandardWorkHour.booleanValue()) continue;
                estimateContext.initStandardContext();
                biConsumer = null;
                if (writebackToResourcePlan.booleanValue()) {
                    List<DynamicObjectCollection> standardAllEntryData = this.getAllEntryData(resourcePlans, "entry_standard_workhour");
                    this.clearEntryData(standardAllEntryData);
                    biConsumer = (date, dailySummaryResult) -> this.writeBackStandardWorkHourData(standardAllEntryData, (Date)date, (DailySummaryResult)dailySummaryResult);
                }
                WorkHourEstimateHelper.estimateWorkHour((boolean)false, (DynamicObject)workHourEstimateBill, biConsumer);
            }
            catch (Exception exception) {
                String workHourEsitmateBillNo = workHourEstimateBill.getString("billno");
                throw new KDBizException((Throwable)exception, new ErrorCode("mmc.pmpd.workingHourServiceExecption", String.format(ResManager.loadKDString((String)"\u91cd\u7b97[%1$s->%2$s]\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"WorkingHourServiceImpl_0", (String)"mmc-pmpd-mservice", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((String)"pmpd_hour_estimate"), workHourEsitmateBillNo)), new Object[0]);
            }
        }
        this.saveData(workHourEstimateBills, resourcePlanMap, writebackToResourcePlan);
    }

    private void clearEntryData(List<DynamicObjectCollection> allEntryData) {
        for (DynamicObjectCollection collection : allEntryData) {
            collection.clear();
        }
    }

    private List<DynamicObjectCollection> getAllEntryData(List<DynamicObject> resourcePlans, String entryKey) {
        ArrayList allEntryData = Lists.newArrayListWithExpectedSize((int)resourcePlans.size());
        for (DynamicObject resourcePlan : resourcePlans) {
            allEntryData.add(resourcePlan.getDynamicObjectCollection(entryKey));
        }
        return allEntryData;
    }

    private void saveData(DynamicObject[] workHourEstimateBills, Map<String, List<DynamicObject>> resourcePlanMap, Boolean writebackToResourcePlan) {
        if (writebackToResourcePlan.booleanValue()) {
            ArrayList resourcePlans = new ArrayList(10);
            for (Map.Entry<String, List<DynamicObject>> entry : resourcePlanMap.entrySet()) {
                resourcePlans.addAll(entry.getValue());
            }
            TXServiceHelper.executeWithTX((String)"pmpd-reestimateWorkHour", () -> {
                SaveServiceHelper.save((DynamicObject[])workHourEstimateBills);
                SaveServiceHelper.save((DynamicObject[])resourcePlans.toArray(new DynamicObject[0]));
            });
        } else {
            SaveServiceHelper.save((DynamicObject[])workHourEstimateBills);
        }
    }

    public void writeBackEstimateWorkHourData(List<DynamicObjectCollection> allEntryData, Date date, DailySummaryResult dailySummaryResult) {
        for (DynamicObjectCollection collection : allEntryData) {
            DynamicObject dynamicObject = collection.addNew();
            dynamicObject.set("seq", (Object)collection.size());
            dynamicObject.set("summary_date", (Object)date);
            dynamicObject.set("summary_workhour", (Object)dailySummaryResult.getWorkHour());
            dynamicObject.set("summary_earlyworkhour", (Object)dailySummaryResult.getEarlyWorkHour());
            dynamicObject.set("summary_midworkhour", (Object)dailySummaryResult.getMidWorkHour());
            dynamicObject.set("summary_lateworkhour", (Object)dailySummaryResult.getLateWorkHour());
        }
    }

    public void writeBackStandardWorkHourData(List<DynamicObjectCollection> allEntryData, Date date, DailySummaryResult dailySummaryResult) {
        for (DynamicObjectCollection collection : allEntryData) {
            DynamicObject dynamicObject = collection.addNew();
            dynamicObject.set("seq", (Object)collection.size());
            dynamicObject.set("standard_date", (Object)date);
            dynamicObject.set("standard_workhour", (Object)dailySummaryResult.getWorkHour());
            dynamicObject.set("standard_earlyworkhour", (Object)dailySummaryResult.getEarlyWorkHour());
            dynamicObject.set("standard_midworkhour", (Object)dailySummaryResult.getMidWorkHour());
            dynamicObject.set("standard_lateworkhour", (Object)dailySummaryResult.getLateWorkHour());
        }
    }

    private DynamicObject[] loadWorkHourEstimateBill(Object[] ids, Boolean calculateEstimateWorkHour, Boolean calculateStandardWorkHour) {
        HashSet selectFields = Sets.newHashSetWithExpectedSize((int)44);
        selectFields.add("billno");
        selectFields.add("resourceplan");
        selectFields.add("trt");
        selectFields.add("stage_workhour");
        selectFields.add("stage");
        selectFields.add("shiftsystem");
        if (calculateEstimateWorkHour.booleanValue()) {
            selectFields.add("industry_id");
            selectFields.add("industryone_id");
            selectFields.add("totalhours");
            selectFields.add("entryentity.subentryentity_stage.seq");
            selectFields.add("stage_percentage");
            selectFields.add("entryentity.subentryentity_daily.seq");
            selectFields.add("daily_industry_id");
            selectFields.add("daily_industryone_id");
            selectFields.add("daily_date");
            selectFields.add("daily_workhour");
            selectFields.add("daily_earlyworkhour");
            selectFields.add("daily_midworkhour");
            selectFields.add("daily_lateworkhour");
            selectFields.add("entryentity_summary.seq");
            selectFields.add("summary_date");
            selectFields.add("summary_workhour");
            selectFields.add("summary_earlyworkhour");
            selectFields.add("summary_midworkhour");
            selectFields.add("summary_lateworkhour");
        }
        if (calculateStandardWorkHour.booleanValue()) {
            selectFields.add("s_industry_id");
            selectFields.add("s_industryone_id");
            selectFields.add("s_totalhours");
            selectFields.add("s_entryentity.s_subentryentity_stage.seq");
            selectFields.add("s_stage_percentage");
            selectFields.add("s_entryentity.s_subentryentity_daily.seq");
            selectFields.add("s_daily_industry_id");
            selectFields.add("s_daily_industryone_id");
            selectFields.add("s_daily_date");
            selectFields.add("s_daily_workhour");
            selectFields.add("s_daily_earlyworkhour");
            selectFields.add("s_daily_midworkhour");
            selectFields.add("s_daily_lateworkhour");
            selectFields.add("s_entryentity_summary.seq");
            selectFields.add("s_summary_date");
            selectFields.add("s_summary_workhour");
            selectFields.add("s_summary_earlyworkhour");
            selectFields.add("s_summary_midworkhour");
            selectFields.add("s_summary_lateworkhour");
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_hour_estimate");
        EntityType subEntityType = dataEntityType.getSubEntityType((Collection)selectFields);
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)subEntityType);
    }

    private List<Object> getWorkHourEstimateBillIds(List<String> resourcePlanNos) {
        QFilter[] filters = new QFilter[]{new QFilter("resourceplan", "in", resourcePlanNos)};
        String selectFields = "id, effectivestatus";
        ArrayList<Object> ids = new ArrayList<Object>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"pmpd_hour_estimate", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dataSet) {
                if ("2".equals(row.getString(1))) continue;
                ids.add(row.get(0));
            }
        }
        return ids;
    }

    private DynamicObject[] loadResourcePlan(List<String> resourcePlanNos, Boolean writebackToResourcePlan) {
        String selectFields = "billno, pulishstatus, preapproachtime, workrepaircycle";
        if (writebackToResourcePlan.booleanValue()) {
            selectFields = selectFields + ", entry_workhour.seq, entry_workhour.summary_date, entry_workhour.summary_workhour, entry_workhour.summary_earlyworkhour, entry_workhour.summary_midworkhour, entry_workhour.summary_lateworkhour, entry_standard_workhour.seq, entry_standard_workhour.standard_date, entry_standard_workhour.standard_workhour, entry_standard_workhour.standard_earlyworkhour, entry_standard_workhour.standard_midworkhour, entry_standard_workhour.standard_lateworkhour";
        }
        QFilter[] filters = new QFilter[]{new QFilter("billno", "in", resourcePlanNos)};
        return BusinessDataServiceHelper.load((String)"pmpd_resourceplan", (String)selectFields, (QFilter[])filters);
    }
}

