/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmpd.mservice.event;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pmpd.mservice.util.ResponseUtils;

public class WorkingHourEventServicePlugin
implements IEventServicePlugin {
    private static final Log LOG = LogFactory.getLog(WorkingHourEventServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        if (evt instanceof EntityEvent) {
            EntityEvent entityEvent = (EntityEvent)evt;
            List<Long> workOrderIds = entityEvent.getBusinesskeys().stream().map(Long::parseLong).collect(Collectors.toList());
            Set<Object> projectIds = this.getProjectFromWorkOrder(workOrderIds);
            List<String> resourcePlanNos = this.getResourcePlanFromProject(projectIds);
            if (resourcePlanNos.isEmpty()) {
                LOG.info("ResourcePlanNos is empty.");
                return ResponseUtils.fail("[WorkingHourEventServicePlugin]ResourcePlanNos is empty.");
            }
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
            customParams.put("updateStandardWorkHour", Boolean.TRUE);
            customParams.put("calculateStandardWorkHour", Boolean.TRUE);
            customParams.put("writebackToResourcePlan", Boolean.TRUE);
            Object result = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"WorkingHourService", (String)"reestimate", (Object[])new Object[]{resourcePlanNos, customParams});
            LOG.info("[WorkingHourEventServicePlugin] result: {}", result);
            return result;
        }
        return evt.toString();
    }

    private List<String> getResourcePlanFromProject(Set<Object> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(10);
        String selectFields = "billno, executestatus";
        QFilter[] filters = new QFilter[]{new QFilter("entry_project.projcet", "in", projectIds)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"pmpd_resourceplan", (String)selectFields, (QFilter[])filters, null);){
            if (dataSet.isEmpty()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            for (Row row : dataSet) {
                String executeStatus = row.getString(1);
                if ("3".equals(executeStatus) || "4".equals(executeStatus)) continue;
                result.add(row.getString(0));
            }
        }
        return result;
    }

    private Set<Object> getProjectFromWorkOrder(List<Long> workOrderIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", workOrderIds)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"pom_mroorder", (String)"treeentryentity.project", (QFilter[])filters, null);){
            if (dataSet.isEmpty()) {
                Set<Object> set = Collections.emptySet();
                return set;
            }
            HashSet<Object> projectIds = new HashSet<Object>(16);
            for (Row row : dataSet) {
                projectIds.add(row.get(0));
            }
            HashSet<Object> hashSet = projectIds;
            return hashSet;
        }
    }
}

