/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.formplugin.base.humanresources;

import java.util.HashSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmbd.common.util.EnterpriseHumanResourcePoolUtils;
import kd.pmc.pmbd.common.util.ProjectHumanResourcePlanningUtil;

public class ProjectHumanResourcePlanningList
extends AbstractListPlugin {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operateKey = evt.getOperationKey();
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        if ("distribution".equals(operateKey)) {
            this.distribution(selectedRows, evt);
        }
    }

    private void distribution(ListSelectedRowCollection selectedRows, BeforeItemClickEvent evt) {
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ProjectHumanResourcePlanningList_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        HashSet<Long> keys = new HashSet<Long>(1);
        for (Object key : selectedRows.getPrimaryKeyValues()) {
            keys.add(Long.parseLong(key.toString()));
        }
        if (keys.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\uff0c\u6bcf\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u8fdb\u884c\u5206\u914d\u3002", (String)"ProjectHumanResourcePlanningList_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        Long id = (Long)keys.iterator().next();
        String selectFields = EnterpriseHumanResourcePoolUtils.getSelects((String[])new String[]{"administrators", "creator", "roleadministrators"});
        QFilter idsFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dyncObj = BusinessDataServiceHelper.loadSingle((String)"pmbd_project_hm_res_pl1", (String)selectFields, (QFilter[])new QFilter[]{idsFilter});
        DynamicObject creator = dyncObj.getDynamicObject("creator");
        DynamicObjectCollection administrators = dyncObj.getDynamicObjectCollection("administrators");
        DynamicObjectCollection roleEntityColl = dyncObj.getDynamicObjectCollection("entryentity");
        String error = this.isAuthority(roleEntityColl, creator, administrators);
        if (error != null) {
            this.getView().showTipNotification(error, Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        this.showLogForm(id);
    }

    private void showLogForm(long id) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("pmbd_project_hm_res_pl1");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("distribution", (Object)"distribution");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmbd_project_hm_res_pl1"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.getView().invokeOperation("refresh");
    }

    private String isAuthority(DynamicObjectCollection roleEntityColl, DynamicObject creator, DynamicObjectCollection administrators) {
        String userId = RequestContext.get().getUserId();
        if (!ProjectHumanResourcePlanningUtil.isAuthority((String)userId, (DynamicObject)creator) && !ProjectHumanResourcePlanningUtil.isAuthority((String)userId, (DynamicObjectCollection)administrators) && ProjectHumanResourcePlanningUtil.getIsRoleAdministrators((DynamicObjectCollection)roleEntityColl, (String)userId).isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7528\u6237\u3010%s\u3011\u4e0d\u662f\u8d1f\u8d23\u4eba,\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"ProjectHumanResourcePlanningList_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName()));
            return errorMsg.toString();
        }
        return null;
    }
}

