/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ResourcePlanReleaseSettingEdit
extends AbstractFormPlugin {
    private static final String FIELD = "field";
    private static final String FIELDNAME = "fieldname";
    private static final String ENTITY = "entity";
    private static final String ENTITYNAME = "entityname";
    private static final String ISRELEASE = "isrelease";
    private static final String ENTRYENTITY = "entryentity";
    private String[] fields = new String[]{"billno", "billstatus", "entry_report_workhour", "entry_standard_workhour", "creator", "planroom", "modifier", "auditor", "auditdate", "modifytime", "createtime", "viewscheme", "entity", "version", "ispush", "isnosetotail", "nosetotail", "entry_project", "entry_contract", "entry_workhour", "billtype"};

    public void afterCreateNewData(EventObject e) {
        this.createEntryData();
    }

    private void createEntryData() {
        List entitys = this.loadMetaData();
        List<String> ls = Arrays.asList(this.fields);
        if (!entitys.isEmpty()) {
            int[] entryentities;
            for (int i : entryentities = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, entitys.size())) {
                ArrayList entity = (ArrayList)entitys.get(i - 1);
                if (((String)entity.get(0)).contains("_dif")) continue;
                this.getModel().setValue(FIELD, entity.get(0), i - 1);
                this.getModel().setValue(FIELDNAME, entity.get(1), i - 1);
                this.getModel().setValue(ENTITY, entity.get(2), i - 1);
                this.getModel().setValue(ENTITYNAME, entity.get(3), i - 1);
                if (ls.contains(entity.get(0))) {
                    this.getModel().setValue(ISRELEASE, (Object)false, i - 1);
                    this.getView().setEnable(Boolean.valueOf(false), i - 1, new String[]{ISRELEASE});
                    continue;
                }
                this.getModel().setValue(ISRELEASE, (Object)true, i - 1);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.lockRelease();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockRelease();
    }

    private void lockRelease() {
        List<String> ls = Arrays.asList(this.fields);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryentity.get(i);
            if (!ls.contains(entry.getString(FIELD))) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{ISRELEASE});
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.selectRows(-1);
    }

    private List loadMetaData() {
        ArrayList ls = Lists.newArrayList();
        MainEntityType mdt = MetadataServiceHelper.getDataEntityType((String)"pmpd_resourceplan");
        if (mdt instanceof BillEntityType) {
            BillEntityType bet = (BillEntityType)mdt;
            ArrayList result = bet.getProperties().stream().collect(ArrayList::new, (l1, p) -> {
                if (this.isMatch((IDataEntityProperty)p)) {
                    ArrayList<String> tempLs = new ArrayList<String>(4);
                    tempLs.add(0, p.getName());
                    tempLs.add(1, p.getDisplayName().getLocaleValue());
                    tempLs.add(2, bet.getName());
                    tempLs.add(3, bet.getDisplayName().getLocaleValue());
                    l1.add(tempLs);
                }
            }, (l1, l2) -> l2.add(l1));
            ls.addAll(result);
            ArrayList eresult = bet.getProperties().stream().collect(ArrayList::new, (l1, p) -> {
                if (this.isMatchEntry((IDataEntityProperty)p)) {
                    ArrayList<String> tempLs = new ArrayList<String>(4);
                    tempLs.add(0, p.getName());
                    tempLs.add(1, p.getDisplayName().getLocaleValue());
                    tempLs.add(2, bet.getName());
                    tempLs.add(3, bet.getDisplayName().getLocaleValue());
                    l1.add(tempLs);
                }
            }, (l1, l2) -> l2.add(l1));
            ls.addAll(eresult);
        }
        return ls;
    }

    private boolean isMatch(IDataEntityProperty p) {
        boolean dbField = !StringUtils.isBlank((CharSequence)p.getAlias());
        boolean isBaseID = !p.getName().contains("_id");
        boolean isID = !StringUtils.equals((CharSequence)p.getName(), (CharSequence)"id");
        boolean isst = !StringUtils.equals((CharSequence)p.getName(), (CharSequence)"pulishstatus");
        boolean isenty = !(p instanceof EntryProp);
        boolean isdif = !p.getName().contains("_dif");
        boolean isentity = !StringUtils.equals((CharSequence)p.getName(), (CharSequence)"changeentity");
        return dbField && isID & isst && isBaseID && isenty && isdif && isentity;
    }

    private boolean isMatchEntry(IDataEntityProperty p) {
        boolean isenty = p instanceof EntryProp;
        boolean islk = !p.getName().contains("_lk");
        return isenty && islk;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)"reset")) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().createNewEntryRow(ENTRYENTITY);
            this.createEntryData();
        }
    }
}

