/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base.project;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.pmc.pmps.business.task.helper.SmlarProjRecsHelper;
import kd.pmc.pmps.business.task.model.TaskRunTimeInfo;

public class CalcSimilarLogEditPlugin
extends AbstractFormPlugin
implements ProgresssListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        EntryGrid entryControl = (EntryGrid)this.getView().getControl("entry");
        entryControl.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        this.updateProcessBar(bar, null);
    }

    private void updateResult() {
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        DynamicObjectCollection logEntrys = dataModel.getEntryEntity("entry");
        HashSet<Long> longEntryIds = new HashSet<Long>(logEntrys.size());
        HashSet<Long> entryIds = new HashSet<Long>(logEntrys.size());
        for (DynamicObject logEntry : logEntrys) {
            String itemstatus;
            String string = itemstatus = logEntry.get("itemstatus") == null ? "null" : logEntry.get("itemstatus").toString();
            String caclDetialId = logEntry.getString("calresultid");
            if (StringUtils.isEmpty((CharSequence)caclDetialId)) continue;
            Long entryId = logEntry.getPkValue() == null ? 0L : Long.parseLong(logEntry.getPkValue().toString());
            entryIds.add(entryId);
            if (!"B".equals(itemstatus)) continue;
            Long detialId = Long.parseLong(caclDetialId);
            longEntryIds.add(detialId);
        }
        if (entryIds.isEmpty() || longEntryIds.isEmpty()) {
            return;
        }
        try (AlgoContext context = Algo.newContext();){
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("entityno", new Object[0]);
            vs.addField("project", new Object[0]);
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fentryid,fbillno,fcalresultid from t_pmpd_calcsplogentry where", new Object[0]).appendIn("fentryid", new ArrayList(entryIds));
            DataSet dsEntry = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"pmc"), (SqlBuilder)sql);
            dsEntry = dsEntry.select("fentryid,fbillno,Cast(fcalresultid as Long) fcalresultid");
            sql = new SqlBuilder();
            sql.append("select fid,fprojectid from T_PMPD_SMLARPROJECT where", new Object[0]).appendIn("fid", new ArrayList(longEntryIds));
            DataSet dsSimilar = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"pmc"), (SqlBuilder)sql);
            dsSimilar = dsSimilar.leftJoin(dsEntry).on("fid", "fcalresultid").select(new String[]{"fid", "fprojectid"}, new String[]{"fbillno"}).finish();
            for (Row d : dsSimilar) {
                vs.addRow(new Object[]{d.get("fid"), d.get("fbillno"), d.get("fprojectid")});
            }
            dataModel.batchCreateNewEntryRow("resultentry", vs);
        }
        dataModel.endInit();
        this.getView().updateView("resultentry");
    }

    private void updateProcessBar(ProgressBar bar, ProgressEvent e) {
        IFormView fromView = this.getView().getParentView();
        boolean islistView = fromView instanceof ListView;
        DynamicObjectCollection logEntrys = this.getModel().getEntryEntity("entry");
        if (logEntrys.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u8fd0\u7b97\u9879\u76ee\u3002", (String)"CalcSimilarLogEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            if (bar != null) {
                bar.setPercent(100);
            } else {
                e.setProgress(100);
            }
            return;
        }
        BigDecimal totalPS = new BigDecimal(logEntrys.size());
        long maxEndtime = 0L;
        int mark = 0;
        BigDecimal currPS = BigDecimal.ZERO;
        for (int i = 0; i < logEntrys.size(); ++i) {
            long temptime = 0L;
            String taskId = ((DynamicObject)logEntrys.get(i)).getString("taskid");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo == null) continue;
            this.setEntryStatusAndDetail(taskInfo, i);
            if (!taskInfo.isTaskEnd()) continue;
            currPS = currPS.add(BigDecimal.ONE);
            temptime = taskInfo.getEndTime();
            if (mark == 0) {
                maxEndtime = temptime;
            }
            if (temptime > maxEndtime) {
                maxEndtime = temptime;
            }
            ++mark;
        }
        int progress = currPS.divide(totalPS, 2, RoundingMode.HALF_DOWN).multiply(new BigDecimal(100)).intValue();
        if (bar != null) {
            bar.setPercent(progress);
        } else {
            e.setProgress(progress);
        }
        this.getModel().setValue("calculatepro", (Object)progress);
        if (progress == 100) {
            Date sttime = (Date)this.getModel().getValue("starttime");
            long callong = maxEndtime - sttime.getTime();
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(maxEndtime);
            this.getModel().setValue("endtime", (Object)c.getTime());
            this.getModel().setValue("totalcost", (Object)callong);
            this.getModel().setValue("calculatepro", (Object)progress);
            this.getModel().setValue("calstatus", (Object)"B");
            OperationResult rs = OperationServiceHelper.executeOperate((String)"save", (String)"pmpd_calcsimilar_log", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, null);
            this.updateResult();
            this.getModel().setDataChanged(false);
        }
    }

    public void onProgress(ProgressEvent e) {
        this.updateProcessBar(null, e);
    }

    private void setEntryStatusAndDetail(TaskInfo taskInfo, int i) {
        String status = taskInfo.getStatus();
        Long entityid = StringUtils.isBlank((Object)this.getModel().getValue("entityid", i)) ? 0L : Long.parseLong(this.getModel().getValue("entityid", i).toString());
        DynamicObject logObj = this.getModel().getDataEntity();
        TaskRunTimeInfo rInfo = new TaskRunTimeInfo(logObj.getLong("id"), entityid.longValue());
        DynamicObject smlarProjRecs = SmlarProjRecsHelper.getDetailid((TaskRunTimeInfo)rInfo);
        if (smlarProjRecs != null) {
            this.getModel().setValue("calresult", (Object)smlarProjRecs.getString("billno"), i);
            this.getModel().setValue("calresultid", (Object)smlarProjRecs.getLong("id"), i);
        }
        if ("COMPLETED".equals(status)) {
            this.getModel().setValue("itemstatus", (Object)"B", i);
            long cost = taskInfo.getEndTime() - taskInfo.getDispachTime();
            this.getModel().setValue("cost", (Object)cost, i);
        } else if ("FAILED".equals(status)) {
            this.getModel().setValue("itemstatus", (Object)"C", i);
            long cost = taskInfo.getEndTime() - taskInfo.getDispachTime();
            String failureReason = taskInfo.getFailureReason();
            if (failureReason != null && failureReason.length() > 1980) {
                failureReason = taskInfo.getFailureReason().substring(0, 1980);
            }
            this.getModel().setValue("calresult", (Object)failureReason, i);
            this.getModel().setValue("calresultid", null, i);
            this.getModel().setValue("cost", (Object)cost, i);
        } else if ("RUNNING".equals(status)) {
            this.getModel().setValue("cost", (Object)"A", i);
            long cost = taskInfo.getRunTime() - taskInfo.getDispachTime();
            this.getModel().setValue("cost", (Object)cost, i);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"calresult")) {
            Long resultId = StringUtils.isBlank((Object)dataModel.getValue("calresultid")) ? 0L : Long.parseLong(dataModel.getValue("calresultid").toString());
            if (resultId == 0L) {
                return;
            }
            this.showDetailLog(resultId);
        }
    }

    private void showDetailLog(Object pkValue) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId("pmpd_smlarprojrecs");
        param.setPkId(pkValue);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)"btnstop")) {
            String calStatus;
            AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
            String string = calStatus = dataModel.getValue("calstatus") == null ? "" : dataModel.getValue("calstatus").toString();
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)calStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u6267\u884c\u5b8c\u6bd5\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u8fd0\u7b97\u64cd\u4f5c\u3002", (String)"CalcSimilarLogListPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entrys = dataModel.getEntryEntity("entry");
            if (entrys.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u9879\u76ee\u8fdb\u884c\u8fd0\u7b97\u3002", (String)"CalcSimilarLogListPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject entry : entrys) {
                String taskid = entry.getString("taskid");
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskid);
                if (taskInfo == null || taskInfo.isTaskEnd()) continue;
                ScheduleServiceHelper.stopTask((String)taskid);
            }
            DB.execute((DBRoute)DBRoute.of((String)"pmc"), (String)"update t_pmpd_calcsmlplog set fcalstatus = 'D' where fid = ? ", (Object[])new Object[]{dataModel.getValue("id")});
            this.getView().updateView("calstatus");
        }
    }
}

