/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base.project;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class CalcSimilarLogListPlugin
extends AbstractListPlugin {
    private long orgId = 0L;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        CommonFilterColumn orgColumn = this.buildOrgFilterColumn();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (filterColumnList.contains(orgColumn)) {
            FilterColumn orgColumnt = filterColumnList.stream().filter(a -> a.equals((Object)orgColumn)).findFirst().get();
            this.orgId = RequestContext.get().getOrgId();
            orgColumnt.setDefaultValue(String.valueOf(this.orgId));
        }
    }

    private CommonFilterColumn buildOrgFilterColumn() {
        String mainOrgKey = this.getBillEntityType().getMainOrg();
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setKey(mainOrgKey + ".id");
        orgColumn.setMustInput(true);
        orgColumn.setType("enum");
        orgColumn.setCaption(new LocaleString(mainOrgKey));
        orgColumn.setFieldName("projectorg.name");
        orgColumn.setEntityField(false);
        orgColumn.setMulti(true);
        orgColumn.setMultiLine(true);
        return orgColumn;
    }

    private BillEntityType getBillEntityType() {
        return (BillEntityType)((IListView)this.getView()).getListModel().getDataEntityType();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("btnstop")) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = list.getCurrentSelectedRowInfo();
            if (row == null) {
                return;
            }
            Object pk = row.getPrimaryKeyValue();
            DynamicObject logObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pmpd_calcsimilar_log");
            if (!StringUtils.equals((CharSequence)logObj.getString("calstatus"), (CharSequence)"A")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u6267\u884c\u5b8c\u6bd5\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u8fd0\u7b97\u64cd\u4f5c\u3002", (String)"CalcSimilarLogListPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entrys = logObj.getDynamicObjectCollection("entry");
            if (entrys.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u9879\u76ee\u8fdb\u884c\u8fd0\u7b97\u3002", (String)"CalcSimilarLogListPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject entry : entrys) {
                String taskid = entry.getString("taskid");
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskid);
                if (taskInfo.isTaskEnd()) continue;
                ScheduleServiceHelper.stopTask((String)taskid);
            }
            logObj.set("calstatus", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
            this.getView().updateView("combolistcolumnap");
        }
    }
}

