/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base.project;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bd.assistant.plugin.util.TimeUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ProjectApprovalEditPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sourceType = (String)this.getModel().getValue("sourcetype");
        if (StringUtils.equals((CharSequence)"B", (CharSequence)sourceType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry", "deleteentry"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"expstartdate", (CharSequence)key) || StringUtils.equals((CharSequence)"expfinshdate", (CharSequence)key)) {
            this.calculatePeriod();
        }
    }

    private void calculatePeriod() {
        Date expstartdate = (Date)this.getModel().getValue("expstartdate");
        Date expfinshdate = (Date)this.getModel().getValue("expfinshdate");
        if (StringUtils.isNotBlank((Object)expstartdate) && StringUtils.isNotBlank((Object)expfinshdate)) {
            int estperiod = this.daysBetween(expstartdate, expfinshdate);
            if (estperiod < 1) {
                this.getModel().setValue("expfinshdate", null);
                estperiod = 0;
            }
            this.getModel().setValue("estperiod", (Object)estperiod);
        } else {
            this.getModel().setValue("estperiod", (Object)0);
        }
    }

    private int daysBetween(Date startdate, Date finshdate) {
        int beteen = 0;
        if (null == startdate || null == finshdate) {
            return beteen;
        }
        Calendar expstartdateCdr = Calendar.getInstance();
        Calendar expfinshdateCdr = Calendar.getInstance();
        expstartdateCdr.set(1, startdate.getYear());
        expstartdateCdr.set(2, startdate.getMonth());
        expstartdateCdr.set(5, startdate.getDate());
        expfinshdateCdr.set(1, finshdate.getYear());
        expfinshdateCdr.set(2, finshdate.getMonth());
        expfinshdateCdr.set(5, finshdate.getDate());
        beteen = TimeUtils.daysBetween((Calendar)expstartdateCdr, (Calendar)expfinshdateCdr);
        return beteen;
    }
}

