/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base.project;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.query.QueryEntityParseHelper;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;

public class SimilarProjectEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PMPD_PROJECT = "pmpd_project";
    private static final String prop = "prop";
    private static final String NUMBER = "number";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"filteralias", "entityfield", "projectfield", "holdfilteralias"});
        BasedataEdit projectCotl = (BasedataEdit)this.getView().getControl("projectorg");
        projectCotl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit holdObjectCotl = (BasedataEdit)this.getView().getControl("holdobject");
        holdObjectCotl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        IDataModel idataModel = this.getModel();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"filteralias")) {
            String conditionJson = (String)idataModel.getValue("filterjson_tag");
            this.doClickFilterText(PMPD_PROJECT, conditionJson, "filteralias");
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"entityfield")) {
            DynamicObject entityObject = (DynamicObject)idataModel.getValue("entityobject");
            if (entityObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"SimilarProjectEditPlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            } else {
                String entityNumber = (String)entityObject.getPkValue();
                int row = idataModel.getEntryCurrentRowIndex("mainelement");
                String entityfieldprop = (String)idataModel.getValue("entityfieldprop", row);
                String expression = null;
                if (StringUtils.isNotBlank((CharSequence)entityfieldprop)) {
                    ExpressionProperty prop = (ExpressionProperty)SerializationUtils.fromJsonString((String)entityfieldprop, ExpressionProperty.class);
                    expression = prop.getExpression();
                }
                this.showValueExpression(entityNumber, "entityfield", expression);
            }
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"projectfield")) {
            int row = idataModel.getEntryCurrentRowIndex("mainelement");
            String entityfieldprop = (String)idataModel.getValue("projectfieldprop", row);
            String expression = null;
            if (StringUtils.isNotBlank((CharSequence)entityfieldprop)) {
                ExpressionProperty prop = (ExpressionProperty)SerializationUtils.fromJsonString((String)entityfieldprop, ExpressionProperty.class);
                expression = prop.getExpression();
            }
            this.showValueExpression(PMPD_PROJECT, "projectfield", expression);
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"holdfilteralias")) {
            int row = idataModel.getEntryCurrentRowIndex("holdelement");
            DynamicObject entityObj = (DynamicObject)idataModel.getValue("holdobject", row);
            if (entityObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9608\u503c\u5bf9\u8c61\u3002", (String)"SimilarProjectEditPlugin_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            } else {
                String entityNumber = (String)entityObj.getPkValue();
                String conditionJson = (String)idataModel.getValue("holdfilterjson_tag", row);
                this.doClickFilterText(entityNumber, conditionJson, "holdfilteralias");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        IDataEntityProperty dataEntityProperty = e.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return;
        }
        Object newObj = e.getChangeSet()[0].getNewValue();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"holdobject")) {
            int row = this.getModel().getEntryCurrentRowIndex("holdelement");
            this.getModel().beginInit();
            this.getModel().setValue("holdfilterjson_tag", null, row);
            this.getModel().setValue("holdfilteralias", null, row);
            Object oldObj = e.getChangeSet()[0].getOldValue();
            if (newObj == null) {
                return;
            }
            DynamicObject holdObject = (DynamicObject)newObj;
            String entityNumber = holdObject.getString(NUMBER);
            if (!this.isExistsProjectField(entityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u9608\u503c\u5bf9\u8c61\u4e0d\u5305\u542b\u9879\u76ee\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SimilarProjectEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("holdobject", oldObj, row);
            }
            this.getModel().endInit();
            this.getView().updateView("holdfilterjson_tag", row);
            this.getView().updateView("holdfilteralias", row);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"entityobject")) {
            this.getModel().deleteEntryData("mainelement");
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"entityfield")) {
            if (newObj == null || StringUtils.isBlank((Object)newObj)) {
                int row = this.getModel().getEntryCurrentRowIndex("mainelement");
                this.getModel().setValue("entityfieldprop", null, row);
                return;
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"projectfield") && (newObj == null || StringUtils.isBlank((Object)newObj))) {
            int row = this.getModel().getEntryCurrentRowIndex("mainelement");
            this.getModel().setValue("projectfieldprop", null, row);
            return;
        }
    }

    private boolean isExistsProjectField(String entityNumber) {
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return Boolean.FALSE;
        }
        MainEntityType mEntity = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection dataProperties = mEntity.getProperties();
        for (IDataEntityProperty dataProperty : dataProperties) {
            String baseEntityId;
            if (dataProperty instanceof BasedataProp && StringUtils.equals((CharSequence)(baseEntityId = ((BasedataProp)dataProperty).getBaseEntityId()), (CharSequence)PMPD_PROJECT)) {
                return Boolean.TRUE;
            }
            if (!(dataProperty instanceof EntryProp)) continue;
            return this.checkEntryProp(dataProperty);
        }
        return Boolean.FALSE;
    }

    private boolean checkEntryProp(IDataEntityProperty dataProperty) {
        EntryProp entryFields = (EntryProp)dataProperty;
        IDataEntityType itemType = entryFields.getItemType();
        if (itemType != null) {
            DataEntityPropertyCollection properties = itemType.getProperties();
            for (IDataEntityProperty property : properties) {
                String baseEntityId;
                if (property instanceof BasedataProp && StringUtils.equals((CharSequence)(baseEntityId = ((BasedataProp)property).getBaseEntityId()), (CharSequence)PMPD_PROJECT)) {
                    return Boolean.TRUE;
                }
                if (!(property instanceof EntryProp)) continue;
                return this.checkEntryProp(property);
            }
        }
        return Boolean.FALSE;
    }

    private void showValueExpression(String entityNumber, String sourceKey, String expression) {
        FormShowParameter ShowParameter = new FormShowParameter();
        ShowParameter.setFormId("mpdm_valueexpression");
        ShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        ShowParameter.setCustomParam("expression", (Object)expression);
        ShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceKey));
        ShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(ShowParameter);
    }

    private void doClickFilterText(String entityNumber, String conditionJson, String sourceCtrlKey) {
        BillEntityType mainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a[%s]\u7684\u5b9e\u4f53\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SimilarProjectEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[]{entityNumber}));
        } else {
            QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter((MainEntityType)mainType);
            TreeNode billTreeNode = QueryEntityParseHelper.buildBillTreeNodes((QueryEntityTreeBuildParameter)parameter, (boolean)false, null);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            this.showConditionForm(conditionJson, mainType.getName(), fldNodes, sourceCtrlKey);
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.setCustomParam("formula", (Object)conditionJson);
        showParameter.setCustomParam("entitynumber", (Object)entityNumber);
        showParameter.setCustomParam("treenodes", (Object)fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"filteralias")) {
            String returndata = (String)e.getReturnData();
            this.receiveCondition(returndata, null, "filterjson_tag", "filteralias");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"holdfilteralias")) {
            String returndata = (String)e.getReturnData();
            this.receiveCondition(returndata, "holdelement", "holdfilterjson_tag", "holdfilteralias");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"entityfield")) {
            this.receiveEntityprop(e, "entityfield", "entityfieldprop");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"projectfield")) {
            this.receiveEntityprop(e, "projectfield", "projectfieldprop");
        }
    }

    private void receiveEntityprop(ClosedCallBackEvent e, String entityField, String propField) {
        if (e == null || StringUtils.isEmpty((CharSequence)entityField) || StringUtils.isEmpty((CharSequence)propField)) {
            return;
        }
        Map returndata = (Map)e.getReturnData();
        if (returndata == null || !returndata.containsKey(prop)) {
            return;
        }
        IDataModel model = this.getModel();
        int rowindex = model.getEntryCurrentRowIndex("mainelement");
        String propStr = (String)returndata.get(prop);
        ExpressionProperty prop = (ExpressionProperty)SerializationUtils.fromJsonString((String)propStr, ExpressionProperty.class);
        boolean isRepeat = Boolean.FALSE;
        if (StringUtils.equals((CharSequence)entityField, (CharSequence)"entityfield")) {
            isRepeat = this.checkRepeat(model, rowindex, prop, "projectfieldprop");
        } else if (StringUtils.equals((CharSequence)entityField, (CharSequence)"projectfield")) {
            isRepeat = this.checkRepeat(model, rowindex, prop, "entityfieldprop");
        }
        if (!isRepeat) {
            model.setValue(entityField, (Object)prop.getFullName(), rowindex);
            model.setValue(propField, (Object)propStr, rowindex);
        }
    }

    private boolean checkRepeat(IDataModel model, int rowindex, ExpressionProperty prop, String keyField) {
        Object otherfieldprop = model.getValue(keyField, rowindex);
        if (otherfieldprop != null && StringUtils.isNotBlank((Object)otherfieldprop)) {
            ExpressionProperty otherProp = (ExpressionProperty)SerializationUtils.fromJsonString((String)otherfieldprop.toString(), ExpressionProperty.class);
            String entityfieldkey = null;
            String projectFieldKey = null;
            if (StringUtils.equals((CharSequence)keyField, (CharSequence)"projectfieldprop")) {
                entityfieldkey = prop.getExpression();
                projectFieldKey = otherProp.getExpression();
            } else {
                entityfieldkey = otherProp.getExpression();
                projectFieldKey = prop.getExpression();
            }
            int mainRowCount = model.getEntryRowCount("mainelement");
            for (int i = 0; i < mainRowCount; ++i) {
                String itemProjectPropStr;
                String itemEntityPropStr;
                if (i == rowindex) continue;
                String string = itemEntityPropStr = model.getValue("entityfieldprop", i) == null ? null : model.getValue("entityfieldprop", i).toString();
                if (StringUtils.isEmpty(itemEntityPropStr)) continue;
                ExpressionProperty itemEntityProp = (ExpressionProperty)SerializationUtils.fromJsonString((String)itemEntityPropStr, ExpressionProperty.class);
                String itemEntityfieldkey = itemEntityProp.getExpression();
                String string2 = itemProjectPropStr = model.getValue("projectfieldprop", i) == null ? null : model.getValue("projectfieldprop", i).toString();
                if (StringUtils.isEmpty(itemProjectPropStr)) continue;
                ExpressionProperty itemProjectProp = (ExpressionProperty)SerializationUtils.fromJsonString((String)itemProjectPropStr, ExpressionProperty.class);
                String itemProjectfieldkey = itemProjectProp.getExpression();
                if (!StringUtils.equals((CharSequence)entityfieldkey, (CharSequence)itemEntityfieldkey) || !StringUtils.equals((CharSequence)projectFieldKey, (CharSequence)itemProjectfieldkey)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u5b9e\u4f53\u5b57\u6bb5\u548c\u9879\u76ee\u5b57\u6bb5\u7684\u4e3b\u8981\u7d20\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SimilarProjectEditPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        IDataModel model = this.getModel();
        model.beginInit();
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                model.setValue(conditionFldKey, (Object)conditionJson);
                model.setValue(descFldKey, (Object)exprTran);
                model.endInit();
                this.getView().updateView(conditionFldKey);
                this.getView().updateView(descFldKey);
            } else {
                int row = model.getEntryCurrentRowIndex(entryEntityKey);
                if (this.checkHoldRepeat(model, exprTran, row)) {
                    return;
                }
                model.setValue(conditionFldKey, (Object)conditionJson, row);
                model.setValue(descFldKey, (Object)exprTran, row);
                model.endInit();
                this.getView().updateView(conditionFldKey, row);
                this.getView().updateView(descFldKey, row);
            }
        }
    }

    private boolean checkHoldRepeat(IDataModel model, String exprTran, int row) {
        DynamicObject holdObj;
        DynamicObject dynamicObject = holdObj = model.getValue("holdobject", row) == null ? null : (DynamicObject)model.getValue("holdobject", row);
        if (holdObj == null) {
            return false;
        }
        int mainRowCount = model.getEntryRowCount("holdelement");
        for (int i = 0; i < mainRowCount; ++i) {
            DynamicObject rowHoldObj;
            String looperExprTran = model.getValue("holdfilteralias", i) == null ? "XX" : model.getValue("holdfilteralias", i).toString();
            DynamicObject dynamicObject2 = rowHoldObj = model.getValue("holdobject") == null ? null : (DynamicObject)model.getValue("holdobject");
            if (rowHoldObj == null) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)holdObj.getString(NUMBER), (CharSequence)rowHoldObj.getString(NUMBER)) || !StringUtils.equals((CharSequence)exprTran, (CharSequence)looperExprTran)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u9608\u503c\u5bf9\u8c61\u76f8\u540c\u8fc7\u6ee4\u6761\u4ef6\u7684\u9608\u503c\u8981\u7d20\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SimilarProjectEditPlugin_7", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control source = (Control)e.getSource();
        String sourceKey = source.getKey();
        if (StringUtils.equals((CharSequence)"projectorg", (CharSequence)sourceKey)) {
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            List orgIds = orgService.getAllOrg("ProjectManageSchemeDefault");
            QFilter qfilter = new QFilter("id", "in", (Object)orgIds);
            param.getListFilterParameter().getQFilters().add(qfilter);
        }
    }
}

